/*
 * Decompiled with CFR 0.152.
 */
package com.weibo.breeze.serializer;

import com.weibo.breeze.BreezeBuffer;
import com.weibo.breeze.BreezeException;
import com.weibo.breeze.BreezeReader;
import com.weibo.breeze.BreezeWriter;
import com.weibo.breeze.serializer.Serializer;
import com.weibo.breeze.type.Types;
import java.math.BigInteger;

public class BigIntegerSerializer
implements Serializer<BigInteger> {
    private static final String[] names = new String[]{BigInteger.class.getName()};

    @Override
    public void writeToBuf(BigInteger obj, BreezeBuffer buffer) throws BreezeException {
        BreezeWriter.writeMessage(buffer, () -> Types.TYPE_STRING.writeMessageField(buffer, 1, obj.toString()));
    }

    @Override
    public BigInteger readFromBuf(BreezeBuffer buffer) throws BreezeException {
        BigInteger[] objects = new BigInteger[1];
        BreezeReader.readMessage(buffer, index -> {
            switch (index) {
                case 1: {
                    objects[0] = new BigInteger((String)Types.TYPE_STRING.read(buffer));
                }
            }
        });
        return objects[0];
    }

    @Override
    public String[] getNames() {
        return names;
    }
}

