/*
 * Decompiled with CFR 0.152.
 */
package io.fury.util.unsafe;

import io.fury.util.Platform;
import java.util.ArrayList;

public class _Collections {
    private static final boolean FAST_MODE;

    public static void setArrayListElements(ArrayList list, Object[] elements) {
        if (FAST_MODE) {
            Platform.putInt(list, Offset.ARRAY_LIST_SIZE_OFFSET, elements.length);
            Platform.putObject(list, Offset.ARRAY_LIST_ARRAY_OFFSET, elements);
        } else {
            for (Object element : elements) {
                list.add(element);
            }
        }
    }

    static {
        boolean fastMode;
        try {
            fastMode = Offset.ARRAY_LIST_ARRAY_OFFSET != -1L;
        }
        catch (Throwable e) {
            fastMode = false;
        }
        FAST_MODE = fastMode;
    }

    private static class Offset {
        private static final long ARRAY_LIST_SIZE_OFFSET;
        private static final long ARRAY_LIST_ARRAY_OFFSET;

        private Offset() {
        }

        static {
            try {
                ARRAY_LIST_SIZE_OFFSET = Platform.objectFieldOffset(ArrayList.class.getDeclaredField("size"));
                ARRAY_LIST_ARRAY_OFFSET = Platform.objectFieldOffset(ArrayList.class.getDeclaredField("elementData"));
            }
            catch (NoSuchFieldException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

