/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.dubbo.rpc.AsyncContext;
import org.apache.dubbo.rpc.AttachmentsAdapter;
import org.apache.dubbo.rpc.RpcContext;
import org.apache.dubbo.rpc.RpcContextAttachment;

public class RpcServerContextAttachment
extends RpcContextAttachment {
    @Override
    public RpcContextAttachment copyOf(boolean needCopy) {
        throw new RuntimeException("copyOf internal method, should not be invoke");
    }

    @Override
    protected boolean isValid() {
        throw new RuntimeException("isValid of is internal method, should not be invoke");
    }

    @Override
    public RpcContextAttachment setObjectAttachment(String key, Object value) {
        RpcContext.getServerResponseContext().setObjectAttachment(key, value);
        return this;
    }

    @Override
    protected void setAsyncContext(AsyncContext asyncContext) {
        RpcContext.getServerResponseContext().setAsyncContext(asyncContext);
    }

    @Override
    public boolean isAsyncStarted() {
        return RpcContext.getServerResponseContext().isAsyncStarted();
    }

    @Override
    public boolean stopAsync() {
        return RpcContext.getServerResponseContext().stopAsync();
    }

    @Override
    public AsyncContext getAsyncContext() {
        return RpcContext.getServerResponseContext().getAsyncContext();
    }

    @Override
    public String getAttachment(String key) {
        Object attachment = this.getObjectAttachment(key);
        if (attachment instanceof String) {
            return (String)attachment;
        }
        return null;
    }

    @Override
    public Object getObjectAttachment(String key) {
        Object fromServerResponse = RpcContext.getServerResponseContext().getObjectAttachment(key);
        if (fromServerResponse == null) {
            fromServerResponse = RpcContext.getClientResponseContext().getObjectAttachment(key);
        }
        return fromServerResponse;
    }

    @Override
    public RpcContextAttachment setAttachment(String key, String value) {
        return RpcContext.getServerResponseContext().setAttachment(key, value);
    }

    @Override
    public RpcContextAttachment setAttachment(String key, Object value) {
        return RpcContext.getServerResponseContext().setAttachment(key, value);
    }

    @Override
    public RpcContextAttachment removeAttachment(String key) {
        RpcContext.getServerResponseContext().removeAttachment(key);
        RpcContext.getClientResponseContext().removeAttachment(key);
        return this;
    }

    @Override
    public Map<String, String> getAttachments() {
        return new AttachmentsAdapter.ObjectToStringMap(new ObjectAttachmentMap(this));
    }

    @Override
    public Map<String, Object> getObjectAttachments() {
        return new ObjectAttachmentMap(this);
    }

    @Override
    public RpcContextAttachment setAttachments(Map<String, String> attachment) {
        RpcContext.getServerResponseContext().setAttachments((Map)attachment);
        RpcContext.getClientResponseContext().clearAttachments();
        return this;
    }

    @Override
    public RpcContextAttachment setObjectAttachments(Map<String, Object> attachment) {
        RpcContext.getServerResponseContext().setObjectAttachments((Map)attachment);
        RpcContext.getClientResponseContext().clearAttachments();
        return this;
    }

    @Override
    public void clearAttachments() {
        RpcContext.getServerResponseContext().clearAttachments();
        RpcContext.getClientResponseContext().clearAttachments();
    }

    @Override
    public Map<String, Object> get() {
        return this.getObjectAttachments();
    }

    @Override
    public RpcContextAttachment set(String key, Object value) {
        return this.setAttachment(key, value);
    }

    @Override
    public RpcContextAttachment remove(String key) {
        return this.removeAttachment(key);
    }

    @Override
    public Object get(String key) {
        return this.getAttachment(key);
    }

    static class ObjectAttachmentMap
    implements Map<String, Object> {
        private final RpcServerContextAttachment adapter;

        public ObjectAttachmentMap(RpcServerContextAttachment adapter) {
            this.adapter = adapter;
        }

        private Map<String, Object> getAttachments() {
            Map<String, Object> clientResponse = RpcContext.getClientResponseContext().getObjectAttachments();
            Map<String, Object> serverResponse = RpcContext.getServerResponseContext().getObjectAttachments();
            HashMap<String, Object> result = new HashMap<String, Object>((int)((double)clientResponse.size() + (double)serverResponse.size() / 0.75) + 1);
            result.putAll(clientResponse);
            result.putAll(serverResponse);
            return result;
        }

        @Override
        public int size() {
            return this.getAttachments().size();
        }

        @Override
        public boolean isEmpty() {
            return RpcContext.getClientResponseContext().getObjectAttachments().isEmpty() && RpcContext.getServerResponseContext().getObjectAttachments().isEmpty();
        }

        @Override
        public boolean containsKey(Object key) {
            return RpcContext.getClientResponseContext().getObjectAttachments().containsKey(key) || RpcContext.getServerResponseContext().getObjectAttachments().containsKey(key);
        }

        @Override
        public boolean containsValue(Object value) {
            return RpcContext.getClientResponseContext().getObjectAttachments().containsValue(value) || RpcContext.getServerResponseContext().getObjectAttachments().containsValue(value);
        }

        @Override
        public Object get(Object key) {
            if (key instanceof String) {
                return this.adapter.getObjectAttachment((String)key);
            }
            return null;
        }

        @Override
        public Object put(String key, Object value) {
            return this.adapter.setObjectAttachment(key, value);
        }

        @Override
        public Object remove(Object key) {
            if (key instanceof String) {
                return this.adapter.removeAttachment((String)key);
            }
            return null;
        }

        @Override
        public void putAll(Map<? extends String, ?> m) {
            for (Map.Entry<String, ?> entry : m.entrySet()) {
                this.adapter.setObjectAttachment(entry.getKey(), entry.getValue());
            }
        }

        @Override
        public void clear() {
            this.adapter.clearAttachments();
        }

        @Override
        public Set<String> keySet() {
            return this.getAttachments().keySet();
        }

        @Override
        public Collection<Object> values() {
            return this.getAttachments().values();
        }

        @Override
        public Set<Map.Entry<String, Object>> entrySet() {
            return this.getAttachments().entrySet();
        }
    }
}

