/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.config.spring.util;

import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.PropertyValues;
import org.springframework.beans.factory.annotation.AnnotatedBeanDefinition;
import org.springframework.beans.factory.config.TypedStringValue;
import org.springframework.core.type.MethodMetadata;
import org.springframework.core.type.StandardMethodMetadata;

public class SpringCompatUtils {
    private static volatile Boolean factoryMethodMetadataEnabled = null;
    private static final Log logger = LogFactory.getLog(SpringCompatUtils.class);

    public static <T> T getPropertyValue(PropertyValues pvs, String propertyName) {
        Object val;
        PropertyValue pv = pvs.getPropertyValue(propertyName);
        Object object = val = pv != null ? pv.getValue() : null;
        if (val instanceof TypedStringValue) {
            TypedStringValue typedString = (TypedStringValue)val;
            return (T)typedString.getValue();
        }
        return (T)val;
    }

    public static boolean isFactoryMethodMetadataEnabled() {
        if (factoryMethodMetadataEnabled == null) {
            try {
                AnnotatedBeanDefinition.class.getMethod("getFactoryMethodMetadata", new Class[0]);
                MethodMetadata.class.getMethod("getReturnTypeName", new Class[0]);
                factoryMethodMetadataEnabled = true;
            }
            catch (NoSuchMethodException e) {
                factoryMethodMetadataEnabled = false;
            }
        }
        return factoryMethodMetadataEnabled;
    }

    public static String getFactoryMethodReturnType(AnnotatedBeanDefinition annotatedBeanDefinition) {
        block4: {
            try {
                StandardMethodMetadata methodMetadata;
                Method introspectedMethod;
                if (SpringCompatUtils.isFactoryMethodMetadataEnabled()) {
                    MethodMetadata factoryMethodMetadata = annotatedBeanDefinition.getFactoryMethodMetadata();
                    return factoryMethodMetadata != null ? factoryMethodMetadata.getReturnTypeName() : null;
                }
                Object source = annotatedBeanDefinition.getSource();
                if (source instanceof StandardMethodMetadata && (introspectedMethod = (methodMetadata = (StandardMethodMetadata)source).getIntrospectedMethod()) != null) {
                    return introspectedMethod.getReturnType().getName();
                }
            }
            catch (Throwable e) {
                if (!logger.isInfoEnabled()) break block4;
                logger.info((Object)"get return type of AnnotatedBeanDefinition failed", e);
            }
        }
        return null;
    }

    public static MethodMetadata getFactoryMethodMetadata(AnnotatedBeanDefinition annotatedBeanDefinition) {
        if (SpringCompatUtils.isFactoryMethodMetadataEnabled()) {
            return annotatedBeanDefinition.getFactoryMethodMetadata();
        }
        Object source = annotatedBeanDefinition.getSource();
        if (source instanceof StandardMethodMetadata) {
            return (MethodMetadata)source;
        }
        return null;
    }

    public static Class getGenericTypeOfReturnType(MethodMetadata factoryMethodMetadata) {
        ParameterizedType parameterizedType;
        Type actualTypeArgument;
        Method introspectedMethod;
        Type returnType;
        if (factoryMethodMetadata instanceof StandardMethodMetadata && (returnType = (introspectedMethod = ((StandardMethodMetadata)factoryMethodMetadata).getIntrospectedMethod()).getGenericReturnType()) instanceof ParameterizedType && (actualTypeArgument = (parameterizedType = (ParameterizedType)returnType).getActualTypeArguments()[0]) instanceof Class) {
            return (Class)actualTypeArgument;
        }
        return null;
    }
}

