/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.config.spring.util;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.util.ClassUtils;

public abstract class GenericBeanPostProcessorAdapter<T>
implements BeanPostProcessor {
    private final Class<T> beanType;

    public GenericBeanPostProcessorAdapter() {
        ParameterizedType parameterizedType = (ParameterizedType)this.getClass().getGenericSuperclass();
        Type[] actualTypeArguments = parameterizedType.getActualTypeArguments();
        this.beanType = (Class)actualTypeArguments[0];
    }

    public final Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        if (ClassUtils.isAssignableValue(this.beanType, (Object)bean)) {
            return this.doPostProcessBeforeInitialization(bean, beanName);
        }
        return bean;
    }

    public final Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        if (ClassUtils.isAssignableValue(this.beanType, (Object)bean)) {
            return this.doPostProcessAfterInitialization(bean, beanName);
        }
        return bean;
    }

    public final Class<T> getBeanType() {
        return this.beanType;
    }

    protected T doPostProcessBeforeInitialization(T bean, String beanName) throws BeansException {
        this.processBeforeInitialization(bean, beanName);
        return bean;
    }

    protected T doPostProcessAfterInitialization(T bean, String beanName) throws BeansException {
        this.processAfterInitialization(bean, beanName);
        return bean;
    }

    protected void processBeforeInitialization(T bean, String beanName) throws BeansException {
    }

    protected void processAfterInitialization(T bean, String beanName) throws BeansException {
    }
}

