/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.okhttp.internal;

import java.lang.reflect.Array;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public final class Util {
    public static final String[] EMPTY_STRING_ARRAY = new String[0];
    public static final Charset UTF_8 = Charset.forName("UTF-8");

    private Util() {
    }

    public static boolean equal(Object a, Object b) {
        return a == b || a != null && a.equals(b);
    }

    public static <T> List<T> immutableList(T[] elements) {
        return Collections.unmodifiableList(Arrays.asList((Object[])elements.clone()));
    }

    public static <T> T[] intersect(Class<T> arrayType, T[] first, T[] second) {
        List<Object> result = Util.intersect(first, second);
        return result.toArray((Object[])Array.newInstance(arrayType, result.size()));
    }

    private static <T> List<T> intersect(T[] first, T[] second) {
        ArrayList<T> result = new ArrayList<T>();
        block0: for (T a : first) {
            for (T b : second) {
                if (!a.equals(b)) continue;
                result.add(b);
                continue block0;
            }
        }
        return result;
    }
}

