/*
 * Decompiled with CFR 0.152.
 */
package org.casbin.casdoor.service;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import org.casbin.casdoor.config.CasdoorConfig;
import org.casbin.casdoor.entity.CasdoorResource;
import org.casbin.casdoor.util.http.CasdoorResponse;
import org.casbin.casdoor.util.http.HttpClient;

public class CasdoorResourceService {
    private final CasdoorConfig casdoorConfig;
    private final ObjectMapper objectMapper = new ObjectMapper();

    public CasdoorResourceService(CasdoorConfig casdoorConfig) {
        this.casdoorConfig = casdoorConfig;
        this.objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }

    public CasdoorResponse uploadResource(String user, String tag, String parent, String fullFilePath, File file) throws IOException {
        String targetUrl = String.format("%s/api/upload-resource?owner=%s&user=%s&application=%s&tag=%s&parent=%s&fullFilePath=%s&clientId=%s&clientSecret=%s", this.casdoorConfig.getEndpoint(), this.casdoorConfig.getOrganizationName(), user, this.casdoorConfig.getApplicationName(), tag, parent, fullFilePath, this.casdoorConfig.getClientId(), this.casdoorConfig.getClientSecret());
        String responseStr = HttpClient.postFile(targetUrl, file);
        return (CasdoorResponse)this.objectMapper.readValue(responseStr, CasdoorResponse.class);
    }

    public CasdoorResponse deleteResource(String name) throws IOException {
        String targetUrl = String.format("%s/api/delete-resource?clientId=%s&clientSecret=%s", this.casdoorConfig.getEndpoint(), this.casdoorConfig.getClientId(), this.casdoorConfig.getClientSecret());
        CasdoorResource casdoorResource = new CasdoorResource(this.casdoorConfig.getOrganizationName(), name);
        String userStr = this.objectMapper.writeValueAsString((Object)casdoorResource);
        String responseStr = HttpClient.postString(targetUrl, userStr);
        return (CasdoorResponse)this.objectMapper.readValue(responseStr, CasdoorResponse.class);
    }
}

