/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.org.asynchttpclient.oauth;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import java.util.regex.Pattern;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.pulsar.shade.org.asynchttpclient.Param;
import org.apache.pulsar.shade.org.asynchttpclient.oauth.ConsumerKey;
import org.apache.pulsar.shade.org.asynchttpclient.oauth.Parameters;
import org.apache.pulsar.shade.org.asynchttpclient.oauth.RequestToken;
import org.apache.pulsar.shade.org.asynchttpclient.uri.Uri;
import org.apache.pulsar.shade.org.asynchttpclient.util.StringBuilderPool;
import org.apache.pulsar.shade.org.asynchttpclient.util.StringUtils;
import org.apache.pulsar.shade.org.asynchttpclient.util.Utf8UrlEncoder;

public class OAuthSignatureCalculatorInstance {
    private static final Pattern STAR_CHAR_PATTERN = Pattern.compile("*", 16);
    private static final Pattern PLUS_CHAR_PATTERN = Pattern.compile("+", 16);
    private static final Pattern ENCODED_TILDE_PATTERN = Pattern.compile("%7E", 16);
    private static final String KEY_OAUTH_CONSUMER_KEY = "oauth_consumer_key";
    private static final String KEY_OAUTH_NONCE = "oauth_nonce";
    private static final String KEY_OAUTH_SIGNATURE = "oauth_signature";
    private static final String KEY_OAUTH_SIGNATURE_METHOD = "oauth_signature_method";
    private static final String KEY_OAUTH_TIMESTAMP = "oauth_timestamp";
    private static final String KEY_OAUTH_TOKEN = "oauth_token";
    private static final String KEY_OAUTH_VERSION = "oauth_version";
    private static final String OAUTH_VERSION_1_0 = "1.0";
    private static final String OAUTH_SIGNATURE_METHOD = "HMAC-SHA1";
    private static final String HMAC_SHA1_ALGORITHM = "HmacSHA1";
    private final Mac mac;
    private final byte[] nonceBuffer = new byte[16];
    private final Parameters parameters = new Parameters();

    public OAuthSignatureCalculatorInstance() throws NoSuchAlgorithmException {
        this.mac = Mac.getInstance(HMAC_SHA1_ALGORITHM);
    }

    public String computeAuthorizationHeader(ConsumerKey consumerAuth, RequestToken userAuth, Uri uri, String method, List<Param> formParams, List<Param> queryParams) throws InvalidKeyException {
        String nonce = this.generateNonce();
        long timestamp = OAuthSignatureCalculatorInstance.generateTimestamp();
        return this.computeAuthorizationHeader(consumerAuth, userAuth, uri, method, formParams, queryParams, timestamp, nonce);
    }

    private String generateNonce() {
        ThreadLocalRandom.current().nextBytes(this.nonceBuffer);
        return Base64.getEncoder().encodeToString(this.nonceBuffer);
    }

    private static long generateTimestamp() {
        return System.currentTimeMillis() / 1000L;
    }

    String computeAuthorizationHeader(ConsumerKey consumerAuth, RequestToken userAuth, Uri uri, String method, List<Param> formParams, List<Param> queryParams, long timestamp, String nonce) throws InvalidKeyException {
        String percentEncodedNonce = Utf8UrlEncoder.percentEncodeQueryElement(nonce);
        String signature = this.computeSignature(consumerAuth, userAuth, uri, method, formParams, queryParams, timestamp, percentEncodedNonce);
        return this.computeAuthorizationHeader(consumerAuth, userAuth, signature, timestamp, percentEncodedNonce);
    }

    String computeSignature(ConsumerKey consumerAuth, RequestToken userAuth, Uri uri, String method, List<Param> formParams, List<Param> queryParams, long oauthTimestamp, String percentEncodedNonce) throws InvalidKeyException {
        StringBuilder sb = this.signatureBaseString(consumerAuth, userAuth, uri, method, formParams, queryParams, oauthTimestamp, percentEncodedNonce);
        ByteBuffer rawBase = StringUtils.charSequence2ByteBuffer(sb, StandardCharsets.UTF_8);
        byte[] rawSignature = this.digest(consumerAuth, userAuth, rawBase);
        return Base64.getEncoder().encodeToString(rawSignature);
    }

    StringBuilder signatureBaseString(ConsumerKey consumerAuth, RequestToken userAuth, Uri uri, String method, List<Param> formParams, List<Param> queryParams, long oauthTimestamp, String percentEncodedNonce) {
        String baseUrl = uri.toBaseUrl();
        String encodedParams = this.encodedParams(consumerAuth, userAuth, oauthTimestamp, percentEncodedNonce, formParams, queryParams);
        StringBuilder sb = StringBuilderPool.DEFAULT.stringBuilder();
        sb.append(method);
        sb.append('&');
        Utf8UrlEncoder.encodeAndAppendPercentEncoded(sb, baseUrl);
        sb.append('&');
        Utf8UrlEncoder.encodeAndAppendPercentEncoded(sb, encodedParams);
        return sb;
    }

    private String encodedParams(ConsumerKey consumerAuth, RequestToken userAuth, long oauthTimestamp, String percentEncodedNonce, List<Param> formParams, List<Param> queryParams) {
        this.parameters.reset();
        this.parameters.add(KEY_OAUTH_CONSUMER_KEY, consumerAuth.getPercentEncodedKey()).add(KEY_OAUTH_NONCE, percentEncodedNonce).add(KEY_OAUTH_SIGNATURE_METHOD, OAUTH_SIGNATURE_METHOD).add(KEY_OAUTH_TIMESTAMP, String.valueOf(oauthTimestamp));
        if (userAuth.getKey() != null) {
            this.parameters.add(KEY_OAUTH_TOKEN, userAuth.getPercentEncodedKey());
        }
        this.parameters.add(KEY_OAUTH_VERSION, OAUTH_VERSION_1_0);
        if (formParams != null) {
            for (Param param : formParams) {
                this.parameters.add(Utf8UrlEncoder.percentEncodeQueryElement(param.getName()), Utf8UrlEncoder.percentEncodeQueryElement(param.getValue()));
            }
        }
        if (queryParams != null) {
            for (Param param : queryParams) {
                this.parameters.add(this.percentEncodeAlreadyFormUrlEncoded(param.getName()), this.percentEncodeAlreadyFormUrlEncoded(param.getValue()));
            }
        }
        return this.parameters.sortAndConcat();
    }

    private String percentEncodeAlreadyFormUrlEncoded(String s2) {
        s2 = STAR_CHAR_PATTERN.matcher(s2).replaceAll("%2A");
        s2 = PLUS_CHAR_PATTERN.matcher(s2).replaceAll("%20");
        s2 = ENCODED_TILDE_PATTERN.matcher(s2).replaceAll("~");
        return s2;
    }

    private byte[] digest(ConsumerKey consumerAuth, RequestToken userAuth, ByteBuffer message) throws InvalidKeyException {
        StringBuilder sb = StringBuilderPool.DEFAULT.stringBuilder();
        Utf8UrlEncoder.encodeAndAppendQueryElement(sb, consumerAuth.getSecret());
        sb.append('&');
        if (userAuth != null && userAuth.getSecret() != null) {
            Utf8UrlEncoder.encodeAndAppendQueryElement(sb, userAuth.getSecret());
        }
        byte[] keyBytes = StringUtils.charSequence2Bytes(sb, StandardCharsets.UTF_8);
        SecretKeySpec signingKey = new SecretKeySpec(keyBytes, HMAC_SHA1_ALGORITHM);
        this.mac.init(signingKey);
        this.mac.update(message);
        return this.mac.doFinal();
    }

    String computeAuthorizationHeader(ConsumerKey consumerAuth, RequestToken userAuth, String signature, long oauthTimestamp, String percentEncodedNonce) {
        StringBuilder sb = StringBuilderPool.DEFAULT.stringBuilder();
        sb.append("OAuth ");
        sb.append(KEY_OAUTH_CONSUMER_KEY).append("=\"").append(consumerAuth.getPercentEncodedKey()).append("\", ");
        if (userAuth.getKey() != null) {
            sb.append(KEY_OAUTH_TOKEN).append("=\"").append(userAuth.getPercentEncodedKey()).append("\", ");
        }
        sb.append(KEY_OAUTH_SIGNATURE_METHOD).append("=\"").append(OAUTH_SIGNATURE_METHOD).append("\", ");
        sb.append(KEY_OAUTH_SIGNATURE).append("=\"");
        Utf8UrlEncoder.encodeAndAppendPercentEncoded(sb, signature).append("\", ");
        sb.append(KEY_OAUTH_TIMESTAMP).append("=\"").append(oauthTimestamp).append("\", ");
        sb.append(KEY_OAUTH_NONCE).append("=\"").append(percentEncodedNonce).append("\", ");
        sb.append(KEY_OAUTH_VERSION).append("=\"").append(OAUTH_VERSION_1_0).append("\"");
        return sb.toString();
    }
}

