/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.sofa;

import com.alipay.sofa.rpc.context.RpcInvokeContext;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.common.dto.MetaData;
import org.apache.shenyu.common.dto.RuleData;
import org.apache.shenyu.common.dto.SelectorData;
import org.apache.shenyu.common.enums.PluginEnum;
import org.apache.shenyu.common.enums.RpcTypeEnum;
import org.apache.shenyu.plugin.api.ShenyuPluginChain;
import org.apache.shenyu.plugin.api.context.ShenyuContext;
import org.apache.shenyu.plugin.api.result.ShenyuResultEnum;
import org.apache.shenyu.plugin.api.result.ShenyuResultWrap;
import org.apache.shenyu.plugin.api.utils.RequestUrlUtils;
import org.apache.shenyu.plugin.api.utils.WebFluxResultUtils;
import org.apache.shenyu.plugin.base.AbstractShenyuPlugin;
import org.apache.shenyu.plugin.sofa.proxy.SofaProxyService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class SofaPlugin
extends AbstractShenyuPlugin {
    private static final Logger LOG = LoggerFactory.getLogger(SofaPlugin.class);
    private final SofaProxyService sofaProxyService;

    public SofaPlugin(SofaProxyService sofaProxyService) {
        this.sofaProxyService = sofaProxyService;
    }

    protected String getRawPath(ServerWebExchange exchange) {
        return RequestUrlUtils.getRewrittenRawPath((ServerWebExchange)exchange);
    }

    protected Mono<Void> doExecute(ServerWebExchange exchange, ShenyuPluginChain chain, SelectorData selector, RuleData rule) {
        String param = (String)exchange.getAttribute("param_transform");
        ShenyuContext shenyuContext = (ShenyuContext)exchange.getAttribute("context");
        Objects.requireNonNull(shenyuContext);
        MetaData metaData = (MetaData)exchange.getAttribute("metaData");
        if (!this.checkMetaData(metaData)) {
            Objects.requireNonNull(metaData);
            LOG.error(" path is :{}, meta data have error.... {}", (Object)shenyuContext.getPath(), (Object)metaData);
            exchange.getResponse().setStatusCode((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
            Object error = ShenyuResultWrap.error((ServerWebExchange)exchange, (ShenyuResultEnum)ShenyuResultEnum.META_DATA_ERROR);
            return WebFluxResultUtils.result((ServerWebExchange)exchange, (Object)error);
        }
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{metaData.getParameterTypes()}) && StringUtils.isBlank((CharSequence)param)) {
            exchange.getResponse().setStatusCode((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
            Object error = ShenyuResultWrap.error((ServerWebExchange)exchange, (ShenyuResultEnum)ShenyuResultEnum.SOFA_HAVE_BODY_PARAM);
            return WebFluxResultUtils.result((ServerWebExchange)exchange, (Object)error);
        }
        Map rpcContext = (Map)exchange.getAttribute("generalContext");
        Optional.ofNullable(rpcContext).map(context -> (Map)context.get(PluginEnum.SOFA.getName())).ifPresent(context -> RpcInvokeContext.getContext().putAllRequestBaggage(context));
        Mono<Object> result = this.sofaProxyService.genericInvoker(param, metaData, exchange);
        return result.then(chain.execute(exchange));
    }

    public String named() {
        return PluginEnum.SOFA.getName();
    }

    public boolean skip(ServerWebExchange exchange) {
        return this.skipExcept(exchange, new RpcTypeEnum[]{RpcTypeEnum.SOFA});
    }

    protected Mono<Void> handleSelectorIfNull(String pluginName, ServerWebExchange exchange, ShenyuPluginChain chain) {
        return WebFluxResultUtils.noSelectorResult((String)pluginName, (ServerWebExchange)exchange);
    }

    protected Mono<Void> handleRuleIfNull(String pluginName, ServerWebExchange exchange, ShenyuPluginChain chain) {
        return WebFluxResultUtils.noRuleResult((String)pluginName, (ServerWebExchange)exchange);
    }

    public int getOrder() {
        return PluginEnum.SOFA.getCode();
    }

    private boolean checkMetaData(MetaData metaData) {
        return Objects.nonNull(metaData) && !StringUtils.isBlank((CharSequence)metaData.getMethodName()) && !StringUtils.isBlank((CharSequence)metaData.getServiceName());
    }
}

