/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.common.struct;

import com.alipay.sofa.rpc.common.utils.CommonUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public class SetDifference<T> {
    private List<T> onlyOnLeft;
    private List<T> onlyOnRight;
    private List<T> onBoth;

    public SetDifference(Set<? extends T> left, Set<? extends T> right) {
        if (CommonUtils.isEmpty(left) || CommonUtils.isEmpty(right)) {
            this.onlyOnLeft = Collections.unmodifiableList(left == null ? new ArrayList() : new ArrayList<T>(left));
            this.onlyOnRight = Collections.unmodifiableList(right == null ? new ArrayList() : new ArrayList<T>(right));
            this.onBoth = Collections.unmodifiableList(new ArrayList());
            return;
        }
        ArrayList<T> onlyOnLeft = new ArrayList<T>(left.size());
        ArrayList<T> onlyOnRight = new ArrayList<T>(right.size());
        ArrayList<T> onBoth = new ArrayList<T>(left.size());
        for (T leftValue : left) {
            if (right.contains(leftValue)) {
                onBoth.add(leftValue);
                continue;
            }
            onlyOnLeft.add(leftValue);
        }
        for (T rightValue : right) {
            if (left.contains(rightValue)) continue;
            onlyOnRight.add(rightValue);
        }
        this.onlyOnLeft = Collections.unmodifiableList(onlyOnLeft);
        this.onlyOnRight = Collections.unmodifiableList(onlyOnRight);
        this.onBoth = Collections.unmodifiableList(onBoth);
    }

    public boolean areEqual() {
        return this.onlyOnLeft.isEmpty() && this.onlyOnRight.isEmpty();
    }

    public List<T> getOnlyOnLeft() {
        return this.onlyOnLeft;
    }

    public List<T> getOnlyOnRight() {
        return this.onlyOnRight;
    }

    public List<T> getOnBoth() {
        return this.onBoth;
    }
}

