/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.codec.fury;

import com.alipay.sofa.common.config.SofaConfigs;
import com.alipay.sofa.rpc.codec.AbstractSerializer;
import com.alipay.sofa.rpc.codec.CustomSerializer;
import com.alipay.sofa.rpc.codec.common.BlackAndWhiteListFileLoader;
import com.alipay.sofa.rpc.codec.common.SerializeCheckStatus;
import com.alipay.sofa.rpc.codec.fury.serialize.SofaRequestFurySerializer;
import com.alipay.sofa.rpc.codec.fury.serialize.SofaResponseFurySerializer;
import com.alipay.sofa.rpc.common.config.RpcConfigKeys;
import com.alipay.sofa.rpc.core.exception.SofaRpcException;
import com.alipay.sofa.rpc.core.request.SofaRequest;
import com.alipay.sofa.rpc.core.response.SofaResponse;
import com.alipay.sofa.rpc.ext.Extension;
import com.alipay.sofa.rpc.transport.AbstractByteBuf;
import com.alipay.sofa.rpc.transport.ByteArrayWrapperByteBuf;
import io.fury.Fury;
import io.fury.ThreadLocalFury;
import io.fury.ThreadSafeFury;
import io.fury.config.CompatibleMode;
import io.fury.config.Language;
import io.fury.memory.MemoryBuffer;
import io.fury.resolver.AllowListChecker;
import io.fury.resolver.ClassChecker;
import java.util.List;
import java.util.Map;

@Extension(value="fury2", code=22)
public class FurySerializer
extends AbstractSerializer {
    protected final ThreadSafeFury fury;
    private final String checkerMode = (String)SofaConfigs.getOrDefault(RpcConfigKeys.SERIALIZE_CHECKER_MODE);

    public FurySerializer() {
        this.fury = new ThreadLocalFury(classLoader -> {
            Fury f = Fury.builder().withLanguage(Language.JAVA).withRefTracking(true).withCodegen(true).withNumberCompressed(true).withCompatibleMode(CompatibleMode.COMPATIBLE).requireClassRegistration(false).withClassLoader(classLoader).withAsyncCompilation(true).build();
            if (this.checkerMode.equalsIgnoreCase(SerializeCheckStatus.DISABLE.name())) {
                AllowListChecker noChecker = new AllowListChecker(AllowListChecker.CheckLevel.DISABLE);
                f.getClassResolver().setClassChecker((ClassChecker)noChecker);
                return f;
            }
            if (this.checkerMode.equalsIgnoreCase(SerializeCheckStatus.WARN.name())) {
                AllowListChecker blackListChecker = new AllowListChecker(AllowListChecker.CheckLevel.WARN);
                List<String> blackList = BlackAndWhiteListFileLoader.SOFA_SERIALIZE_BLACK_LIST;
                f.getClassResolver().setClassChecker((ClassChecker)blackListChecker);
                blackListChecker.addListener(f.getClassResolver());
                for (String key : blackList) {
                    blackListChecker.disallowClass(key + "*");
                }
            } else if (this.checkerMode.equalsIgnoreCase(SerializeCheckStatus.STRICT.name())) {
                AllowListChecker blackAndWhiteListChecker = new AllowListChecker(AllowListChecker.CheckLevel.STRICT);
                List<String> whiteList = BlackAndWhiteListFileLoader.SOFA_SERIALIZER_WHITE_LIST;
                f.getClassResolver().setClassChecker((ClassChecker)blackAndWhiteListChecker);
                blackAndWhiteListChecker.addListener(f.getClassResolver());
                for (String key : whiteList) {
                    blackAndWhiteListChecker.allowClass(key + "*");
                }
                List<String> blackList = BlackAndWhiteListFileLoader.SOFA_SERIALIZE_BLACK_LIST;
                f.getClassResolver().setClassChecker((ClassChecker)blackAndWhiteListChecker);
                blackAndWhiteListChecker.addListener(f.getClassResolver());
                for (String key : blackList) {
                    blackAndWhiteListChecker.disallowClass(key + "*");
                }
            }
            f.register(SofaRequest.class);
            f.register(SofaResponse.class);
            f.register(SofaRpcException.class);
            return f;
        });
        this.addCustomSerializer(SofaRequest.class, new SofaRequestFurySerializer(this.fury));
        this.addCustomSerializer(SofaResponse.class, new SofaResponseFurySerializer(this.fury));
    }

    @Override
    public AbstractByteBuf encode(Object object, Map<String, String> context) throws SofaRpcException {
        if (object == null) {
            throw this.buildSerializeError("Unsupported null message!");
        }
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            this.fury.setClassLoader(contextClassLoader);
            CustomSerializer customSerializer = this.getObjCustomSerializer(object);
            if (customSerializer != null) {
                AbstractByteBuf abstractByteBuf = customSerializer.encodeObject(object, context);
                return abstractByteBuf;
            }
            MemoryBuffer writeBuffer = MemoryBuffer.newHeapBuffer((int)32);
            writeBuffer.writerIndex(0);
            this.fury.serialize(writeBuffer, object);
            ByteArrayWrapperByteBuf byteArrayWrapperByteBuf = new ByteArrayWrapperByteBuf(writeBuffer.getBytes(0, writeBuffer.writerIndex()));
            return byteArrayWrapperByteBuf;
        }
        catch (Exception e) {
            throw this.buildSerializeError(e.getMessage(), e);
        }
        finally {
            this.fury.clearClassLoader(contextClassLoader);
        }
    }

    @Override
    public Object decode(AbstractByteBuf data, Class clazz, Map<String, String> context) throws SofaRpcException {
        if (data.readableBytes() <= 0 || clazz == null) {
            throw this.buildDeserializeError("Deserialized array is empty.");
        }
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            this.fury.setClassLoader(contextClassLoader);
            CustomSerializer customSerializer = this.getCustomSerializer(clazz);
            if (customSerializer != null) {
                Object t = customSerializer.decodeObject(data, context);
                return t;
            }
            MemoryBuffer readBuffer = MemoryBuffer.fromByteArray((byte[])data.array());
            Object object = this.fury.deserialize(readBuffer);
            return object;
        }
        catch (Exception e) {
            throw this.buildDeserializeError(e.getMessage(), e);
        }
        finally {
            this.fury.clearClassLoader(contextClassLoader);
        }
    }

    @Override
    public void decode(AbstractByteBuf data, Object template, Map<String, String> context) throws SofaRpcException {
        block7: {
            if (template == null) {
                throw this.buildDeserializeError("template is null!");
            }
            ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
            try {
                this.fury.setClassLoader(contextClassLoader);
                CustomSerializer customSerializer = this.getObjCustomSerializer(template);
                if (customSerializer != null) {
                    customSerializer.decodeObjectByTemplate(data, context, template);
                    break block7;
                }
                throw this.buildDeserializeError("Only support decode from SofaRequest and SofaResponse template");
            }
            catch (Exception e) {
                throw this.buildDeserializeError(e.getMessage(), e);
            }
            finally {
                this.fury.clearClassLoader(contextClassLoader);
            }
        }
    }
}

