/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.mock.generator;

import java.util.List;
import org.apache.shenyu.common.utils.JsonUtils;
import org.apache.shenyu.plugin.mock.api.MockRequest;
import org.apache.shenyu.plugin.mock.generator.Generator;
import org.apache.shenyu.plugin.mock.util.EvaluationContextUtil;
import org.apache.shenyu.spi.Join;
import org.springframework.context.expression.MapAccessor;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.PropertyAccessor;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.DataBindingPropertyAccessor;
import org.springframework.expression.spel.support.SimpleEvaluationContext;

@Join
public class ExpressionGenerator
implements Generator<String> {
    private static final ExpressionParser PARSER = new SpelExpressionParser();
    private static final EvaluationContext CONTEXT = ExpressionGenerator.initContext();

    @Override
    public String getName() {
        return "expression";
    }

    @Override
    public String doGenerate(List<String> params, String rule, MockRequest mockRequest) {
        String expression = params.get(0);
        CONTEXT.setVariable("req", (Object)mockRequest);
        Object val = PARSER.parseExpression(expression).getValue(CONTEXT);
        return JsonUtils.toJson((Object)val);
    }

    @Override
    public int getParamSize() {
        return 1;
    }

    @Override
    public boolean match(String rule) {
        return rule.matches("^" + this.getName() + "\\|.+");
    }

    private static EvaluationContext initContext() {
        SimpleEvaluationContext context = SimpleEvaluationContext.forPropertyAccessors((PropertyAccessor[])new PropertyAccessor[]{DataBindingPropertyAccessor.forReadOnlyAccess(), new MapAccessor()}).build();
        EvaluationContextUtil.init((EvaluationContext)context);
        return context;
    }
}

