/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.hessian.io.throwable;

import com.caucho.hessian.io.AbstractFieldAdaptorDeserializer;
import com.caucho.hessian.io.AbstractHessianInput;
import com.caucho.hessian.io.IOExceptionWrapper;
import com.caucho.hessian.io.throwable.StackTraceElementSerializer;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class StackTraceElementDeserializer
extends AbstractFieldAdaptorDeserializer {
    protected static final Logger log = Logger.getLogger(StackTraceElementSerializer.class.getName());
    private Constructor<StackTraceElement> _defaultConstructor = null;
    private Constructor<StackTraceElement> _constructorJdk9 = null;

    @Override
    public Class getType() {
        return StackTraceElement.class;
    }

    public StackTraceElementDeserializer() {
        super(StackTraceElement.class);
        try {
            this._defaultConstructor = StackTraceElement.class.getDeclaredConstructor(String.class, String.class, String.class, Integer.TYPE);
            if (this._fields.size() > 4) {
                this._constructorJdk9 = StackTraceElement.class.getDeclaredConstructor(String.class, String.class, String.class, String.class, String.class, String.class, Integer.TYPE);
            }
        }
        catch (Exception e) {
            log.log(Level.FINE, e.toString(), e);
        }
    }

    @Override
    public Object readObject(AbstractHessianInput in, String[] fieldNames) throws IOException {
        try {
            StackTraceElement obj;
            StackTraceElement tmp = this._constructorJdk9 != null ? this._constructorJdk9.newInstance("", "", "", "", "", "", 0) : this._defaultConstructor.newInstance("", "", "", 0);
            int ref = in.addRef(tmp);
            HashMap<String, Object> fieldValueMap = new HashMap<String, Object>();
            for (int i = 0; i < fieldNames.length; ++i) {
                String name = fieldNames[i];
                Field field = (Field)this._fields.get(name);
                if (field == null) {
                    fieldValueMap.put(name, in.readObject());
                    continue;
                }
                if (String.class.equals(field.getType())) {
                    fieldValueMap.put(name, in.readString());
                    continue;
                }
                if (!Integer.TYPE.equals(field.getType())) continue;
                fieldValueMap.put(name, in.readInt());
            }
            if (this._constructorJdk9 != null) {
                obj = this._constructorJdk9.newInstance(fieldValueMap.get("classLoaderName"), fieldValueMap.get("moduleName"), fieldValueMap.get("moduleVersion"), fieldValueMap.get("declaringClass"), fieldValueMap.get("methodName"), fieldValueMap.get("fileName"), fieldValueMap.get("lineNumber"));
            } else if (this._defaultConstructor != null) {
                obj = this._defaultConstructor.newInstance(fieldValueMap.get("declaringClass"), fieldValueMap.get("methodName"), fieldValueMap.get("fileName"), fieldValueMap.get("lineNumber"));
            } else {
                throw new UnsupportedOperationException("no constructor for " + this.getType().getName() + " found");
            }
            in.setRef(ref, obj);
            return obj;
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOExceptionWrapper(StackTraceElement.class.getName() + ":" + e, e);
        }
    }

    @Override
    protected Map<String, Field> getFieldMapForSerialize(Class cl) {
        HashMap<String, Field> fields = new HashMap<String, Field>();
        while (cl != null) {
            Field[] originFields = cl.getDeclaredFields();
            for (int i = 0; i < originFields.length; ++i) {
                Field field = originFields[i];
                if (Modifier.isTransient(field.getModifiers()) || Modifier.isStatic(field.getModifiers()) || fields.containsKey(field.getName()) || "format".equals(field.getName())) continue;
                fields.put(field.getName(), field);
            }
            cl = cl.getSuperclass();
        }
        return fields;
    }
}

