/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.nacos.discovery;

import com.alibaba.cloud.nacos.discovery.NacosServiceDiscovery;
import com.alibaba.cloud.nacos.discovery.ServiceCache;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.discovery.DiscoveryClient;

public class NacosDiscoveryClient
implements DiscoveryClient {
    private static final Logger log = LoggerFactory.getLogger(NacosDiscoveryClient.class);
    public static final String DESCRIPTION = "Spring Cloud Nacos Discovery Client";
    private NacosServiceDiscovery serviceDiscovery;
    @Value(value="${spring.cloud.nacos.discovery.failure-tolerance-enabled:false}")
    private boolean failureToleranceEnabled;

    public NacosDiscoveryClient(NacosServiceDiscovery nacosServiceDiscovery) {
        this.serviceDiscovery = nacosServiceDiscovery;
    }

    public String description() {
        return DESCRIPTION;
    }

    public List<ServiceInstance> getInstances(String serviceId) {
        try {
            return Optional.of(this.serviceDiscovery.getInstances(serviceId)).map(instances -> {
                ServiceCache.setInstances(serviceId, instances);
                return instances;
            }).get();
        }
        catch (Exception e) {
            if (this.failureToleranceEnabled) {
                return ServiceCache.getInstances(serviceId);
            }
            throw new RuntimeException("Can not get hosts from nacos server. serviceId: " + serviceId, e);
        }
    }

    public List<String> getServices() {
        try {
            return Optional.of(this.serviceDiscovery.getServices()).map(services -> {
                ServiceCache.set(services);
                return services;
            }).get();
        }
        catch (Exception e) {
            log.error("get service name from nacos server fail,", (Throwable)e);
            return this.failureToleranceEnabled ? ServiceCache.get() : Collections.emptyList();
        }
    }
}

