/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.xds;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import io.grpc.LoadBalancer;
import io.grpc.xds.ThreadSafeRandom;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

final class WeightedRandomPicker
extends LoadBalancer.SubchannelPicker {
    @VisibleForTesting
    final List<WeightedChildPicker> weightedChildPickers;
    private final ThreadSafeRandom random;
    private final int totalWeight;

    WeightedRandomPicker(List<WeightedChildPicker> weightedChildPickers) {
        this(weightedChildPickers, ThreadSafeRandom.ThreadSafeRandomImpl.instance);
    }

    @VisibleForTesting
    WeightedRandomPicker(List<WeightedChildPicker> weightedChildPickers, ThreadSafeRandom random) {
        Preconditions.checkNotNull(weightedChildPickers, (Object)"weightedChildPickers in null");
        Preconditions.checkArgument((!weightedChildPickers.isEmpty() ? 1 : 0) != 0, (Object)"weightedChildPickers is empty");
        this.weightedChildPickers = Collections.unmodifiableList(weightedChildPickers);
        int totalWeight = 0;
        for (WeightedChildPicker weightedChildPicker : weightedChildPickers) {
            int weight = weightedChildPicker.getWeight();
            totalWeight += weight;
        }
        this.totalWeight = totalWeight;
        this.random = random;
    }

    public final LoadBalancer.PickResult pickSubchannel(LoadBalancer.PickSubchannelArgs args) {
        LoadBalancer.SubchannelPicker childPicker = null;
        if (this.totalWeight == 0) {
            childPicker = this.weightedChildPickers.get(this.random.nextInt(this.weightedChildPickers.size())).getPicker();
        } else {
            int rand = this.random.nextInt(this.totalWeight);
            int accumulatedWeight = 0;
            for (int idx = 0; idx < this.weightedChildPickers.size(); ++idx) {
                if (rand >= (accumulatedWeight += this.weightedChildPickers.get(idx).getWeight())) continue;
                childPicker = this.weightedChildPickers.get(idx).getPicker();
                break;
            }
            Preconditions.checkNotNull((Object)childPicker, (Object)"childPicker not found");
        }
        return childPicker.pickSubchannel(args);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("weightedChildPickers", this.weightedChildPickers).add("totalWeight", this.totalWeight).toString();
    }

    static final class WeightedChildPicker {
        private final int weight;
        private final LoadBalancer.SubchannelPicker childPicker;

        WeightedChildPicker(int weight, LoadBalancer.SubchannelPicker childPicker) {
            Preconditions.checkArgument((weight >= 0 ? 1 : 0) != 0, (Object)"weight is negative");
            Preconditions.checkNotNull((Object)childPicker, (Object)"childPicker is null");
            this.weight = weight;
            this.childPicker = childPicker;
        }

        int getWeight() {
            return this.weight;
        }

        LoadBalancer.SubchannelPicker getPicker() {
            return this.childPicker;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            WeightedChildPicker that = (WeightedChildPicker)o;
            return this.weight == that.weight && Objects.equals(this.childPicker, that.childPicker);
        }

        public int hashCode() {
            return Objects.hash(this.weight, this.childPicker);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("weight", this.weight).add("childPicker", (Object)this.childPicker).toString();
        }
    }
}

