/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.elasticsearch.ml.DataframeEvaluationMetrics;
import co.elastic.clients.json.JsonData;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class DataframeEvaluationClassificationMetrics
extends DataframeEvaluationMetrics {
    private final Map<String, JsonData> accuracy;
    private final Map<String, JsonData> multiclassConfusionMatrix;
    public static final JsonpDeserializer<DataframeEvaluationClassificationMetrics> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, DataframeEvaluationClassificationMetrics::setupDataframeEvaluationClassificationMetricsDeserializer);

    private DataframeEvaluationClassificationMetrics(Builder builder) {
        super(builder);
        this.accuracy = ApiTypeHelper.unmodifiable(builder.accuracy);
        this.multiclassConfusionMatrix = ApiTypeHelper.unmodifiable(builder.multiclassConfusionMatrix);
    }

    public static DataframeEvaluationClassificationMetrics of(Function<Builder, ObjectBuilder<DataframeEvaluationClassificationMetrics>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final Map<String, JsonData> accuracy() {
        return this.accuracy;
    }

    public final Map<String, JsonData> multiclassConfusionMatrix() {
        return this.multiclassConfusionMatrix;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (ApiTypeHelper.isDefined(this.accuracy)) {
            generator.writeKey("accuracy");
            generator.writeStartObject();
            for (Map.Entry<String, JsonData> item0 : this.accuracy.entrySet()) {
                generator.writeKey(item0.getKey());
                item0.getValue().serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.multiclassConfusionMatrix)) {
            generator.writeKey("multiclass_confusion_matrix");
            generator.writeStartObject();
            for (Map.Entry<String, JsonData> item0 : this.multiclassConfusionMatrix.entrySet()) {
                generator.writeKey(item0.getKey());
                item0.getValue().serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    protected static void setupDataframeEvaluationClassificationMetricsDeserializer(ObjectDeserializer<Builder> op) {
        DataframeEvaluationMetrics.setupDataframeEvaluationMetricsDeserializer(op);
        op.add(Builder::accuracy, JsonpDeserializer.stringMapDeserializer(JsonData._DESERIALIZER), "accuracy");
        op.add(Builder::multiclassConfusionMatrix, JsonpDeserializer.stringMapDeserializer(JsonData._DESERIALIZER), "multiclass_confusion_matrix");
    }

    public static class Builder
    extends DataframeEvaluationMetrics.AbstractBuilder<Builder>
    implements ObjectBuilder<DataframeEvaluationClassificationMetrics> {
        @Nullable
        private Map<String, JsonData> accuracy;
        @Nullable
        private Map<String, JsonData> multiclassConfusionMatrix;

        public final Builder accuracy(Map<String, JsonData> map) {
            this.accuracy = Builder._mapPutAll(this.accuracy, map);
            return this;
        }

        public final Builder accuracy(String key, JsonData value) {
            this.accuracy = Builder._mapPut(this.accuracy, key, value);
            return this;
        }

        public final Builder multiclassConfusionMatrix(Map<String, JsonData> map) {
            this.multiclassConfusionMatrix = Builder._mapPutAll(this.multiclassConfusionMatrix, map);
            return this;
        }

        public final Builder multiclassConfusionMatrix(String key, JsonData value) {
            this.multiclassConfusionMatrix = Builder._mapPut(this.multiclassConfusionMatrix, key, value);
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public DataframeEvaluationClassificationMetrics build() {
            this._checkSingleUse();
            return new DataframeEvaluationClassificationMetrics(this);
        }
    }
}

