/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.indices.stats;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.Map;
import java.util.function.Function;

@JsonpDeserializable
public class ShardCommit
implements JsonpSerializable {
    private final int generation;
    private final String id;
    private final long numDocs;
    private final Map<String, String> userData;
    public static final JsonpDeserializer<ShardCommit> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ShardCommit::setupShardCommitDeserializer);

    private ShardCommit(Builder builder) {
        this.generation = ApiTypeHelper.requireNonNull(builder.generation, this, "generation");
        this.id = ApiTypeHelper.requireNonNull(builder.id, this, "id");
        this.numDocs = ApiTypeHelper.requireNonNull(builder.numDocs, this, "numDocs");
        this.userData = ApiTypeHelper.unmodifiableRequired(builder.userData, (Object)this, "userData");
    }

    public static ShardCommit of(Function<Builder, ObjectBuilder<ShardCommit>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final int generation() {
        return this.generation;
    }

    public final String id() {
        return this.id;
    }

    public final long numDocs() {
        return this.numDocs;
    }

    public final Map<String, String> userData() {
        return this.userData;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("generation");
        generator.write(this.generation);
        generator.writeKey("id");
        generator.write(this.id);
        generator.writeKey("num_docs");
        generator.write(this.numDocs);
        if (ApiTypeHelper.isDefined(this.userData)) {
            generator.writeKey("user_data");
            generator.writeStartObject();
            for (Map.Entry<String, String> item0 : this.userData.entrySet()) {
                generator.writeKey(item0.getKey());
                generator.write(item0.getValue());
            }
            generator.writeEnd();
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupShardCommitDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::generation, JsonpDeserializer.integerDeserializer(), "generation");
        op.add(Builder::id, JsonpDeserializer.stringDeserializer(), "id");
        op.add(Builder::numDocs, JsonpDeserializer.longDeserializer(), "num_docs");
        op.add(Builder::userData, JsonpDeserializer.stringMapDeserializer(JsonpDeserializer.stringDeserializer()), "user_data");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<ShardCommit> {
        private Integer generation;
        private String id;
        private Long numDocs;
        private Map<String, String> userData;

        public final Builder generation(int value) {
            this.generation = value;
            return this;
        }

        public final Builder id(String value) {
            this.id = value;
            return this;
        }

        public final Builder numDocs(long value) {
            this.numDocs = value;
            return this;
        }

        public final Builder userData(Map<String, String> map) {
            this.userData = Builder._mapPutAll(this.userData, map);
            return this;
        }

        public final Builder userData(String key, String value) {
            this.userData = Builder._mapPut(this.userData, key, value);
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public ShardCommit build() {
            this._checkSingleUse();
            return new ShardCommit(this);
        }
    }
}

