/*
 * Decompiled with CFR 0.152.
 */
package com.weibo.api.motan.transport.netty4;

import com.weibo.api.motan.codec.Codec;
import com.weibo.api.motan.exception.MotanFrameworkException;
import com.weibo.api.motan.exception.MotanServiceException;
import com.weibo.api.motan.protocol.rpc.RpcProtocolVersion;
import com.weibo.api.motan.rpc.DefaultResponse;
import com.weibo.api.motan.transport.Channel;
import com.weibo.api.motan.transport.netty4.CodecUtil;
import com.weibo.api.motan.transport.netty4.NettyMessage;
import com.weibo.api.motan.util.LoggerUtil;
import com.weibo.api.motan.util.MotanFrameworkUtil;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import java.util.List;

public class NettyDecoder
extends ByteToMessageDecoder {
    private Codec codec;
    private Channel channel;
    private int maxContentLength = 0;

    public NettyDecoder(Codec codec, Channel channel, int maxContentLength) {
        this.codec = codec;
        this.channel = channel;
        this.maxContentLength = maxContentLength;
    }

    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
        if (in.readableBytes() <= 16) {
            return;
        }
        in.markReaderIndex();
        short type = in.readShort();
        if (type != -3599) {
            in.skipBytes(in.readableBytes());
            throw new MotanFrameworkException("NettyDecoder transport header not support, type: " + type);
        }
        in.skipBytes(1);
        int rpcVersion = (in.readByte() & 0xFF) >>> 3;
        switch (rpcVersion) {
            case 0: {
                this.decodeV1(ctx, in, out);
                break;
            }
            case 1: {
                this.decodeV2(ctx, in, out);
                break;
            }
            default: {
                this.decodeV2(ctx, in, out);
            }
        }
    }

    private void decodeV2(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
        long startTime = System.currentTimeMillis();
        in.resetReaderIndex();
        if (in.readableBytes() < 21) {
            return;
        }
        in.skipBytes(2);
        boolean isRequest = this.isV2Request(in.readByte());
        in.skipBytes(2);
        long requestId = in.readLong();
        int size = 13;
        int metaSize = in.readInt();
        size += 4;
        if (metaSize > 0) {
            this.checkMaxContext(metaSize, ctx, in, isRequest, requestId, RpcProtocolVersion.VERSION_2);
            size += metaSize;
            if (in.readableBytes() < metaSize) {
                in.resetReaderIndex();
                return;
            }
            in.skipBytes(metaSize);
        }
        if (in.readableBytes() < 4) {
            in.resetReaderIndex();
            return;
        }
        int bodySize = in.readInt();
        size += 4;
        if (bodySize > 0) {
            this.checkMaxContext(bodySize, ctx, in, isRequest, requestId, RpcProtocolVersion.VERSION_2);
            size += bodySize;
            if (in.readableBytes() < bodySize) {
                in.resetReaderIndex();
                return;
            }
        }
        byte[] data = new byte[size];
        in.resetReaderIndex();
        in.readBytes(data);
        this.decode(data, out, isRequest, requestId, RpcProtocolVersion.VERSION_2).setStartTime(startTime);
    }

    private boolean isV2Request(byte b) {
        return (b & 1) == 0;
    }

    private void decodeV1(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
        long startTime = System.currentTimeMillis();
        in.resetReaderIndex();
        in.skipBytes(2);
        byte messageType = (byte)in.readShort();
        long requestId = in.readLong();
        int dataLength = in.readInt();
        this.checkMaxContext(dataLength, ctx, in, messageType == 0, requestId, RpcProtocolVersion.VERSION_1);
        if (in.readableBytes() < dataLength) {
            in.resetReaderIndex();
            return;
        }
        byte[] data = new byte[dataLength];
        in.readBytes(data);
        this.decode(data, out, messageType == 0, requestId, RpcProtocolVersion.VERSION_1).setStartTime(startTime);
    }

    private void checkMaxContext(int dataLength, ChannelHandlerContext ctx, ByteBuf byteBuf, boolean isRequest, long requestId, RpcProtocolVersion version) throws Exception {
        if (this.maxContentLength > 0 && dataLength > this.maxContentLength) {
            LoggerUtil.warn((String)"NettyDecoder transport data content length over of limit, size: {}  > {}. remote={} local={}", (Object[])new Object[]{dataLength, this.maxContentLength, ctx.channel().remoteAddress(), ctx.channel().localAddress()});
            byteBuf.skipBytes(byteBuf.readableBytes());
            MotanServiceException e = new MotanServiceException("NettyDecoder transport data content length over of limit, size: " + dataLength + " > " + this.maxContentLength);
            if (isRequest) {
                DefaultResponse response = MotanFrameworkUtil.buildErrorResponse((long)requestId, (byte)version.getVersion(), (Exception)e);
                byte[] msg = CodecUtil.encodeObjectToBytes(this.channel, this.codec, response);
                ctx.channel().writeAndFlush((Object)msg);
                throw e;
            }
            throw e;
        }
    }

    private NettyMessage decode(byte[] data, List<Object> out, boolean isRequest, long requestId, RpcProtocolVersion version) {
        NettyMessage message = new NettyMessage(isRequest, requestId, data, version);
        out.add(message);
        return message;
    }
}

