/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.codec;

import java.util.List;
import java.util.Map;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.StringFormat;
import org.reactivestreams.Publisher;
import org.springframework.core.ResolvableType;
import org.springframework.core.codec.Decoder;
import org.springframework.core.codec.DecodingException;
import org.springframework.core.codec.StringDecoder;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.http.codec.KotlinSerializationSupport;
import org.springframework.lang.Nullable;
import org.springframework.util.MimeType;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public abstract class KotlinSerializationStringDecoder<T extends StringFormat>
extends KotlinSerializationSupport<T>
implements Decoder<Object> {
    private final StringDecoder stringDecoder = StringDecoder.allMimeTypes((List)StringDecoder.DEFAULT_DELIMITERS, (boolean)false);

    public KotlinSerializationStringDecoder(T format, MimeType ... supportedMimeTypes) {
        super(format, supportedMimeTypes);
    }

    public void setMaxInMemorySize(int byteCount) {
        this.stringDecoder.setMaxInMemorySize(byteCount);
    }

    public int getMaxInMemorySize() {
        return this.stringDecoder.getMaxInMemorySize();
    }

    public boolean canDecode(ResolvableType elementType, @Nullable MimeType mimeType) {
        return this.canSerialize(elementType, mimeType);
    }

    public List<MimeType> getDecodableMimeTypes() {
        return this.supportedMimeTypes();
    }

    public List<MimeType> getDecodableMimeTypes(ResolvableType targetType) {
        return this.supportedMimeTypes();
    }

    public Flux<Object> decode(Publisher<DataBuffer> inputStream, ResolvableType elementType, @Nullable MimeType mimeType, @Nullable Map<String, Object> hints) {
        return Flux.defer(() -> {
            KSerializer<Object> serializer = this.serializer(elementType);
            if (serializer == null) {
                return Mono.error((Throwable)new DecodingException("Could not find KSerializer for " + elementType));
            }
            return this.stringDecoder.decode(inputStream, elementType, mimeType, hints).map(string -> ((StringFormat)this.format()).decodeFromString((DeserializationStrategy)serializer, string));
        });
    }

    public Mono<Object> decodeToMono(Publisher<DataBuffer> inputStream, ResolvableType elementType, @Nullable MimeType mimeType, @Nullable Map<String, Object> hints) {
        return Mono.defer(() -> {
            KSerializer<Object> serializer = this.serializer(elementType);
            if (serializer == null) {
                return Mono.error((Throwable)new DecodingException("Could not find KSerializer for " + elementType));
            }
            return this.stringDecoder.decodeToMono(inputStream, elementType, mimeType, hints).map(string -> ((StringFormat)this.format()).decodeFromString((DeserializationStrategy)serializer, string));
        });
    }
}

