/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.support.converter;

import java.util.Map;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.integration.mapping.InboundMessageMapper;
import org.springframework.integration.mapping.OutboundMessageMapper;
import org.springframework.integration.support.DefaultMessageBuilderFactory;
import org.springframework.integration.support.MessageBuilderFactory;
import org.springframework.integration.support.utils.IntegrationUtils;
import org.springframework.lang.Nullable;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHeaders;
import org.springframework.messaging.converter.MessageConversionException;
import org.springframework.messaging.converter.MessageConverter;

public class SimpleMessageConverter
implements MessageConverter,
BeanFactoryAware {
    private InboundMessageMapper inboundMessageMapper = new DefaultInboundMessageMapper();
    private OutboundMessageMapper outboundMessageMapper = new DefaultOutboundMessageMapper();
    private MessageBuilderFactory messageBuilderFactory = new DefaultMessageBuilderFactory();
    private boolean messageBuilderFactorySet;
    private BeanFactory beanFactory;

    public SimpleMessageConverter() {
    }

    public SimpleMessageConverter(InboundMessageMapper<?> inboundMessageMapper) {
        this.setInboundMessageMapper(inboundMessageMapper);
        if (inboundMessageMapper instanceof OutboundMessageMapper) {
            OutboundMessageMapper messageMapper = (OutboundMessageMapper)((Object)inboundMessageMapper);
            this.setOutboundMessageMapper(messageMapper);
        }
    }

    public SimpleMessageConverter(OutboundMessageMapper<?> outboundMessageMapper) {
        if (outboundMessageMapper instanceof InboundMessageMapper) {
            InboundMessageMapper messageMapper = (InboundMessageMapper)((Object)outboundMessageMapper);
            this.setInboundMessageMapper(messageMapper);
        }
        this.setOutboundMessageMapper(outboundMessageMapper);
    }

    public SimpleMessageConverter(InboundMessageMapper<?> inboundMessageMapper, OutboundMessageMapper<?> outboundMessageMapper) {
        this.setInboundMessageMapper(inboundMessageMapper);
        this.setOutboundMessageMapper(outboundMessageMapper);
    }

    public final void setInboundMessageMapper(@Nullable InboundMessageMapper<?> inboundMessageMapper) {
        if (inboundMessageMapper != null) {
            this.inboundMessageMapper = inboundMessageMapper;
        }
    }

    public final void setOutboundMessageMapper(@Nullable OutboundMessageMapper<?> outboundMessageMapper) {
        if (outboundMessageMapper != null) {
            this.outboundMessageMapper = outboundMessageMapper;
        }
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    protected MessageBuilderFactory getMessageBuilderFactory() {
        if (!this.messageBuilderFactorySet) {
            if (this.beanFactory != null) {
                this.messageBuilderFactory = IntegrationUtils.getMessageBuilderFactory(this.beanFactory);
            }
            this.messageBuilderFactorySet = true;
        }
        return this.messageBuilderFactory;
    }

    @Nullable
    public Message<?> toMessage(Object object, @Nullable MessageHeaders headers) {
        try {
            return this.inboundMessageMapper.toMessage(object, (Map<String, Object>)headers);
        }
        catch (Exception ex) {
            throw new MessageConversionException("failed to convert object to Message", (Throwable)ex);
        }
    }

    @Nullable
    public Object fromMessage(Message<?> message, Class<?> targetClass) {
        try {
            return this.outboundMessageMapper.fromMessage(message);
        }
        catch (Exception ex) {
            throw new MessageConversionException(message, "failed to convert Message to object", (Throwable)ex);
        }
    }

    private class DefaultInboundMessageMapper
    implements InboundMessageMapper<Object> {
        DefaultInboundMessageMapper() {
        }

        @Override
        public Message<?> toMessage(@Nullable Object object, @Nullable Map<String, Object> headers) {
            if (object == null) {
                return null;
            }
            if (object instanceof Message) {
                return (Message)object;
            }
            return SimpleMessageConverter.this.getMessageBuilderFactory().withPayload(object).copyHeadersIfAbsent(headers).build();
        }
    }

    private static class DefaultOutboundMessageMapper
    implements OutboundMessageMapper<Object> {
        DefaultOutboundMessageMapper() {
        }

        @Override
        public Object fromMessage(@Nullable Message<?> message) {
            return message != null ? message.getPayload() : null;
        }
    }
}

