/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.splitter;

import java.util.Collection;
import org.springframework.context.Lifecycle;
import org.springframework.integration.handler.MessageProcessor;
import org.springframework.integration.splitter.AbstractMessageSplitter;
import org.springframework.integration.support.management.ManageableLifecycle;
import org.springframework.messaging.Message;
import org.springframework.util.Assert;

abstract class AbstractMessageProcessingSplitter
extends AbstractMessageSplitter
implements ManageableLifecycle {
    private final MessageProcessor<Collection<?>> processor;

    protected AbstractMessageProcessingSplitter(MessageProcessor<Collection<?>> expressionEvaluatingMessageProcessor) {
        Assert.notNull(expressionEvaluatingMessageProcessor, (String)"messageProcessor must not be null");
        this.processor = expressionEvaluatingMessageProcessor;
    }

    @Override
    protected void doInit() {
        this.setupMessageProcessor(this.processor);
    }

    @Override
    protected final Object splitMessage(Message<?> message) {
        return this.processor.processMessage(message);
    }

    @Override
    public void start() {
        MessageProcessor<Collection<?>> messageProcessor = this.processor;
        if (messageProcessor instanceof Lifecycle) {
            Lifecycle lifecycle = (Lifecycle)messageProcessor;
            lifecycle.start();
        }
    }

    @Override
    public void stop() {
        MessageProcessor<Collection<?>> messageProcessor = this.processor;
        if (messageProcessor instanceof Lifecycle) {
            Lifecycle lifecycle = (Lifecycle)messageProcessor;
            lifecycle.stop();
        }
    }

    @Override
    public boolean isRunning() {
        return !(this.processor instanceof Lifecycle) || ((Lifecycle)this.processor).isRunning();
    }
}

