/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.listener.websocket;

import jakarta.servlet.ServletRequestEvent;
import jakarta.servlet.ServletRequestListener;
import jakarta.servlet.annotation.WebListener;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpSession;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Configuration;

@WebListener
@Configuration
public class WebsocketListener
implements ServletRequestListener {
    public static final String CLIENT_IP_NAME = "ClientIP";
    private static final Logger LOG = LoggerFactory.getLogger(WebsocketListener.class);

    public void requestDestroyed(ServletRequestEvent sre) {
        try {
            HttpServletRequest request = (HttpServletRequest)sre.getServletRequest();
            if (Objects.nonNull(request) && Objects.nonNull(request.getSession())) {
                HttpSession session = request.getSession();
                request.removeAttribute(CLIENT_IP_NAME);
                session.removeAttribute(CLIENT_IP_NAME);
                request.removeAttribute("namespaceId");
                session.removeAttribute("namespaceId");
            }
        }
        catch (Exception e) {
            LOG.error("request destroyed error", (Throwable)e);
        }
    }

    public void requestInitialized(ServletRequestEvent sre) {
        try {
            HttpServletRequest request = (HttpServletRequest)sre.getServletRequest();
            if (Objects.nonNull(request) && Objects.nonNull(request.getSession())) {
                HttpSession session = request.getSession();
                request.setAttribute(CLIENT_IP_NAME, (Object)sre.getServletRequest().getRemoteAddr());
                session.setAttribute(CLIENT_IP_NAME, (Object)sre.getServletRequest().getRemoteAddr());
                String namespace = request.getHeader("namespaceId");
                if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{namespace})) {
                    request.setAttribute("namespaceId", (Object)namespace);
                    session.setAttribute("namespaceId", (Object)namespace);
                }
            }
        }
        catch (Exception e) {
            LOG.error("request initialized error", (Throwable)e);
        }
    }
}

