/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.controller;

import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.admin.aspect.annotation.RestApi;
import org.apache.shenyu.admin.controller.PagedController;
import org.apache.shenyu.admin.mapper.NamespaceMapper;
import org.apache.shenyu.admin.mapper.NamespacePluginRelMapper;
import org.apache.shenyu.admin.mapper.PluginMapper;
import org.apache.shenyu.admin.model.dto.BatchCommonDTO;
import org.apache.shenyu.admin.model.dto.BatchNamespaceCommonDTO;
import org.apache.shenyu.admin.model.dto.NamespacePluginDTO;
import org.apache.shenyu.admin.model.dto.NamespaceSyncDTO;
import org.apache.shenyu.admin.model.page.CommonPager;
import org.apache.shenyu.admin.model.page.PageParameter;
import org.apache.shenyu.admin.model.query.NamespacePluginQuery;
import org.apache.shenyu.admin.model.query.NamespacePluginQueryCondition;
import org.apache.shenyu.admin.model.result.ShenyuAdminResult;
import org.apache.shenyu.admin.model.vo.NamespacePluginVO;
import org.apache.shenyu.admin.service.NamespacePluginService;
import org.apache.shenyu.admin.service.PageService;
import org.apache.shenyu.admin.service.SyncDataService;
import org.apache.shenyu.admin.validation.annotation.Existed;
import org.apache.shenyu.common.dto.PluginData;
import org.apache.shenyu.common.enums.DataEventTypeEnum;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

@RestApi(value={"/namespace-plugin"})
public class NamespacePluginController
implements PagedController<NamespacePluginQueryCondition, NamespacePluginVO> {
    private final NamespacePluginService namespacePluginService;
    private final SyncDataService syncDataService;

    public NamespacePluginController(NamespacePluginService namespacePluginService, SyncDataService syncDataService) {
        this.namespacePluginService = namespacePluginService;
        this.syncDataService = syncDataService;
    }

    @GetMapping
    public ShenyuAdminResult queryPlugins(@RequestParam(name="name", required=false) String name, @RequestParam(name="enabled", required=false) Integer enabled, @Existed(message="namespace is not existed", provider=NamespaceMapper.class) @RequestParam(name="namespaceId") @Existed(message="namespace is not existed", provider=NamespaceMapper.class) String namespaceId, @NotNull @RequestParam(name="currentPage") Integer currentPage, @NotNull @RequestParam(name="pageSize") Integer pageSize) {
        CommonPager<NamespacePluginVO> commonPager = this.namespacePluginService.listByPage(new NamespacePluginQuery(name, enabled, new PageParameter(currentPage, pageSize), namespaceId));
        return ShenyuAdminResult.success("query success", commonPager);
    }

    @GetMapping(value={"/all/{namespaceId}"})
    public ShenyuAdminResult queryAllNamespacePlugins(@Existed(message="namespace is not existed", provider=NamespaceMapper.class) @PathVariable(value="namespaceId") @Existed(message="namespace is not existed", provider=NamespaceMapper.class) String namespaceId) {
        List<PluginData> pluginDataList = this.namespacePluginService.listAll(namespaceId);
        return ShenyuAdminResult.success("query success", pluginDataList);
    }

    @GetMapping(value={"/{id}"})
    @RequiresPermissions(value={"system:plugin:edit"})
    public ShenyuAdminResult detailNamespacePlugin(@Existed(message="namespace plugin relation is not exist", provider=NamespacePluginRelMapper.class) @PathVariable(value="id") @Existed(message="namespace plugin relation is not exist", provider=NamespacePluginRelMapper.class) String id) {
        NamespacePluginVO namespacePluginVO = this.namespacePluginService.findById(id);
        return ShenyuAdminResult.success("detail success", namespacePluginVO);
    }

    @PutMapping(value={"/{id}"})
    @RequiresPermissions(value={"system:plugin:edit"})
    public ShenyuAdminResult updatePlugin(@Existed(message="namespace plugin relation is not exist", provider=NamespacePluginRelMapper.class) @PathVariable(value="id") @Existed(message="namespace plugin relation is not exist", provider=NamespacePluginRelMapper.class) String id, @Valid @RequestBody NamespacePluginDTO namespacePluginDTO) {
        namespacePluginDTO.setId(id);
        return ShenyuAdminResult.success(this.namespacePluginService.update(namespacePluginDTO));
    }

    @PostMapping(value={"/{namespaceId}/{pluginId}"})
    @RequiresPermissions(value={"system:plugin:edit"})
    public ShenyuAdminResult generateNamespacePlugin(@Existed(message="namespace is not exist", provider=NamespaceMapper.class) @PathVariable(value="namespaceId") @Existed(message="namespace is not exist", provider=NamespaceMapper.class) String namespaceId, @Existed(message="plugin is not exist", provider=PluginMapper.class) @PathVariable(value="pluginId") @Existed(message="plugin is not exist", provider=PluginMapper.class) String pluginId) {
        return ShenyuAdminResult.success(this.namespacePluginService.create(namespaceId, pluginId));
    }

    @DeleteMapping(value={"/batch"})
    @RequiresPermissions(value={"system:plugin:delete"})
    public ShenyuAdminResult deleteNamespacePlugin(@Valid @RequestBody BatchNamespaceCommonDTO batchNamespaceCommonDTO) {
        String result = this.namespacePluginService.delete(batchNamespaceCommonDTO.getIds());
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{result})) {
            return ShenyuAdminResult.error(result);
        }
        return ShenyuAdminResult.success("delete success");
    }

    @PostMapping(value={"/enabled"})
    @RequiresPermissions(value={"system:plugin:disable"})
    public ShenyuAdminResult enabled(@Valid @RequestBody BatchCommonDTO batchCommonDTO) {
        String result = this.namespacePluginService.enabled(batchCommonDTO.getIds(), batchCommonDTO.getEnabled());
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{result})) {
            return ShenyuAdminResult.error(result);
        }
        return ShenyuAdminResult.success("enable success");
    }

    @PostMapping(value={"/enabledByNamespace"})
    @RequiresPermissions(value={"system:plugin:disable"})
    public ShenyuAdminResult enabledByNamespace(@Valid @RequestBody BatchCommonDTO batchCommonDTO) {
        String result = this.namespacePluginService.enabled(batchCommonDTO.getNamespaceId(), batchCommonDTO.getIds(), batchCommonDTO.getEnabled());
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{result})) {
            return ShenyuAdminResult.error(result);
        }
        return ShenyuAdminResult.success("enable success");
    }

    @PostMapping(value={"/syncPluginAll"})
    @RequiresPermissions(value={"system:plugin:modify"})
    public ShenyuAdminResult syncPluginAll(@Valid @RequestBody NamespaceSyncDTO namespaceSyncDTO) {
        boolean success = this.syncDataService.syncAllByNamespaceId(DataEventTypeEnum.REFRESH, namespaceSyncDTO.getNamespaceId());
        if (success) {
            return ShenyuAdminResult.success("sync success");
        }
        return ShenyuAdminResult.error("sync fail");
    }

    @PutMapping(value={"/syncPluginData"})
    public ShenyuAdminResult syncPluginData(@RequestParam(value="id") String id) {
        return ShenyuAdminResult.success(this.syncDataService.syncPluginData(id) ? "sync success" : "sync fail");
    }

    @GetMapping(value={"/snapshot/active"})
    public ShenyuAdminResult activePluginSnapshot(String namespaceId) {
        return ShenyuAdminResult.success(this.namespacePluginService.activePluginSnapshot(namespaceId));
    }

    @GetMapping(value={"/listByNamespace"})
    public ShenyuAdminResult queryPluginsByNamespace(String namespace) {
        List<PluginData> pluginDataList = this.namespacePluginService.listByNamespace(namespace);
        return ShenyuAdminResult.success("query success", pluginDataList);
    }

    @Override
    public PageService<NamespacePluginQueryCondition, NamespacePluginVO> pageService() {
        return this.namespacePluginService;
    }
}

