/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.config;

import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.shenyu.admin.disruptor.RegisterClientServerDisruptorPublisher;
import org.apache.shenyu.admin.lock.RegisterExecutionRepository;
import org.apache.shenyu.admin.lock.impl.PlatformTransactionRegisterExecutionRepository;
import org.apache.shenyu.admin.mapper.PluginMapper;
import org.apache.shenyu.admin.service.DiscoveryService;
import org.apache.shenyu.admin.service.register.ShenyuClientRegisterService;
import org.apache.shenyu.register.common.config.ShenyuRegisterCenterConfig;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.transaction.PlatformTransactionManager;

@Configuration
public class RegisterCenterConfiguration {
    @Bean
    @ConfigurationProperties(prefix="shenyu.register")
    public ShenyuRegisterCenterConfig shenyuRegisterCenterConfig() {
        return new ShenyuRegisterCenterConfig();
    }

    @Bean
    public RegisterClientServerDisruptorPublisher registerClientServerDisruptorPublisher(List<ShenyuClientRegisterService> shenyuClientRegisterService, DiscoveryService discoveryService) {
        RegisterClientServerDisruptorPublisher publisher = RegisterClientServerDisruptorPublisher.getInstance();
        Map<String, ShenyuClientRegisterService> registerServiceMap = shenyuClientRegisterService.stream().collect(Collectors.toMap(ShenyuClientRegisterService::rpcType, Function.identity()));
        publisher.start(registerServiceMap, discoveryService);
        return publisher;
    }

    @Bean
    @ConditionalOnMissingBean(name={"registerExecutionRepository"})
    public RegisterExecutionRepository registerExecutionRepository(PlatformTransactionManager platformTransactionManager, PluginMapper pluginMapper) {
        return new PlatformTransactionRegisterExecutionRepository(platformTransactionManager, pluginMapper);
    }
}

