/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.swagger.generator.core.processor.annotation;

import io.swagger.annotations.Api;
import java.lang.reflect.Type;
import org.apache.commons.lang3.StringUtils;
import org.apache.servicecomb.swagger.SwaggerUtils;
import org.apache.servicecomb.swagger.generator.ClassAnnotationProcessor;
import org.apache.servicecomb.swagger.generator.SwaggerGenerator;

public class ApiProcessor
implements ClassAnnotationProcessor<Api> {
    @Override
    public Type getProcessType() {
        return Api.class;
    }

    @Override
    public void process(SwaggerGenerator swaggerGenerator, Api api) {
        this.setTags(swaggerGenerator, api);
        SwaggerUtils.setCommaConsumes(swaggerGenerator.getSwagger(), api.consumes());
        SwaggerUtils.setCommaProduces(swaggerGenerator.getSwagger(), api.produces());
    }

    private void setTags(SwaggerGenerator swaggerGenerator, Api api) {
        String[] tags;
        for (String tagName : tags = api.tags()) {
            if (StringUtils.isEmpty((CharSequence)tagName)) continue;
            swaggerGenerator.addDefaultTag(tagName);
        }
    }
}

