/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.client.java.message;

import com.google.common.base.MoreObjects;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.rocketmq.client.apis.message.Message;
import org.apache.rocketmq.client.java.message.MessageBuilderImpl;

public class MessageImpl
implements Message {
    protected final Collection<String> keys;
    protected final Map<String, String> properties;
    final byte[] body;
    private final String topic;
    @Nullable
    private final String tag;
    @Nullable
    private final String messageGroup;
    @Nullable
    private final String liteTopic;
    @Nullable
    private final Long deliveryTimestamp;
    @Nullable
    private final Integer priority;

    MessageImpl(MessageBuilderImpl builder) {
        this.topic = builder.topic;
        this.body = builder.body;
        this.tag = builder.tag;
        this.messageGroup = builder.messageGroup;
        this.liteTopic = builder.liteTopic;
        this.deliveryTimestamp = builder.deliveryTimestamp;
        this.priority = builder.priority;
        this.keys = builder.keys;
        this.properties = builder.properties;
    }

    MessageImpl(Message message) {
        this.topic = message.getTopic();
        if (message instanceof MessageImpl) {
            MessageImpl impl = (MessageImpl)message;
            this.body = impl.body;
        } else {
            ByteBuffer body = message.getBody();
            byte[] bytes = new byte[body.remaining()];
            body.get(bytes);
            this.body = bytes;
        }
        this.tag = message.getTag().orElse(null);
        this.messageGroup = message.getMessageGroup().orElse(null);
        this.deliveryTimestamp = message.getDeliveryTimestamp().orElse(null);
        this.liteTopic = message.getLiteTopic().orElse(null);
        this.priority = message.getPriority().orElse(null);
        this.keys = message.getKeys();
        this.properties = message.getProperties();
    }

    public String getTopic() {
        return this.topic;
    }

    public ByteBuffer getBody() {
        return ByteBuffer.wrap(this.body).asReadOnlyBuffer();
    }

    public Map<String, String> getProperties() {
        return new HashMap<String, String>(this.properties);
    }

    public Optional<String> getTag() {
        return Optional.ofNullable(this.tag);
    }

    public Collection<String> getKeys() {
        return new ArrayList<String>(this.keys);
    }

    public Optional<Long> getDeliveryTimestamp() {
        return Optional.ofNullable(this.deliveryTimestamp);
    }

    public Optional<Integer> getPriority() {
        return Optional.ofNullable(this.priority);
    }

    public Optional<String> getMessageGroup() {
        return Optional.ofNullable(this.messageGroup);
    }

    public Optional<String> getLiteTopic() {
        return Optional.ofNullable(this.liteTopic);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("topic", (Object)this.topic).add("tag", (Object)this.tag).add("messageGroup", (Object)this.messageGroup).add("liteTopic", (Object)this.liteTopic).add("deliveryTimestamp", (Object)this.deliveryTimestamp).add("priority", (Object)this.priority).add("keys", this.keys).add("properties", this.properties).toString();
    }
}

