/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.client.java.impl.consumer;

import apache.rocketmq.v2.LiteSubscriptionAction;
import apache.rocketmq.v2.NotifyUnsubscribeLiteCommand;
import apache.rocketmq.v2.OffsetOption;
import apache.rocketmq.v2.ReceiveMessageRequest;
import apache.rocketmq.v2.Status;
import apache.rocketmq.v2.SyncLiteSubscriptionRequest;
import apache.rocketmq.v2.SyncLiteSubscriptionResponse;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.protobuf.util.Durations;
import java.time.Duration;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.client.apis.ClientException;
import org.apache.rocketmq.client.apis.consumer.FilterExpression;
import org.apache.rocketmq.client.apis.consumer.LitePushConsumer;
import org.apache.rocketmq.client.java.exception.LiteSubscriptionQuotaExceededException;
import org.apache.rocketmq.client.java.exception.StatusChecker;
import org.apache.rocketmq.client.java.impl.consumer.LitePushConsumerBuilderImpl;
import org.apache.rocketmq.client.java.impl.consumer.LitePushConsumerSettings;
import org.apache.rocketmq.client.java.impl.consumer.PushConsumerImpl;
import org.apache.rocketmq.client.java.route.Endpoints;
import org.apache.rocketmq.client.java.route.MessageQueueImpl;
import org.apache.rocketmq.client.java.rpc.RpcFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LitePushConsumerImpl
extends PushConsumerImpl
implements LitePushConsumer {
    private static final Logger log = LoggerFactory.getLogger(LitePushConsumerImpl.class);
    private volatile ScheduledFuture<?> syncAllScheduledFuture;
    private final LitePushConsumerSettings litePushConsumerSettings;

    public LitePushConsumerImpl(LitePushConsumerBuilderImpl builder) {
        super(builder.clientConfiguration, builder.consumerGroup, builder.subscriptionExpressions, builder.messageListener, builder.maxCacheMessageCount, builder.maxCacheMessageSizeInBytes, builder.consumptionThreadCount, false);
        this.litePushConsumerSettings = new LitePushConsumerSettings(builder, this.clientId, this.endpoints);
    }

    @Override
    protected void startUp() throws Exception {
        super.startUp();
        this.syncAllScheduledFuture = this.getScheduler().scheduleWithFixedDelay(() -> {
            try {
                this.syncAllLiteSubscription();
            }
            catch (Throwable t) {
                log.error("Schedule syncAllLiteSubscription error, clientId={}", (Object)this.clientId, (Object)t);
            }
        }, 30L, 30L, TimeUnit.SECONDS);
    }

    @Override
    protected void shutDown() throws InterruptedException {
        super.shutDown();
        if (null != this.syncAllScheduledFuture) {
            this.syncAllScheduledFuture.cancel(false);
        }
    }

    public void subscribeLite(String liteTopic) throws ClientException {
        this.subscribeLite(liteTopic, null);
    }

    public void subscribeLite(String liteTopic, org.apache.rocketmq.client.apis.consumer.OffsetOption offsetOption) throws ClientException {
        this.checkRunning();
        if (this.litePushConsumerSettings.containsLiteTopic(liteTopic)) {
            return;
        }
        this.validateLiteTopic(liteTopic);
        this.checkLiteSubscriptionQuota(1);
        ListenableFuture<Void> future = this.syncLiteSubscription(LiteSubscriptionAction.PARTIAL_ADD, Collections.singleton(liteTopic), offsetOption);
        try {
            this.handleClientFuture(future);
        }
        catch (ClientException e) {
            log.error("Failed to subscribeLite {}", (Object)liteTopic, (Object)e);
            throw e;
        }
        this.litePushConsumerSettings.addLiteTopic(liteTopic);
        log.info("SubscribeLite {}, topic={}, group={}, clientId={}", new Object[]{liteTopic, this.litePushConsumerSettings.bindTopic.getName(), this.getConsumerGroup(), this.clientId});
    }

    private void checkLiteSubscriptionQuota(int delta) throws LiteSubscriptionQuotaExceededException {
        int quota = this.litePushConsumerSettings.getLiteSubscriptionQuota();
        if (this.litePushConsumerSettings.getLiteTopicSetSize() + delta > quota) {
            throw new LiteSubscriptionQuotaExceededException(42902, null, "Lite subscription quota exceeded " + quota);
        }
    }

    private void validateLiteTopic(String liteTopic) {
        if (StringUtils.isBlank((CharSequence)liteTopic)) {
            throw new IllegalArgumentException("liteTopic is blank");
        }
        if (liteTopic.length() > this.litePushConsumerSettings.getMaxLiteTopicSize()) {
            String errorMessage = String.format("liteTopic length exceeded max length %d, liteTopic: %s", this.litePushConsumerSettings.getMaxLiteTopicSize(), liteTopic);
            throw new IllegalArgumentException(errorMessage);
        }
    }

    public void unsubscribeLite(String liteTopic) throws ClientException {
        this.checkRunning();
        if (!this.litePushConsumerSettings.containsLiteTopic(liteTopic)) {
            return;
        }
        ListenableFuture<Void> future = this.syncLiteSubscription(LiteSubscriptionAction.PARTIAL_REMOVE, Collections.singleton(liteTopic), null);
        try {
            this.handleClientFuture(future);
        }
        catch (ClientException e) {
            log.error("Failed to unsubscribeLite {}", (Object)liteTopic, (Object)e);
            throw e;
        }
        this.litePushConsumerSettings.removeLiteTopic(liteTopic);
        log.info("UnsubscribeLite {}, topic={}, group={}, clientId={}", new Object[]{liteTopic, this.litePushConsumerSettings.bindTopic.getName(), this.getConsumerGroup(), this.clientId});
    }

    public Set<String> getLiteTopicSet() {
        return this.litePushConsumerSettings.getLiteTopicSet();
    }

    @VisibleForTesting
    protected void syncAllLiteSubscription() throws ClientException {
        this.checkLiteSubscriptionQuota(0);
        Set<String> set = this.litePushConsumerSettings.getLiteTopicSet();
        ListenableFuture<Void> future = this.syncLiteSubscription(LiteSubscriptionAction.COMPLETE_ADD, set, null);
        this.handleClientFuture(future);
    }

    protected ListenableFuture<Void> syncLiteSubscription(LiteSubscriptionAction action, Collection<String> diff, org.apache.rocketmq.client.apis.consumer.OffsetOption offsetOption) {
        SyncLiteSubscriptionRequest.Builder builder = SyncLiteSubscriptionRequest.newBuilder().setAction(action).setTopic(this.litePushConsumerSettings.bindTopic.toProtobuf()).setGroup(this.litePushConsumerSettings.group.toProtobuf()).addAllLiteTopicSet(diff);
        if (offsetOption != null) {
            builder.setOffsetOption(this.toProtobufOffsetOption(offsetOption));
        }
        Endpoints endpoints = this.getEndpoints();
        return this.syncLiteSubscription0(endpoints, builder.build());
    }

    protected OffsetOption toProtobufOffsetOption(org.apache.rocketmq.client.apis.consumer.OffsetOption offsetOption) {
        OffsetOption.Builder protoBuilder = OffsetOption.newBuilder();
        switch (offsetOption.getType()) {
            case POLICY: {
                protoBuilder.setPolicy(this.toProtobufPolicy(offsetOption.getValue()));
                break;
            }
            case OFFSET: {
                protoBuilder.setOffset(offsetOption.getValue());
                break;
            }
            case TAIL_N: {
                protoBuilder.setTailN(offsetOption.getValue());
                break;
            }
            case TIMESTAMP: {
                protoBuilder.setTimestamp(offsetOption.getValue());
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown OffsetOption type: " + offsetOption.getType());
            }
        }
        return protoBuilder.build();
    }

    protected OffsetOption.Policy toProtobufPolicy(long policyValue) {
        if (policyValue == 0L) {
            return OffsetOption.Policy.LAST;
        }
        if (policyValue == 1L) {
            return OffsetOption.Policy.MIN;
        }
        if (policyValue == 2L) {
            return OffsetOption.Policy.MAX;
        }
        throw new IllegalArgumentException("Unknown policy type: " + policyValue);
    }

    protected ListenableFuture<Void> syncLiteSubscription0(Endpoints endpoints, SyncLiteSubscriptionRequest request) {
        Duration requestTimeout = this.clientConfiguration.getRequestTimeout();
        RpcFuture<SyncLiteSubscriptionRequest, SyncLiteSubscriptionResponse> future = this.getClientManager().syncLiteSubscription(endpoints, request, requestTimeout);
        return Futures.transformAsync(future, response -> {
            Status status = response.getStatus();
            StatusChecker.check(status, future);
            return Futures.immediateVoidFuture();
        }, (Executor)MoreExecutors.directExecutor());
    }

    @Override
    public void onNotifyUnsubscribeLiteCommand(Endpoints endpoints, NotifyUnsubscribeLiteCommand command) {
        String liteTopic = command.getLiteTopic();
        log.info("notify unsubscribe lite liteTopic={} group={} bindTopic={}", new Object[]{liteTopic, this.getConsumerGroup(), this.getSettings().bindTopic});
        if (StringUtils.isBlank((CharSequence)liteTopic)) {
            return;
        }
        this.litePushConsumerSettings.removeLiteTopic(liteTopic);
    }

    @Override
    public LitePushConsumerSettings getSettings() {
        return this.litePushConsumerSettings;
    }

    @Override
    ReceiveMessageRequest wrapReceiveMessageRequest(int batchSize, MessageQueueImpl mq, FilterExpression filterExpression, Duration longPollingTimeout, String attemptId) {
        attemptId = null == attemptId ? UUID.randomUUID().toString() : attemptId;
        return ReceiveMessageRequest.newBuilder().setGroup(this.getProtobufGroup()).setMessageQueue(mq.toProtobuf()).setLongPollingTimeout(Durations.fromNanos((long)longPollingTimeout.toNanos())).setBatchSize(batchSize).setAttemptId(attemptId).setAutoRenew(true).build();
    }

    @VisibleForTesting
    protected void checkRunning() {
        if (!this.isRunning()) {
            log.error("lite push consumer not running, state={}, clientId={}", (Object)this.state(), (Object)this.clientId);
            throw new IllegalStateException("lite push consumer not running");
        }
    }
}

