/*
 * Decompiled with CFR 0.152.
 */
package io.openmessaging.storage.dledger.client;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.serializer.SerializerFeature;
import io.openmessaging.storage.dledger.client.DLedgerClientRpcService;
import io.openmessaging.storage.dledger.protocol.AppendEntryRequest;
import io.openmessaging.storage.dledger.protocol.AppendEntryResponse;
import io.openmessaging.storage.dledger.protocol.DLedgerRequestCode;
import io.openmessaging.storage.dledger.protocol.GetEntriesRequest;
import io.openmessaging.storage.dledger.protocol.GetEntriesResponse;
import io.openmessaging.storage.dledger.protocol.LeadershipTransferRequest;
import io.openmessaging.storage.dledger.protocol.LeadershipTransferResponse;
import io.openmessaging.storage.dledger.protocol.MetadataRequest;
import io.openmessaging.storage.dledger.protocol.MetadataResponse;
import java.util.concurrent.CompletableFuture;
import org.apache.rocketmq.remoting.netty.NettyClientConfig;
import org.apache.rocketmq.remoting.netty.NettyRemotingClient;
import org.apache.rocketmq.remoting.protocol.RemotingCommand;

public class DLedgerClientRpcNettyService
extends DLedgerClientRpcService {
    private final NettyRemotingClient remotingClient = new NettyRemotingClient(new NettyClientConfig(), null);

    @Override
    public CompletableFuture<AppendEntryResponse> append(AppendEntryRequest request) throws Exception {
        RemotingCommand wrapperRequest = RemotingCommand.createRequestCommand((int)DLedgerRequestCode.APPEND.getCode(), null);
        wrapperRequest.setBody(JSON.toJSONBytes((Object)request, (SerializerFeature[])new SerializerFeature[0]));
        RemotingCommand wrapperResponse = this.remotingClient.invokeSync(this.getPeerAddr(request.getRemoteId()), wrapperRequest, 3000L);
        AppendEntryResponse response = (AppendEntryResponse)JSON.parseObject((byte[])wrapperResponse.getBody(), AppendEntryResponse.class, (Feature[])new Feature[0]);
        return CompletableFuture.completedFuture(response);
    }

    @Override
    public CompletableFuture<MetadataResponse> metadata(MetadataRequest request) throws Exception {
        RemotingCommand wrapperRequest = RemotingCommand.createRequestCommand((int)DLedgerRequestCode.METADATA.getCode(), null);
        wrapperRequest.setBody(JSON.toJSONBytes((Object)request, (SerializerFeature[])new SerializerFeature[0]));
        RemotingCommand wrapperResponse = this.remotingClient.invokeSync(this.getPeerAddr(request.getRemoteId()), wrapperRequest, 3000L);
        MetadataResponse response = (MetadataResponse)JSON.parseObject((byte[])wrapperResponse.getBody(), MetadataResponse.class, (Feature[])new Feature[0]);
        return CompletableFuture.completedFuture(response);
    }

    @Override
    public CompletableFuture<LeadershipTransferResponse> leadershipTransfer(LeadershipTransferRequest request) throws Exception {
        RemotingCommand wrapperRequest = RemotingCommand.createRequestCommand((int)DLedgerRequestCode.LEADERSHIP_TRANSFER.getCode(), null);
        wrapperRequest.setBody(JSON.toJSONBytes((Object)request, (SerializerFeature[])new SerializerFeature[0]));
        RemotingCommand wrapperResponse = this.remotingClient.invokeSync(this.getPeerAddr(request.getRemoteId()), wrapperRequest, 10000L);
        LeadershipTransferResponse response = (LeadershipTransferResponse)JSON.parseObject((byte[])wrapperResponse.getBody(), LeadershipTransferResponse.class, (Feature[])new Feature[0]);
        return CompletableFuture.completedFuture(response);
    }

    @Override
    public CompletableFuture<GetEntriesResponse> get(GetEntriesRequest request) throws Exception {
        RemotingCommand wrapperRequest = RemotingCommand.createRequestCommand((int)DLedgerRequestCode.GET.getCode(), null);
        wrapperRequest.setBody(JSON.toJSONBytes((Object)request, (SerializerFeature[])new SerializerFeature[0]));
        RemotingCommand wrapperResponse = this.remotingClient.invokeSync(this.getPeerAddr(request.getRemoteId()), wrapperRequest, 3000L);
        GetEntriesResponse response = (GetEntriesResponse)JSON.parseObject((byte[])wrapperResponse.getBody(), GetEntriesResponse.class, (Feature[])new Feature[0]);
        return CompletableFuture.completedFuture(response);
    }

    @Override
    public void startup() {
        this.remotingClient.start();
    }

    @Override
    public void shutdown() {
        this.remotingClient.shutdown();
    }
}

