/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.broker.metrics;

import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.rocketmq.broker.BrokerController;
import org.apache.rocketmq.broker.client.ConsumerGroupInfo;
import org.apache.rocketmq.broker.client.ConsumerManager;
import org.apache.rocketmq.broker.filter.ConsumerFilterData;
import org.apache.rocketmq.broker.filter.ConsumerFilterManager;
import org.apache.rocketmq.broker.filter.ExpressionMessageFilter;
import org.apache.rocketmq.broker.longpolling.PopCommandCallback;
import org.apache.rocketmq.broker.longpolling.PopLongPollingService;
import org.apache.rocketmq.broker.offset.ConsumerOffsetManager;
import org.apache.rocketmq.broker.processor.PopBufferMergeService;
import org.apache.rocketmq.broker.processor.PopInflightMessageCounter;
import org.apache.rocketmq.broker.subscription.SubscriptionGroupManager;
import org.apache.rocketmq.broker.topic.TopicConfigManager;
import org.apache.rocketmq.common.BrokerConfig;
import org.apache.rocketmq.common.KeyBuilder;
import org.apache.rocketmq.common.Pair;
import org.apache.rocketmq.common.TopicConfig;
import org.apache.rocketmq.common.constant.PermName;
import org.apache.rocketmq.logging.org.slf4j.Logger;
import org.apache.rocketmq.logging.org.slf4j.LoggerFactory;
import org.apache.rocketmq.remoting.protocol.filter.FilterAPI;
import org.apache.rocketmq.remoting.protocol.heartbeat.ConsumeType;
import org.apache.rocketmq.remoting.protocol.heartbeat.SubscriptionData;
import org.apache.rocketmq.remoting.protocol.subscription.SimpleSubscriptionData;
import org.apache.rocketmq.remoting.protocol.subscription.SubscriptionGroupConfig;
import org.apache.rocketmq.store.DefaultMessageFilter;
import org.apache.rocketmq.store.MessageFilter;
import org.apache.rocketmq.store.MessageStore;
import org.apache.rocketmq.store.exception.ConsumeQueueException;

public class ConsumerLagCalculator {
    private final BrokerConfig brokerConfig;
    private final TopicConfigManager topicConfigManager;
    private final ConsumerManager consumerManager;
    private final ConsumerOffsetManager offsetManager;
    private final ConsumerFilterManager consumerFilterManager;
    private final SubscriptionGroupManager subscriptionGroupManager;
    private final MessageStore messageStore;
    private final PopBufferMergeService popBufferMergeService;
    private final PopLongPollingService popLongPollingService;
    private final PopInflightMessageCounter popInflightMessageCounter;
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"RocketmqBroker");

    public ConsumerLagCalculator(BrokerController brokerController) {
        this.brokerConfig = brokerController.getBrokerConfig();
        this.topicConfigManager = brokerController.getTopicConfigManager();
        this.consumerManager = brokerController.getConsumerManager();
        this.offsetManager = brokerController.getConsumerOffsetManager();
        this.consumerFilterManager = brokerController.getConsumerFilterManager();
        this.subscriptionGroupManager = brokerController.getSubscriptionGroupManager();
        this.messageStore = brokerController.getMessageStore();
        this.popBufferMergeService = brokerController.getPopMessageProcessor().getPopBufferMergeService();
        this.popLongPollingService = brokerController.getPopMessageProcessor().getPopLongPollingService();
        this.popInflightMessageCounter = brokerController.getPopInflightMessageCounter();
    }

    private void processAllGroup(Consumer<ProcessGroupInfo> consumer) {
        for (Map.Entry subscriptionEntry : this.subscriptionGroupManager.getSubscriptionGroupTable().entrySet()) {
            Set<String> topics;
            String group = (String)subscriptionEntry.getKey();
            ConsumerGroupInfo consumerGroupInfo = this.consumerManager.getConsumerGroupInfo(group, true);
            boolean isPop = false;
            if (consumerGroupInfo != null) {
                boolean bl = isPop = consumerGroupInfo.getConsumeType() == ConsumeType.CONSUME_POP;
            }
            if (this.brokerConfig.isUseStaticSubscription()) {
                SubscriptionGroupConfig subscriptionGroupConfig = (SubscriptionGroupConfig)subscriptionEntry.getValue();
                if (subscriptionGroupConfig.getSubscriptionDataSet() == null || subscriptionGroupConfig.getSubscriptionDataSet().isEmpty()) continue;
                topics = subscriptionGroupConfig.getSubscriptionDataSet().stream().map(SimpleSubscriptionData::getTopic).collect(Collectors.toSet());
            } else {
                if (consumerGroupInfo == null) continue;
                topics = consumerGroupInfo.getSubscribeTopics();
            }
            if (null == topics || topics.isEmpty()) continue;
            for (String topic : topics) {
                int topicPerm;
                TopicConfig topicConfig;
                if (topic.startsWith("%RETRY%") || (topicConfig = this.topicConfigManager.selectTopicConfig(topic)) == null || !PermName.isReadable((int)(topicPerm = topicConfig.getPerm() & this.brokerConfig.getBrokerPermission())) && !PermName.isWriteable((int)topicPerm)) continue;
                if (isPop) {
                    int retryTopicPerm;
                    String retryTopicV1;
                    TopicConfig retryTopicConfigV1;
                    int retryTopicPerm2;
                    String retryTopic = KeyBuilder.buildPopRetryTopic((String)topic, (String)group, (boolean)this.brokerConfig.isEnableRetryTopicV2());
                    TopicConfig retryTopicConfig = this.topicConfigManager.selectTopicConfig(retryTopic);
                    if (retryTopicConfig != null && (PermName.isReadable((int)(retryTopicPerm2 = retryTopicConfig.getPerm() & this.brokerConfig.getBrokerPermission())) || PermName.isWriteable((int)retryTopicPerm2))) {
                        consumer.accept(new ProcessGroupInfo(group, topic, true, retryTopic));
                        continue;
                    }
                    if (this.brokerConfig.isEnableRetryTopicV2() && this.brokerConfig.isRetrieveMessageFromPopRetryTopicV1() && (retryTopicConfigV1 = this.topicConfigManager.selectTopicConfig(retryTopicV1 = KeyBuilder.buildPopRetryTopicV1((String)topic, (String)group))) != null && (PermName.isReadable((int)(retryTopicPerm = retryTopicConfigV1.getPerm() & this.brokerConfig.getBrokerPermission())) || PermName.isWriteable((int)retryTopicPerm))) {
                        consumer.accept(new ProcessGroupInfo(group, topic, true, retryTopicV1));
                        continue;
                    }
                    consumer.accept(new ProcessGroupInfo(group, topic, true, null));
                    continue;
                }
                consumer.accept(new ProcessGroupInfo(group, topic, false, null));
            }
        }
    }

    public void calculateLag(Consumer<CalculateLagResult> lagRecorder) {
        ArrayList futures = new ArrayList();
        BiConsumer<ProcessGroupInfo, CompletableFuture> biConsumer = (info, future) -> this.calculate((ProcessGroupInfo)info, future::complete);
        this.processAllGroup(info -> {
            if (info.group == null || info.topic == null) {
                return;
            }
            CompletableFuture<CalculateLagResult> future = new CompletableFuture<CalculateLagResult>();
            if (info.isPop && this.brokerConfig.isEnableNotifyBeforePopCalculateLag() && this.popLongPollingService.notifyMessageArriving(info.topic, -1, info.group, true, null, 0L, null, null, new PopCommandCallback((BiConsumer<ProcessGroupInfo, CompletableFuture<CalculateLagResult>>)biConsumer, (ProcessGroupInfo)info, future))) {
                futures.add(future);
                return;
            }
            this.calculate((ProcessGroupInfo)info, lagRecorder);
        });
        try {
            CompletableFuture.allOf(futures.toArray(new CompletableFuture[0])).get(10L, TimeUnit.SECONDS);
            futures.forEach(future -> {
                if (future.isDone() && !future.isCompletedExceptionally()) {
                    lagRecorder.accept((CalculateLagResult)future.join());
                }
            });
        }
        catch (Exception e) {
            LOGGER.error("Calculate lag timeout after 10 seconds", (Throwable)e);
        }
    }

    public void calculate(ProcessGroupInfo info, Consumer<CalculateLagResult> lagRecorder) {
        CalculateLagResult result = new CalculateLagResult(info.group, info.topic, false);
        try {
            Pair<Long, Long> lag = this.getConsumerLagStats(info.group, info.topic, info.isPop);
            if (lag != null) {
                result.lag = (Long)lag.getObject1();
                result.earliestUnconsumedTimestamp = (Long)lag.getObject2();
            }
            lagRecorder.accept(result);
        }
        catch (ConsumeQueueException e) {
            LOGGER.error("Failed to get lag stats", (Throwable)e);
        }
        if (info.isPop) {
            try {
                Pair<Long, Long> retryLag = this.getConsumerLagStats(info.group, info.retryTopic, true);
                result = new CalculateLagResult(info.group, info.topic, true);
                if (retryLag != null) {
                    result.lag = (Long)retryLag.getObject1();
                    result.earliestUnconsumedTimestamp = (Long)retryLag.getObject2();
                }
                lagRecorder.accept(result);
            }
            catch (ConsumeQueueException e) {
                LOGGER.error("Failed to get lag stats", (Throwable)e);
            }
        }
    }

    public void calculateInflight(Consumer<CalculateInflightResult> inflightRecorder) {
        this.processAllGroup(info -> {
            CalculateInflightResult result = new CalculateInflightResult(info.group, info.topic, false);
            try {
                Pair<Long, Long> inFlight = this.getInFlightMsgStats(info.group, info.topic, info.isPop);
                if (inFlight != null) {
                    result.inFlight = (Long)inFlight.getObject1();
                    result.earliestUnPulledTimestamp = (Long)inFlight.getObject2();
                }
                inflightRecorder.accept(result);
            }
            catch (ConsumeQueueException e) {
                LOGGER.error("Failed to get inflight message stats", (Throwable)e);
            }
            if (info.isPop) {
                try {
                    Pair<Long, Long> retryInFlight = this.getInFlightMsgStats(info.group, info.retryTopic, true);
                    result = new CalculateInflightResult(info.group, info.topic, true);
                    if (retryInFlight != null) {
                        result.inFlight = (Long)retryInFlight.getObject1();
                        result.earliestUnPulledTimestamp = (Long)retryInFlight.getObject2();
                    }
                    inflightRecorder.accept(result);
                }
                catch (ConsumeQueueException e) {
                    LOGGER.error("Failed to get inflight message stats", (Throwable)e);
                }
            }
        });
    }

    public void calculateAvailable(Consumer<CalculateAvailableResult> availableRecorder) {
        this.processAllGroup(info -> {
            CalculateAvailableResult result = new CalculateAvailableResult(info.group, info.topic, false);
            try {
                result.available = this.getAvailableMsgCount(info.group, info.topic, info.isPop);
                availableRecorder.accept(result);
            }
            catch (ConsumeQueueException e) {
                LOGGER.error("Failed to get available message count", (Throwable)e);
            }
            if (info.isPop) {
                try {
                    long retryAvailable = this.getAvailableMsgCount(info.group, info.retryTopic, true);
                    result = new CalculateAvailableResult(info.group, info.topic, true);
                    result.available = retryAvailable;
                    availableRecorder.accept(result);
                }
                catch (ConsumeQueueException e) {
                    LOGGER.error("Failed to get available message count", (Throwable)e);
                }
            }
        });
    }

    public Pair<Long, Long> getConsumerLagStats(String group, String topic, boolean isPop) throws ConsumeQueueException {
        long total = 0L;
        long earliestUnconsumedTimestamp = Long.MAX_VALUE;
        if (group == null || topic == null) {
            return new Pair((Object)total, (Object)earliestUnconsumedTimestamp);
        }
        TopicConfig topicConfig = this.topicConfigManager.selectTopicConfig(topic);
        if (topicConfig != null) {
            for (int queueId = 0; queueId < topicConfig.getWriteQueueNums(); ++queueId) {
                Pair<Long, Long> pair = this.getConsumerLagStats(group, topic, queueId, isPop);
                total += ((Long)pair.getObject1()).longValue();
                earliestUnconsumedTimestamp = Math.min(earliestUnconsumedTimestamp, (Long)pair.getObject2());
            }
        } else {
            LOGGER.warn("failed to get config of topic {}", (Object)topic);
        }
        if (earliestUnconsumedTimestamp < 0L || earliestUnconsumedTimestamp == Long.MAX_VALUE) {
            earliestUnconsumedTimestamp = 0L;
        }
        LOGGER.debug("GetConsumerLagStats, topic={}, group={}, lag={}, latency={}", new Object[]{topic, group, total, earliestUnconsumedTimestamp > 0L ? System.currentTimeMillis() - earliestUnconsumedTimestamp : 0L});
        return new Pair((Object)total, (Object)earliestUnconsumedTimestamp);
    }

    public Pair<Long, Long> getConsumerLagStats(String group, String topic, int queueId, boolean isPop) throws ConsumeQueueException {
        long brokerOffset = this.messageStore.getMaxOffsetInQueue(topic, queueId);
        if (brokerOffset < 0L) {
            brokerOffset = 0L;
        }
        if (isPop && !this.brokerConfig.isPopConsumerKVServiceEnable()) {
            long pullOffset = this.popBufferMergeService.getLatestOffset(topic, group, queueId);
            if (pullOffset < 0L) {
                pullOffset = this.offsetManager.queryOffset(group, topic, queueId);
            }
            if (pullOffset < 0L) {
                pullOffset = brokerOffset;
            }
            long inFlightNum = this.popInflightMessageCounter.getGroupPopInFlightMessageNum(topic, group, queueId);
            long lag = this.calculateMessageCount(group, topic, queueId, pullOffset, brokerOffset) + inFlightNum;
            long consumerOffset = pullOffset - inFlightNum;
            long consumerStoreTimeStamp = this.getStoreTimeStamp(topic, queueId, consumerOffset);
            return new Pair((Object)lag, (Object)consumerStoreTimeStamp);
        }
        long consumerOffset = this.offsetManager.queryOffset(group, topic, queueId);
        if (consumerOffset < 0L) {
            consumerOffset = brokerOffset;
        }
        long lag = this.calculateMessageCount(group, topic, queueId, consumerOffset, brokerOffset);
        long consumerStoreTimeStamp = this.getStoreTimeStamp(topic, queueId, consumerOffset);
        return new Pair((Object)lag, (Object)consumerStoreTimeStamp);
    }

    public Pair<Long, Long> getInFlightMsgStats(String group, String topic, boolean isPop) throws ConsumeQueueException {
        long total = 0L;
        long earliestUnPulledTimestamp = Long.MAX_VALUE;
        if (group == null || topic == null) {
            return new Pair((Object)total, (Object)earliestUnPulledTimestamp);
        }
        TopicConfig topicConfig = this.topicConfigManager.selectTopicConfig(topic);
        if (topicConfig != null) {
            for (int queueId = 0; queueId < topicConfig.getWriteQueueNums(); ++queueId) {
                Pair<Long, Long> pair = this.getInFlightMsgStats(group, topic, queueId, isPop);
                total += ((Long)pair.getObject1()).longValue();
                earliestUnPulledTimestamp = Math.min(earliestUnPulledTimestamp, (Long)pair.getObject2());
            }
        } else {
            LOGGER.warn("failed to get config of topic {}", (Object)topic);
        }
        if (earliestUnPulledTimestamp < 0L || earliestUnPulledTimestamp == Long.MAX_VALUE) {
            earliestUnPulledTimestamp = 0L;
        }
        return new Pair((Object)total, (Object)earliestUnPulledTimestamp);
    }

    public Pair<Long, Long> getInFlightMsgStats(String group, String topic, int queueId, boolean isPop) throws ConsumeQueueException {
        long commitOffset;
        if (isPop && !this.brokerConfig.isPopConsumerKVServiceEnable()) {
            long inflight = this.popInflightMessageCounter.getGroupPopInFlightMessageNum(topic, group, queueId);
            long pullOffset = this.popBufferMergeService.getLatestOffset(topic, group, queueId);
            if (pullOffset < 0L) {
                pullOffset = this.offsetManager.queryOffset(group, topic, queueId);
            }
            if (pullOffset < 0L) {
                pullOffset = this.messageStore.getMaxOffsetInQueue(topic, queueId);
            }
            long pullStoreTimeStamp = this.getStoreTimeStamp(topic, queueId, pullOffset);
            return new Pair((Object)inflight, (Object)pullStoreTimeStamp);
        }
        long pullOffset = this.offsetManager.queryPullOffset(group, topic, queueId);
        if (pullOffset < 0L) {
            pullOffset = 0L;
        }
        if ((commitOffset = this.offsetManager.queryOffset(group, topic, queueId)) < 0L) {
            commitOffset = pullOffset;
        }
        long inflight = this.calculateMessageCount(group, topic, queueId, commitOffset, pullOffset);
        long pullStoreTimeStamp = this.getStoreTimeStamp(topic, queueId, pullOffset);
        return new Pair((Object)inflight, (Object)pullStoreTimeStamp);
    }

    public long getAvailableMsgCount(String group, String topic, boolean isPop) throws ConsumeQueueException {
        long total = 0L;
        if (group == null || topic == null) {
            return total;
        }
        TopicConfig topicConfig = this.topicConfigManager.selectTopicConfig(topic);
        if (topicConfig != null) {
            for (int queueId = 0; queueId < topicConfig.getWriteQueueNums(); ++queueId) {
                total += this.getAvailableMsgCount(group, topic, queueId, isPop);
            }
        } else {
            LOGGER.warn("failed to get config of topic {}", (Object)topic);
        }
        return total;
    }

    public long getAvailableMsgCount(String group, String topic, int queueId, boolean isPop) throws ConsumeQueueException {
        long pullOffset;
        long brokerOffset = this.messageStore.getMaxOffsetInQueue(topic, queueId);
        if (brokerOffset < 0L) {
            brokerOffset = 0L;
        }
        if (isPop && !this.brokerConfig.isPopConsumerKVServiceEnable()) {
            pullOffset = this.popBufferMergeService.getLatestOffset(topic, group, queueId);
            if (pullOffset < 0L) {
                pullOffset = this.offsetManager.queryOffset(group, topic, queueId);
            }
        } else {
            pullOffset = this.offsetManager.queryPullOffset(group, topic, queueId);
        }
        if (pullOffset < 0L) {
            pullOffset = brokerOffset;
        }
        return this.calculateMessageCount(group, topic, queueId, pullOffset, brokerOffset);
    }

    public long getStoreTimeStamp(String topic, int queueId, long offset) {
        long storeTimeStamp = Long.MAX_VALUE;
        if (offset >= 0L) {
            storeTimeStamp = this.messageStore.getMessageStoreTimeStamp(topic, queueId, offset);
            storeTimeStamp = storeTimeStamp > 0L ? storeTimeStamp : Long.MAX_VALUE;
        }
        return storeTimeStamp;
    }

    public long calculateMessageCount(String group, String topic, int queueId, long from, long to) {
        long count = to - from;
        if (this.brokerConfig.isEstimateAccumulation() && to > from) {
            SubscriptionData subscriptionData = null;
            if (this.brokerConfig.isUseStaticSubscription()) {
                SubscriptionGroupConfig subscriptionGroupConfig = this.subscriptionGroupManager.findSubscriptionGroupConfig(group);
                if (subscriptionGroupConfig != null) {
                    for (SimpleSubscriptionData simpleSubscriptionData : subscriptionGroupConfig.getSubscriptionDataSet()) {
                        if (!topic.equals(simpleSubscriptionData.getTopic())) continue;
                        try {
                            subscriptionData = FilterAPI.buildSubscriptionData((String)simpleSubscriptionData.getTopic(), (String)simpleSubscriptionData.getExpression(), (String)simpleSubscriptionData.getExpressionType());
                        }
                        catch (Exception e) {
                            LOGGER.error("Try to build subscription for group:{}, topic:{} exception.", new Object[]{group, topic, e});
                        }
                        break;
                    }
                }
            } else {
                ConsumerGroupInfo consumerGroupInfo = this.consumerManager.getConsumerGroupInfo(group, true);
                if (consumerGroupInfo != null) {
                    subscriptionData = consumerGroupInfo.findSubscriptionData(topic);
                }
            }
            if (null != subscriptionData) {
                if ("TAG".equalsIgnoreCase(subscriptionData.getExpressionType()) && !"*".equals(subscriptionData.getSubString())) {
                    count = this.messageStore.estimateMessageCount(topic, queueId, from, to, (MessageFilter)new DefaultMessageFilter(subscriptionData));
                } else if ("SQL92".equalsIgnoreCase(subscriptionData.getExpressionType())) {
                    ConsumerFilterData consumerFilterData = this.consumerFilterManager.get(topic, group);
                    count = this.messageStore.estimateMessageCount(topic, queueId, from, to, (MessageFilter)new ExpressionMessageFilter(subscriptionData, consumerFilterData, this.consumerFilterManager));
                }
            }
        }
        return count < 0L ? 0L : count;
    }

    public static class CalculateAvailableResult
    extends BaseCalculateResult {
        public long available;

        public CalculateAvailableResult(String group, String topic, boolean isRetry) {
            super(group, topic, isRetry);
        }
    }

    public static class CalculateInflightResult
    extends BaseCalculateResult {
        public long inFlight;
        public long earliestUnPulledTimestamp;

        public CalculateInflightResult(String group, String topic, boolean isRetry) {
            super(group, topic, isRetry);
        }
    }

    public static class CalculateLagResult
    extends BaseCalculateResult {
        public long lag;
        public long earliestUnconsumedTimestamp;

        public CalculateLagResult(String group, String topic, boolean isRetry) {
            super(group, topic, isRetry);
        }
    }

    public static class BaseCalculateResult {
        public String group;
        public String topic;
        public boolean isRetry;

        public BaseCalculateResult(String group, String topic, boolean isRetry) {
            this.group = group;
            this.topic = topic;
            this.isRetry = isRetry;
        }
    }

    public static class ProcessGroupInfo {
        public String group;
        public String topic;
        public boolean isPop;
        public String retryTopic;

        public ProcessGroupInfo(String group, String topic, boolean isPop, String retryTopic) {
            this.group = group;
            this.topic = topic;
            this.isPop = isPop;
            this.retryTopic = retryTopic;
        }
    }
}

