/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.jraft;

import com.alipay.sofa.jraft.conf.Configuration;
import com.alipay.sofa.jraft.core.NodeImpl;
import com.alipay.sofa.jraft.entity.PeerId;
import com.alipay.sofa.jraft.option.BootstrapOptions;
import com.alipay.sofa.jraft.util.Endpoint;
import com.alipay.sofa.jraft.util.JRaftServiceLoader;
import com.alipay.sofa.jraft.util.NamedThreadFactory;
import com.alipay.sofa.jraft.util.ThreadPoolUtil;
import com.alipay.sofa.jraft.util.timer.RaftTimerFactory;
import java.util.concurrent.Executor;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import org.apache.commons.lang.StringUtils;

public final class JRaftUtils {
    private static final RaftTimerFactory TIMER_FACTORY = JRaftServiceLoader.load(RaftTimerFactory.class).first();

    public static RaftTimerFactory raftTimerFactory() {
        return TIMER_FACTORY;
    }

    public static boolean bootstrap(BootstrapOptions opts) throws InterruptedException {
        NodeImpl node = new NodeImpl(opts.getGroupId(), null);
        boolean ret = node.bootstrap(opts);
        node.shutdown();
        node.join();
        return ret;
    }

    public static Executor createExecutor(String prefix, int number) {
        if (number <= 0) {
            return null;
        }
        return ThreadPoolUtil.newBuilder().poolName(prefix).enableMetric(true).coreThreads(number).maximumThreads(number).keepAliveSeconds(60L).workQueue(new SynchronousQueue<Runnable>()).threadFactory(JRaftUtils.createThreadFactory(prefix)).build();
    }

    public static ThreadFactory createThreadFactory(String prefixName) {
        return new NamedThreadFactory(prefixName, true);
    }

    public static Configuration getConfiguration(String s) {
        Configuration conf = new Configuration();
        if (StringUtils.isBlank((String)s)) {
            return conf;
        }
        if (conf.parse(s)) {
            return conf;
        }
        throw new IllegalArgumentException("Invalid conf str:" + s);
    }

    public static PeerId getPeerId(String s) {
        PeerId peer = new PeerId();
        if (StringUtils.isBlank((String)s)) {
            return peer;
        }
        if (peer.parse(s)) {
            return peer;
        }
        throw new IllegalArgumentException("Invalid peer str:" + s);
    }

    public static Endpoint getEndPoint(String s) {
        if (StringUtils.isBlank((String)s)) {
            return null;
        }
        String[] tmps = StringUtils.split((String)s, (char)':');
        if (tmps.length != 2) {
            throw new IllegalArgumentException("Invalid endpoint string: " + s);
        }
        return new Endpoint(tmps[0], Integer.parseInt(tmps[1]));
    }

    private JRaftUtils() {
    }
}

