/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.examples.membership.server;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import org.apache.ratis.RaftConfigKeys;
import org.apache.ratis.conf.RaftProperties;
import org.apache.ratis.examples.counter.server.CounterStateMachine;
import org.apache.ratis.netty.NettyConfigKeys;
import org.apache.ratis.protocol.RaftGroup;
import org.apache.ratis.protocol.RaftGroupId;
import org.apache.ratis.protocol.RaftPeer;
import org.apache.ratis.protocol.RaftPeerId;
import org.apache.ratis.rpc.SupportedRpcType;
import org.apache.ratis.server.RaftServer;
import org.apache.ratis.server.RaftServerConfigKeys;
import org.apache.ratis.server.storage.RaftStorage;
import org.apache.ratis.thirdparty.com.google.common.base.MoreObjects;
import org.apache.ratis.util.FileUtils;

public class CServer {
    public static final RaftGroupId GROUP_ID = RaftGroupId.randomId();
    public static final String LOCAL_ADDR = "0.0.0.0";
    private final RaftServer server;
    private final int port;
    private final File storageDir;

    public CServer(RaftGroup group, RaftPeerId serverId, int port) throws IOException {
        this.storageDir = new File("./" + serverId);
        this.port = port;
        RaftProperties properties = new RaftProperties();
        RaftServerConfigKeys.setStorageDir(properties, Collections.singletonList(this.storageDir));
        RaftConfigKeys.Rpc.setType(properties, SupportedRpcType.NETTY);
        NettyConfigKeys.Server.setPort(properties, port);
        CounterStateMachine counterStateMachine = new CounterStateMachine();
        this.server = RaftServer.newBuilder().setGroup(group).setProperties(properties).setServerId(serverId).setStateMachine(counterStateMachine).setOption(RaftStorage.StartupOption.FORMAT).build();
    }

    public void start() throws IOException {
        this.server.start();
    }

    public RaftPeer getPeer() {
        return this.server.getPeer();
    }

    public void close() throws IOException {
        this.server.close();
        FileUtils.deleteFully(this.storageDir);
    }

    public String toString() {
        try {
            return MoreObjects.toStringHelper(this).add("server", this.server.getPeer()).add("role", this.server.getDivision(GROUP_ID).getInfo().getCurrentRole()).toString();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public int getPort() {
        return this.port;
    }
}

