/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.examples.common;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.ratis.protocol.RaftGroup;
import org.apache.ratis.protocol.RaftGroupId;
import org.apache.ratis.protocol.RaftPeer;
import org.apache.ratis.util.JavaUtils;
import org.apache.ratis.util.TimeDuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Constants {
    private static final Logger LOG = LoggerFactory.getLogger(Constants.class);
    private static final String CONF_FILE_NAME = "conf.properties";
    private static final List<String> CONF_FILE_DEFAULTS = Collections.unmodifiableList(Arrays.asList("examples/conf/conf.properties", "ratis-examples/src/main/resources/conf.properties"));
    private static final String CONF_FILE_ENV_VAR_NAME = "RATIS_EXAMPLE_CONF";
    public static final List<RaftPeer> PEERS;
    public static final String PATH;
    public static final List<TimeDuration> SIMULATED_SLOWNESS;
    private static final UUID GROUP_ID;
    public static final RaftGroup RAFT_GROUP;

    static Path getConfPath() {
        String env = JavaUtils.getEnv(CONF_FILE_ENV_VAR_NAME);
        Stream s2 = Stream.concat(Optional.ofNullable(env).map(Stream::of).orElseGet(Stream::empty), CONF_FILE_DEFAULTS.stream());
        Iterator i = s2.iterator();
        while (i.hasNext()) {
            Path p = Paths.get((String)i.next(), new String[0]);
            if (!Files.exists(p, new LinkOption[0])) continue;
            LOG.info("Using conf file {}", (Object)p);
            return p;
        }
        throw new IllegalArgumentException("Conf file not found: please set environment variable \"RATIS_EXAMPLE_CONF\"");
    }

    private Constants() {
    }

    static {
        Properties properties = new Properties();
        Path conf = Constants.getConfPath();
        try (BufferedReader in = new BufferedReader(new InputStreamReader(Files.newInputStream(conf, new OpenOption[0]), StandardCharsets.UTF_8));){
            properties.load(in);
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to load " + conf, e);
        }
        Function<String, String[]> parseConfList = confKey -> Optional.ofNullable(properties.getProperty((String)confKey)).map(s2 -> s2.split(",")).orElse(null);
        String key = "raft.server.address.list";
        String[] addresses = parseConfList.apply("raft.server.address.list");
        if (addresses == null || addresses.length == 0) {
            throw new IllegalArgumentException("Failed to get raft.server.address.list from " + conf);
        }
        String priorityKey = "raft.server.priority.list";
        String[] priorities = parseConfList.apply("raft.server.priority.list");
        if (priorities != null && priorities.length != addresses.length) {
            throw new IllegalArgumentException("priority should be assigned to each server in " + conf);
        }
        String slownessKey = "raft.server.simulated-slowness.list";
        String[] slowness = parseConfList.apply("raft.server.simulated-slowness.list");
        if (slowness != null && slowness.length != addresses.length) {
            throw new IllegalArgumentException("simulated-slowness should be assigned to each server in" + conf);
        }
        SIMULATED_SLOWNESS = slowness == null ? null : Arrays.stream(slowness).map(s2 -> TimeDuration.valueOf(s2, TimeUnit.SECONDS)).collect(Collectors.toList());
        String key1 = "raft.server.root.storage.path";
        String path = properties.getProperty("raft.server.root.storage.path");
        PATH = path == null ? "./ratis-examples/target" : path;
        ArrayList<RaftPeer> peers = new ArrayList<RaftPeer>(addresses.length);
        for (int i = 0; i < addresses.length; ++i) {
            int priority = priorities == null ? 0 : Integer.parseInt(priorities[i]);
            peers.add(RaftPeer.newBuilder().setId("n" + i).setAddress(addresses[i]).setPriority(priority).build());
        }
        PEERS = Collections.unmodifiableList(peers);
        GROUP_ID = UUID.fromString("02511d47-d67c-49a3-9011-abb3109a44c1");
        RAFT_GROUP = RaftGroup.valueOf(RaftGroupId.valueOf(GROUP_ID), PEERS);
    }
}

