/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.sizing;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.ranger.plugin.model.RangerPolicy;
import org.apache.ranger.plugin.policyengine.RangerAccessRequest;
import org.apache.ranger.plugin.policyengine.RangerAccessRequestImpl;
import org.apache.ranger.plugin.policyengine.RangerAccessResource;
import org.apache.ranger.plugin.policyengine.RangerAccessResourceImpl;
import org.apache.ranger.plugin.util.ServicePolicies;
import org.apache.ranger.plugin.util.ServiceTags;

public class PerfRequestGenerator {
    private final Set<String> resourceKeys;

    public PerfRequestGenerator(Set<String> resourceKeys) {
        this.resourceKeys = resourceKeys != null ? resourceKeys : Collections.emptySet();
    }

    public Collection<RangerAccessRequest> generate(ServicePolicies policies, ServiceTags tags) {
        ArrayList<RangerAccessRequest> ret = new ArrayList<RangerAccessRequest>();
        HashSet resources = new HashSet();
        HashSet<String> accessTypes = new HashSet<String>();
        HashSet<String> users = new HashSet<String>();
        HashSet<String> groups = new HashSet<String>();
        if (policies != null) {
            if (policies.getServiceDef() != null && policies.getServiceDef().getAccessTypes() != null) {
                policies.getServiceDef().getAccessTypes().forEach(atd -> accessTypes.add(atd.getName()));
            }
            if (policies.getPolicies() != null) {
                policies.getPolicies().forEach(policy -> {
                    this.collectResources(policy.getResources(), resources);
                    if (policy.getAdditionalResources() != null) {
                        policy.getAdditionalResources().forEach(resource -> this.collectResources((Map<String, RangerPolicy.RangerPolicyResource>)resource, resources));
                    }
                    this.collectUsersGroups((RangerPolicy)policy, (Set<String>)users, (Set<String>)groups);
                });
            }
            if (policies.getTagPolicies() != null && policies.getTagPolicies().getPolicies() != null) {
                policies.getTagPolicies().getPolicies().forEach(policy -> this.collectUsersGroups((RangerPolicy)policy, (Set<String>)users, (Set<String>)groups));
            }
        }
        if (tags != null && tags.getServiceResources() != null) {
            tags.getServiceResources().forEach(resource -> this.collectResources(resource.getResourceElements(), resources));
        }
        if (accessTypes.isEmpty()) {
            accessTypes.add("read");
        }
        if (users.isEmpty()) {
            users.add("user1");
        }
        if (groups.isEmpty()) {
            groups.add("group1");
        }
        Iterator iterAccessTypes = accessTypes.iterator();
        Iterator iterUser = users.iterator();
        Iterator iterGroup = groups.iterator();
        for (Map resource2 : resources) {
            String accessType = (String)iterAccessTypes.next();
            String user = (String)iterUser.next();
            Set userGroups = Collections.singleton(iterGroup.next());
            ret.add((RangerAccessRequest)new RangerAccessRequestImpl((RangerAccessResource)new RangerAccessResourceImpl(resource2), accessType, user, userGroups, null));
            if (!iterAccessTypes.hasNext()) {
                iterAccessTypes = accessTypes.iterator();
            }
            if (!iterUser.hasNext()) {
                iterUser = users.iterator();
            }
            if (iterGroup.hasNext()) continue;
            iterGroup = groups.iterator();
        }
        return ret;
    }

    private void collectResources(Map<String, RangerPolicy.RangerPolicyResource> policyResource, Set<Map<String, Object>> resources) {
        if (policyResource != null) {
            int resourceCount = 1;
            for (Map.Entry<String, RangerPolicy.RangerPolicyResource> entry : policyResource.entrySet()) {
                String name = entry.getKey();
                List values = entry.getValue().getValues();
                if (values.isEmpty() || !this.resourceKeys.isEmpty() && !this.resourceKeys.contains(name)) continue;
                resourceCount *= values.size();
            }
            ArrayList toAdd = new ArrayList(resourceCount);
            for (int i = 0; i < resourceCount; ++i) {
                toAdd.add(new HashMap());
            }
            for (Map.Entry<String, RangerPolicy.RangerPolicyResource> entry : policyResource.entrySet()) {
                String name = entry.getKey();
                List values = entry.getValue().getValues();
                if (values.isEmpty() || !this.resourceKeys.isEmpty() && !this.resourceKeys.contains(name)) continue;
                for (int idxResource = 0; idxResource < resourceCount; ++idxResource) {
                    ((Map)toAdd.get(idxResource)).put(name, values.get(idxResource % values.size()));
                }
            }
            resources.addAll(toAdd);
        }
    }

    private void collectUsersGroups(RangerPolicy policy, Set<String> users, Set<String> groups) {
        this.collectUsersGroups(policy.getPolicyItems(), users, groups);
        this.collectUsersGroups(policy.getAllowExceptions(), users, groups);
        this.collectUsersGroups(policy.getDenyPolicyItems(), users, groups);
        this.collectUsersGroups(policy.getDenyExceptions(), users, groups);
        this.collectUsersGroups(policy.getDataMaskPolicyItems(), users, groups);
        this.collectUsersGroups(policy.getRowFilterPolicyItems(), users, groups);
    }

    private void collectUsersGroups(List<? extends RangerPolicy.RangerPolicyItem> policyItems, Set<String> users, Set<String> groups) {
        if (policyItems != null) {
            policyItems.forEach(policyItem -> {
                users.addAll(policyItem.getUsers());
                groups.addAll(policyItem.getGroups());
            });
        }
    }
}

