/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.authorization.hive.authorizer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveOperationType;
import org.apache.ranger.audit.model.AuthzAuditEvent;
import org.apache.ranger.authorization.hive.authorizer.HiveAccessType;
import org.apache.ranger.authorization.hive.authorizer.HiveObjectType;
import org.apache.ranger.authorization.hive.authorizer.RangerHiveAccessRequest;
import org.apache.ranger.authorization.hive.authorizer.RangerHiveResource;
import org.apache.ranger.plugin.audit.RangerDefaultAuditHandler;
import org.apache.ranger.plugin.policyengine.RangerAccessRequest;
import org.apache.ranger.plugin.policyengine.RangerAccessResource;
import org.apache.ranger.plugin.policyengine.RangerAccessResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RangerHiveAuditHandler
extends RangerDefaultAuditHandler {
    private static final Logger LOG = LoggerFactory.getLogger(RangerDefaultAuditHandler.class);
    public static final String ACCESS_TYPE_ROWFILTER = "ROW_FILTER";
    public static final String ACCESS_TYPE_INSERT = "INSERT";
    public static final String ACCESS_TYPE_UPDATE = "UPDATE";
    public static final String ACCESS_TYPE_DELETE = "DELETE";
    public static final String ACCESS_TYPE_TRUNCATE = "TRUNCATE";
    public static final String ACTION_TYPE_METADATA_OPERATION = "METADATA OPERATION";
    public static final String URL_RESOURCE_TYPE = "url";
    public static final String CONF_AUDIT_QUERY_REQUEST_SIZE = "xasecure.audit.solr.limit.query.req.size";
    public static final int DEFAULT_CONF_AUDIT_QUERY_REQUEST_SIZE = Integer.MAX_VALUE;
    private static final Set<String> ROLE_OPS = new HashSet<String>();
    private final int requestQuerySize;
    private final Collection<AuthzAuditEvent> auditEvents = new ArrayList<AuthzAuditEvent>();
    private boolean deniedExists = false;

    public RangerHiveAuditHandler() {
        this.requestQuerySize = Integer.MAX_VALUE;
    }

    public RangerHiveAuditHandler(Configuration config) {
        super(config);
        int configRequestQuerySize = config.getInt(CONF_AUDIT_QUERY_REQUEST_SIZE, Integer.MAX_VALUE);
        this.requestQuerySize = configRequestQuerySize < 1 ? Integer.MAX_VALUE : configRequestQuerySize;
    }

    AuthzAuditEvent createAuditEvent(RangerAccessResult result, String accessType, String resourcePath) {
        RangerAccessRequest request = result.getAccessRequest();
        RangerAccessResource resource = request.getResource();
        String resourceType = resource != null ? resource.getLeafName() : null;
        AuthzAuditEvent auditEvent = super.getAuthzEvents(result);
        String resourcePathComputed = resourcePath;
        if (URL_RESOURCE_TYPE.equals(resourceType)) {
            resourcePathComputed = this.getURLPathString(resource, resourcePathComputed);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("requestQuerySize = " + this.requestQuerySize);
        }
        if (StringUtils.isNotBlank((String)request.getRequestData()) && request.getRequestData().length() > this.requestQuerySize) {
            auditEvent.setRequestData(request.getRequestData().substring(0, this.requestQuerySize));
        } else {
            auditEvent.setRequestData(request.getRequestData());
        }
        auditEvent.setAccessType(accessType);
        auditEvent.setResourcePath(resourcePathComputed);
        auditEvent.setResourceType("@" + resourceType);
        if (request instanceof RangerHiveAccessRequest && resource instanceof RangerHiveResource) {
            RangerHiveAccessRequest hiveAccessRequest = (RangerHiveAccessRequest)request;
            RangerHiveResource hiveResource = (RangerHiveResource)resource;
            HiveAccessType hiveAccessType = hiveAccessRequest.getHiveAccessType();
            if (hiveAccessType == HiveAccessType.USE && hiveResource.getObjectType() == HiveObjectType.DATABASE && StringUtils.isBlank((String)hiveResource.getDatabase())) {
                auditEvent.setTags(null);
            }
            if (hiveAccessType == HiveAccessType.REPLADMIN) {
                String context = request.getRequestData();
                String replAccessType = this.getReplCmd(context);
                auditEvent.setAccessType(replAccessType);
            }
            if (hiveAccessType == HiveAccessType.SERVICEADMIN) {
                String hiveOperationType = request.getAction();
                String commandStr = request.getRequestData();
                if (HiveOperationType.KILL_QUERY.name().equalsIgnoreCase(hiveOperationType)) {
                    String queryId = this.getServiceAdminQueryId(commandStr);
                    if (!StringUtils.isEmpty((String)queryId)) {
                        auditEvent.setRequestData(queryId);
                    }
                    if (StringUtils.isEmpty((String)(commandStr = this.getServiceAdminCmd(commandStr)))) {
                        commandStr = hiveAccessType.name();
                    }
                }
                auditEvent.setAccessType(commandStr);
            }
            String action = request.getAction();
            if (hiveResource.getObjectType() == HiveObjectType.GLOBAL && ROLE_OPS.contains(action)) {
                auditEvent.setAccessType(action);
            }
        }
        return auditEvent;
    }

    AuthzAuditEvent createAuditEvent(RangerAccessResult result) {
        AuthzAuditEvent ret;
        RangerAccessRequest request = result.getAccessRequest();
        RangerAccessResource resource = request.getResource();
        String resourcePath = resource != null ? resource.getAsString() : null;
        int policyType = result.getPolicyType();
        if (policyType == 1 && result.isMaskEnabled()) {
            ret = this.createAuditEvent(result, result.getMaskType(), resourcePath);
        } else if (policyType == 2 && result.isRowFilterEnabled()) {
            ret = this.createAuditEvent(result, ACCESS_TYPE_ROWFILTER, resourcePath);
        } else if (policyType == 0) {
            String accessType = null;
            if (request instanceof RangerHiveAccessRequest) {
                String commandStr;
                RangerHiveAccessRequest hiveRequest = (RangerHiveAccessRequest)request;
                accessType = hiveRequest.getHiveAccessType().toString();
                String action = request.getAction();
                if (ACTION_TYPE_METADATA_OPERATION.equals(action)) {
                    accessType = ACTION_TYPE_METADATA_OPERATION;
                } else if (HiveAccessType.UPDATE.toString().equalsIgnoreCase(accessType) && StringUtils.isNotBlank((String)(commandStr = request.getRequestData()))) {
                    if (StringUtils.startsWithIgnoreCase((String)commandStr, (String)ACCESS_TYPE_INSERT)) {
                        accessType = ACCESS_TYPE_INSERT;
                    } else if (StringUtils.startsWithIgnoreCase((String)commandStr, (String)ACCESS_TYPE_UPDATE)) {
                        accessType = ACCESS_TYPE_UPDATE;
                    } else if (StringUtils.startsWithIgnoreCase((String)commandStr, (String)ACCESS_TYPE_DELETE)) {
                        accessType = ACCESS_TYPE_DELETE;
                    } else if (StringUtils.startsWithIgnoreCase((String)commandStr, (String)ACCESS_TYPE_TRUNCATE)) {
                        accessType = ACCESS_TYPE_TRUNCATE;
                    }
                }
            }
            if (StringUtils.isEmpty(accessType)) {
                accessType = request.getAccessType();
            }
            ret = this.createAuditEvent(result, accessType, resourcePath);
        } else {
            ret = null;
        }
        return ret;
    }

    List<AuthzAuditEvent> createAuditEvents(Collection<RangerAccessResult> results) {
        ArrayList<AuthzAuditEvent> result;
        HashMap<Long, AuthzAuditEvent> auditEventsMap = new HashMap<Long, AuthzAuditEvent>();
        Iterator<RangerAccessResult> iterator = results.iterator();
        AuthzAuditEvent deniedAuditEvent = null;
        while (iterator.hasNext() && deniedAuditEvent == null) {
            AuthzAuditEvent auditEvent;
            result = iterator.next();
            if (!result.getIsAudited()) continue;
            if (!result.getIsAllowed()) {
                deniedAuditEvent = this.createAuditEvent((RangerAccessResult)result);
                continue;
            }
            long policyId = result.getPolicyId();
            if (auditEventsMap.containsKey(policyId)) {
                auditEvent = (AuthzAuditEvent)auditEventsMap.get(policyId);
                RangerHiveAccessRequest request = (RangerHiveAccessRequest)result.getAccessRequest();
                RangerHiveResource resource = (RangerHiveResource)request.getResource();
                String resourcePath = auditEvent.getResourcePath() + "," + resource.getColumn();
                auditEvent.setResourcePath(resourcePath);
                Set tags = this.getTags((RangerAccessRequest)request);
                if (tags == null) continue;
                auditEvent.getTags().addAll(tags);
                continue;
            }
            auditEvent = this.createAuditEvent((RangerAccessResult)result);
            if (auditEvent == null) continue;
            auditEventsMap.put(policyId, auditEvent);
        }
        result = deniedAuditEvent == null ? new ArrayList(auditEventsMap.values()) : Collections.singletonList(deniedAuditEvent);
        return result;
    }

    public void processResult(RangerAccessResult result) {
        if (!result.getIsAudited()) {
            return;
        }
        if (this.skipFilterOperationAuditing(result)) {
            return;
        }
        AuthzAuditEvent auditEvent = this.createAuditEvent(result);
        if (auditEvent != null) {
            this.addAuthzAuditEvent(auditEvent);
        }
    }

    public void processResults(Collection<RangerAccessResult> results) {
        List<AuthzAuditEvent> result = this.createAuditEvents(results);
        for (AuthzAuditEvent auditEvent : result) {
            this.addAuthzAuditEvent(auditEvent);
        }
    }

    public void logAuditEventForDfs(String userName, String dfsCommand, boolean accessGranted, int repositoryType, String repositoryName) {
        AuthzAuditEvent auditEvent = new AuthzAuditEvent();
        auditEvent.setAclEnforcer(this.moduleName);
        auditEvent.setResourceType("@dfs");
        auditEvent.setAccessType("DFS");
        auditEvent.setAction("DFS");
        auditEvent.setUser(userName);
        auditEvent.setAccessResult((short)(accessGranted ? 1 : 0));
        auditEvent.setEventTime(new Date());
        auditEvent.setRepositoryType(repositoryType);
        auditEvent.setRepositoryName(repositoryName);
        auditEvent.setRequestData(dfsCommand);
        auditEvent.setResourcePath(dfsCommand);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Logging DFS event " + auditEvent.toString());
        }
        this.addAuthzAuditEvent(auditEvent);
    }

    public void flushAudit() {
        for (AuthzAuditEvent auditEvent : this.auditEvents) {
            if (this.deniedExists && auditEvent.getAccessResult() != 0) continue;
            super.logAuthzAudit(auditEvent);
        }
    }

    private void addAuthzAuditEvent(AuthzAuditEvent auditEvent) {
        if (auditEvent != null) {
            this.auditEvents.add(auditEvent);
            if (auditEvent.getAccessResult() == 0) {
                this.deniedExists = true;
            }
        }
    }

    private String getReplCmd(String cmdString) {
        Object[] cmd;
        String ret = "REPL";
        if (cmdString != null && !ArrayUtils.isEmpty((Object[])(cmd = cmdString.trim().split("\\s+"))) && cmd.length > 2) {
            ret = (String)cmd[0] + " " + (String)cmd[1];
        }
        return ret;
    }

    private String getServiceAdminCmd(String cmdString) {
        Object[] cmd;
        String ret = "SERVICE ADMIN";
        if (cmdString != null && !ArrayUtils.isEmpty((Object[])(cmd = cmdString.trim().split("\\s+"))) && cmd.length > 1) {
            ret = (String)cmd[0] + " " + (String)cmd[1];
        }
        return ret;
    }

    private String getServiceAdminQueryId(String cmdString) {
        Object[] cmd;
        String ret = "QUERY ID = ";
        if (cmdString != null && !ArrayUtils.isEmpty((Object[])(cmd = cmdString.trim().split("\\s+"))) && cmd.length > 2) {
            ret = ret + (String)cmd[2];
        }
        return ret;
    }

    private boolean skipFilterOperationAuditing(RangerAccessResult result) {
        String action;
        boolean ret = false;
        RangerAccessRequest accessRequest = result.getAccessRequest();
        if (accessRequest != null && ACTION_TYPE_METADATA_OPERATION.equals(action = accessRequest.getAction()) && !result.getIsAllowed()) {
            ret = true;
        }
        return ret;
    }

    private String getURLPathString(RangerAccessResource resource, String resourcePath) {
        List resourcePathVal;
        String ret = resourcePath;
        Object val = resource.getValue(URL_RESOURCE_TYPE);
        if (val instanceof List && CollectionUtils.isNotEmpty((Collection)(resourcePathVal = (List)val))) {
            ret = (String)resourcePathVal.iterator().next();
        }
        return ret;
    }

    static {
        for (HiveOperationType hiveOperationType : EnumSet.of(HiveOperationType.CREATEROLE, new HiveOperationType[]{HiveOperationType.DROPROLE, HiveOperationType.SHOW_ROLES, HiveOperationType.SHOW_ROLE_GRANT, HiveOperationType.SHOW_ROLE_PRINCIPALS, HiveOperationType.GRANT_ROLE, HiveOperationType.REVOKE_ROLE})) {
            ROLE_OPS.add(hiveOperationType.name());
        }
    }
}

