/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.protonj2.client;

import java.util.concurrent.TimeUnit;
import org.apache.qpid.protonj2.client.LinkOptions;

public final class StreamReceiverOptions
extends LinkOptions<StreamReceiverOptions>
implements Cloneable {
    public static final int DEFAULT_READ_BUFFER_SIZE = 0x6400000;
    private int readBufferSize = 0x6400000;
    private long drainTimeout = 60000L;
    private boolean autoAccept = true;
    private int creditWindow = 10;

    public StreamReceiverOptions() {
    }

    public StreamReceiverOptions(StreamReceiverOptions options) {
        if (options != null) {
            options.copyInto(this);
        }
    }

    public StreamReceiverOptions clone() {
        return this.copyInto(new StreamReceiverOptions());
    }

    protected StreamReceiverOptions copyInto(StreamReceiverOptions other) {
        super.copyInto(other);
        other.readBufferSize(this.readBufferSize);
        other.autoAccept(this.autoAccept);
        other.creditWindow(this.creditWindow);
        other.drainTimeout(this.drainTimeout);
        return other;
    }

    public int readBufferSize() {
        return this.readBufferSize;
    }

    public StreamReceiverOptions readBufferSize(int readBufferSize) {
        this.readBufferSize = readBufferSize;
        return this;
    }

    public StreamReceiverOptions autoAccept(boolean autoAccept) {
        this.autoAccept = autoAccept;
        return this;
    }

    public boolean autoAccept() {
        return this.autoAccept;
    }

    public int creditWindow() {
        return this.creditWindow;
    }

    public StreamReceiverOptions creditWindow(int creditWindow) {
        this.creditWindow = creditWindow;
        return this;
    }

    public long drainTimeout() {
        return this.drainTimeout;
    }

    public StreamReceiverOptions drainTimeout(long drainTimeout) {
        return this.drainTimeout(drainTimeout, TimeUnit.MILLISECONDS);
    }

    public StreamReceiverOptions drainTimeout(long timeout, TimeUnit units) {
        this.drainTimeout = units.toMillis(timeout);
        return this;
    }

    @Override
    protected StreamReceiverOptions self() {
        return this;
    }
}

