/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.transport.network.security.ssl;

import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.net.ssl.X509TrustManager;

public class QpidMultipleTrustManager
implements X509TrustManager {
    private final List<X509TrustManager> _trustManagers = new ArrayList<X509TrustManager>();

    public boolean isEmpty() {
        return this._trustManagers.isEmpty();
    }

    public void addTrustManager(X509TrustManager trustManager) {
        this._trustManagers.add(trustManager);
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        for (X509TrustManager trustManager : this._trustManagers) {
            try {
                trustManager.checkClientTrusted(chain, authType);
                return;
            }
            catch (CertificateException certificateException) {
            }
        }
        throw new CertificateException();
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        for (X509TrustManager trustManager : this._trustManagers) {
            try {
                trustManager.checkServerTrusted(chain, authType);
                return;
            }
            catch (CertificateException certificateException) {
            }
        }
        throw new CertificateException();
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        ArrayList<X509Certificate> accIssuersCol = new ArrayList<X509Certificate>();
        for (X509TrustManager trustManager : this._trustManagers) {
            accIssuersCol.addAll(Arrays.asList(trustManager.getAcceptedIssuers()));
        }
        return accIssuersCol.toArray(new X509Certificate[accIssuersCol.size()]);
    }
}

