/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.mledger.impl;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.BoundType;
import com.google.common.collect.Maps;
import com.google.common.collect.Range;
import com.google.protobuf.InvalidProtocolBufferException;
import io.netty.util.concurrent.DefaultThreadFactory;
import io.opentelemetry.api.OpenTelemetry;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.bookkeeper.client.AsyncCallback;
import org.apache.bookkeeper.client.BKException;
import org.apache.bookkeeper.client.BookKeeper;
import org.apache.bookkeeper.client.BookKeeperAdmin;
import org.apache.bookkeeper.client.LedgerEntry;
import org.apache.bookkeeper.client.LedgerHandle;
import org.apache.bookkeeper.common.util.OrderedExecutor;
import org.apache.bookkeeper.common.util.OrderedScheduler;
import org.apache.bookkeeper.conf.ClientConfiguration;
import org.apache.bookkeeper.mledger.AsyncCallbacks;
import org.apache.bookkeeper.mledger.ManagedLedger;
import org.apache.bookkeeper.mledger.ManagedLedgerConfig;
import org.apache.bookkeeper.mledger.ManagedLedgerException;
import org.apache.bookkeeper.mledger.ManagedLedgerFactory;
import org.apache.bookkeeper.mledger.ManagedLedgerFactoryConfig;
import org.apache.bookkeeper.mledger.ManagedLedgerFactoryMXBean;
import org.apache.bookkeeper.mledger.ManagedLedgerInfo;
import org.apache.bookkeeper.mledger.MetadataCompressionConfig;
import org.apache.bookkeeper.mledger.OpenTelemetryManagedLedgerCacheStats;
import org.apache.bookkeeper.mledger.Position;
import org.apache.bookkeeper.mledger.PositionFactory;
import org.apache.bookkeeper.mledger.ReadOnlyCursor;
import org.apache.bookkeeper.mledger.ReadOnlyManagedLedger;
import org.apache.bookkeeper.mledger.ReadOnlyManagedLedgerImplWrapper;
import org.apache.bookkeeper.mledger.impl.ManagedCursorImpl;
import org.apache.bookkeeper.mledger.impl.ManagedLedgerFactoryMBeanImpl;
import org.apache.bookkeeper.mledger.impl.ManagedLedgerImpl;
import org.apache.bookkeeper.mledger.impl.MetaStore;
import org.apache.bookkeeper.mledger.impl.MetaStoreImpl;
import org.apache.bookkeeper.mledger.impl.OpenTelemetryManagedCursorStats;
import org.apache.bookkeeper.mledger.impl.OpenTelemetryManagedLedgerStats;
import org.apache.bookkeeper.mledger.impl.ShadowManagedLedgerImpl;
import org.apache.bookkeeper.mledger.impl.cache.EntryCacheManager;
import org.apache.bookkeeper.mledger.impl.cache.RangeEntryCacheManagerImpl;
import org.apache.bookkeeper.mledger.offload.OffloadUtils;
import org.apache.bookkeeper.mledger.proto.MLDataFormats;
import org.apache.bookkeeper.mledger.util.Errors;
import org.apache.bookkeeper.mledger.util.Futures;
import org.apache.bookkeeper.stats.NullStatsLogger;
import org.apache.bookkeeper.stats.StatsLogger;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.pulsar.common.naming.TopicName;
import org.apache.pulsar.common.policies.data.EnsemblePlacementPolicyConfig;
import org.apache.pulsar.common.policies.data.PersistentOfflineTopicStats;
import org.apache.pulsar.common.util.DateFormatter;
import org.apache.pulsar.common.util.FutureUtil;
import org.apache.pulsar.common.util.Runnables;
import org.apache.pulsar.metadata.api.MetadataStore;
import org.apache.pulsar.metadata.api.Stat;
import org.apache.pulsar.metadata.api.extended.MetadataStoreExtended;
import org.apache.pulsar.metadata.api.extended.SessionEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManagedLedgerFactoryImpl
implements ManagedLedgerFactory {
    private final MetaStore store;
    private final BookkeeperFactoryForCustomEnsemblePlacementPolicy bookkeeperFactory;
    private final boolean isBookkeeperManaged;
    private final ManagedLedgerFactoryConfig config;
    protected final OrderedScheduler scheduledExecutor;
    private final ScheduledExecutorService cacheEvictionExecutor;
    protected final ManagedLedgerFactoryMBeanImpl mbean;
    protected final ConcurrentHashMap<String, CompletableFuture<ManagedLedgerImpl>> ledgers = new ConcurrentHashMap();
    protected final ConcurrentHashMap<String, PendingInitializeManagedLedger> pendingInitializeLedgers = new ConcurrentHashMap();
    private final EntryCacheManager entryCacheManager;
    private long lastStatTimestamp = System.nanoTime();
    private final ScheduledFuture<?> statsTask;
    private final ScheduledFuture<?> flushCursorsTask;
    private volatile long cacheEvictionTimeThresholdNanos;
    private final MetadataStore metadataStore;
    private final OpenTelemetryManagedLedgerCacheStats openTelemetryCacheStats;
    private final OpenTelemetryManagedLedgerStats openTelemetryManagedLedgerStats;
    private final OpenTelemetryManagedCursorStats openTelemetryManagedCursorStats;
    private volatile boolean closed;
    private boolean metadataServiceAvailable;
    private final ManagedLedgerConfig defaultManagedLedgerConfig;
    private static final int META_READ_TIMEOUT_SECONDS = 60;
    private static final Logger log = LoggerFactory.getLogger(ManagedLedgerFactoryImpl.class);

    public ManagedLedgerFactoryImpl(MetadataStoreExtended metadataStore, ClientConfiguration bkClientConfiguration) throws Exception {
        this(metadataStore, bkClientConfiguration, new ManagedLedgerFactoryConfig());
    }

    public ManagedLedgerFactoryImpl(MetadataStoreExtended metadataStore, ClientConfiguration bkClientConfiguration, ManagedLedgerFactoryConfig config) throws Exception {
        this(metadataStore, new DefaultBkFactory(bkClientConfiguration), true, config, (StatsLogger)NullStatsLogger.INSTANCE, OpenTelemetry.noop(), new ManagedLedgerConfig());
    }

    public ManagedLedgerFactoryImpl(MetadataStoreExtended metadataStore, BookKeeper bookKeeper) throws Exception {
        this(metadataStore, bookKeeper, new ManagedLedgerFactoryConfig());
    }

    public ManagedLedgerFactoryImpl(MetadataStoreExtended metadataStore, BookKeeper bookKeeper, ManagedLedgerFactoryConfig config) throws Exception {
        this(metadataStore, bookKeeper, config, new ManagedLedgerConfig());
    }

    public ManagedLedgerFactoryImpl(MetadataStoreExtended metadataStore, BookKeeper bookKeeper, ManagedLedgerFactoryConfig config, ManagedLedgerConfig defaultManagedLedgerConfig) throws Exception {
        this(metadataStore, policyConfig -> CompletableFuture.completedFuture(bookKeeper), false, config, (StatsLogger)NullStatsLogger.INSTANCE, OpenTelemetry.noop(), defaultManagedLedgerConfig);
    }

    public ManagedLedgerFactoryImpl(MetadataStoreExtended metadataStore, BookkeeperFactoryForCustomEnsemblePlacementPolicy bookKeeperGroupFactory, ManagedLedgerFactoryConfig config) throws Exception {
        this(metadataStore, bookKeeperGroupFactory, false, config, (StatsLogger)NullStatsLogger.INSTANCE, OpenTelemetry.noop(), new ManagedLedgerConfig());
    }

    public ManagedLedgerFactoryImpl(MetadataStoreExtended metadataStore, BookkeeperFactoryForCustomEnsemblePlacementPolicy bookKeeperGroupFactory, ManagedLedgerFactoryConfig config, StatsLogger statsLogger, OpenTelemetry openTelemetry) throws Exception {
        this(metadataStore, bookKeeperGroupFactory, false, config, statsLogger, openTelemetry, new ManagedLedgerConfig());
    }

    private ManagedLedgerFactoryImpl(MetadataStoreExtended metadataStore, BookkeeperFactoryForCustomEnsemblePlacementPolicy bookKeeperGroupFactory, boolean isBookkeeperManaged, ManagedLedgerFactoryConfig config, StatsLogger statsLogger, OpenTelemetry openTelemetry, ManagedLedgerConfig defaultManagedLedgerConfig) throws Exception {
        this.defaultManagedLedgerConfig = defaultManagedLedgerConfig;
        MetadataCompressionConfig compressionConfigForManagedLedgerInfo = config.getCompressionConfigForManagedLedgerInfo();
        MetadataCompressionConfig compressionConfigForManagedCursorInfo = config.getCompressionConfigForManagedCursorInfo();
        this.scheduledExecutor = (OrderedScheduler)OrderedScheduler.newSchedulerBuilder().numThreads(config.getNumManagedLedgerSchedulerThreads()).statsLogger(statsLogger).traceTaskExecution(config.isTraceTaskExecution()).name("bookkeeper-ml-scheduler").build();
        this.cacheEvictionExecutor = Executors.newSingleThreadScheduledExecutor((ThreadFactory)new DefaultThreadFactory("bookkeeper-ml-cache-eviction"));
        this.metadataServiceAvailable = true;
        this.bookkeeperFactory = bookKeeperGroupFactory;
        this.isBookkeeperManaged = isBookkeeperManaged;
        this.metadataStore = metadataStore;
        this.store = new MetaStoreImpl((MetadataStore)metadataStore, (OrderedExecutor)this.scheduledExecutor, compressionConfigForManagedLedgerInfo, compressionConfigForManagedCursorInfo);
        this.config = config;
        this.mbean = new ManagedLedgerFactoryMBeanImpl(this);
        this.entryCacheManager = new RangeEntryCacheManagerImpl(this, this.scheduledExecutor, openTelemetry);
        this.statsTask = this.scheduledExecutor.scheduleWithFixedDelay(Runnables.catchingAndLoggingThrowables(this::refreshStats), 0L, (long)config.getStatsPeriodSeconds(), TimeUnit.SECONDS);
        this.flushCursorsTask = this.scheduledExecutor.scheduleAtFixedRate(Runnables.catchingAndLoggingThrowables(this::flushCursors), (long)config.getCursorPositionFlushSeconds(), (long)config.getCursorPositionFlushSeconds(), TimeUnit.SECONDS);
        this.cacheEvictionTimeThresholdNanos = TimeUnit.MILLISECONDS.toNanos(config.getCacheEvictionTimeThresholdMillis());
        long evictionTaskInterval = config.getCacheEvictionIntervalMs();
        this.cacheEvictionExecutor.scheduleWithFixedDelay(Runnables.catchingAndLoggingThrowables(this::doCacheEviction), evictionTaskInterval, evictionTaskInterval, TimeUnit.MILLISECONDS);
        this.closed = false;
        metadataStore.registerSessionListener(this::handleMetadataStoreNotification);
        this.openTelemetryCacheStats = new OpenTelemetryManagedLedgerCacheStats(openTelemetry, this);
        this.openTelemetryManagedLedgerStats = new OpenTelemetryManagedLedgerStats(openTelemetry, this);
        this.openTelemetryManagedCursorStats = new OpenTelemetryManagedCursorStats(openTelemetry, this);
    }

    private synchronized void handleMetadataStoreNotification(SessionEvent e) {
        log.info("Received MetadataStore session event: {}", (Object)e);
        this.metadataServiceAvailable = e.isConnected();
    }

    private synchronized void flushCursors() {
        this.ledgers.values().forEach(mlfuture -> {
            ManagedLedgerImpl ml;
            if (mlfuture.isDone() && !mlfuture.isCompletedExceptionally() && (ml = (ManagedLedgerImpl)mlfuture.getNow(null)) != null) {
                ml.getCursors().forEach(c -> ((ManagedCursorImpl)c).flush());
            }
        });
    }

    private synchronized void refreshStats() {
        long now = System.nanoTime();
        long period = now - this.lastStatTimestamp;
        this.mbean.refreshStats(period, TimeUnit.NANOSECONDS);
        this.ledgers.values().forEach(mlfuture -> {
            ManagedLedgerImpl ml;
            if (mlfuture.isDone() && !mlfuture.isCompletedExceptionally() && (ml = (ManagedLedgerImpl)mlfuture.getNow(null)) != null) {
                ml.mbean.refreshStats(period, TimeUnit.NANOSECONDS);
            }
        });
        this.lastStatTimestamp = now;
    }

    @VisibleForTesting
    public synchronized void doCacheEviction() {
        this.entryCacheManager.doCacheEviction();
    }

    @VisibleForTesting
    public void waitForPendingCacheEvictions() {
        try {
            this.cacheEvictionExecutor.submit(() -> {}).get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    @VisibleForTesting
    public Runnable blockPendingCacheEvictions() throws InterruptedException {
        CountDownLatch blockedLatch = new CountDownLatch(1);
        CountDownLatch releaseLatch = new CountDownLatch(1);
        this.cacheEvictionExecutor.execute(() -> {
            blockedLatch.countDown();
            try {
                releaseLatch.await();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        });
        blockedLatch.await();
        return () -> {
            if (releaseLatch.getCount() == 0L) {
                throw new IllegalStateException("Releasing should only be called once");
            }
            releaseLatch.countDown();
            this.waitForPendingCacheEvictions();
        };
    }

    @Override
    public Map<String, ManagedLedger> getManagedLedgers() {
        return Maps.filterValues((Map)Maps.transformValues(this.ledgers, future -> future.getNow(null)), (Predicate)Predicates.notNull());
    }

    @Override
    public ManagedLedger open(String name) throws InterruptedException, ManagedLedgerException {
        return this.open(name, this.defaultManagedLedgerConfig);
    }

    @Override
    public ManagedLedger open(String name, ManagedLedgerConfig config) throws InterruptedException, ManagedLedgerException {
        class Result {
            ManagedLedger l = null;
            ManagedLedgerException e = null;

            Result() {
            }
        }
        final Result r = new Result();
        final CountDownLatch latch = new CountDownLatch(1);
        this.asyncOpen(name, config, new AsyncCallbacks.OpenLedgerCallback(){
            {
            }

            @Override
            public void openLedgerComplete(ManagedLedger ledger, Object ctx) {
                r.l = ledger;
                latch.countDown();
            }

            @Override
            public void openLedgerFailed(ManagedLedgerException exception, Object ctx) {
                r.e = exception;
                latch.countDown();
            }
        }, null, null);
        latch.await();
        if (r.e != null) {
            throw r.e;
        }
        return r.l;
    }

    @Override
    public void asyncOpen(String name, AsyncCallbacks.OpenLedgerCallback callback, Object ctx) {
        this.asyncOpen(name, this.defaultManagedLedgerConfig, callback, null, ctx);
    }

    @Override
    public void asyncOpen(String name, ManagedLedgerConfig config, AsyncCallbacks.OpenLedgerCallback callback, Supplier<CompletableFuture<Boolean>> mlOwnershipChecker, Object ctx) {
        if (this.closed) {
            callback.openLedgerFailed(new ManagedLedgerException.ManagedLedgerFactoryClosedException(), ctx);
            return;
        }
        CompletableFuture<ManagedLedgerImpl> existingFuture = this.ledgers.get(name);
        if (existingFuture != null) {
            if (existingFuture.isDone()) {
                try {
                    ManagedLedgerImpl l = existingFuture.get();
                    if (l.getState().isFenced() || l.getState() == ManagedLedgerImpl.State.Closed) {
                        log.warn("[{}] Attempted to open ledger in {} state. Removing from the map to recreate it", (Object)name, (Object)l.getState());
                        this.ledgers.remove(name, existingFuture);
                    }
                }
                catch (Exception e) {
                    log.warn("[{}] Got exception while trying to retrieve ledger", (Object)name, (Object)e);
                }
            } else {
                long pendingMs;
                PendingInitializeManagedLedger pendingLedger = this.pendingInitializeLedgers.get(name);
                if (null != pendingLedger && (pendingMs = System.currentTimeMillis() - pendingLedger.createTimeMs) > TimeUnit.SECONDS.toMillis(config.getMetadataOperationsTimeoutSeconds())) {
                    log.warn("[{}] Managed ledger has been pending in initialize state more than {} milliseconds, remove it from cache to retry ...", (Object)name, (Object)pendingMs);
                    this.ledgers.remove(name, existingFuture);
                    this.pendingInitializeLedgers.remove(name, pendingLedger);
                }
            }
        }
        ((CompletableFuture)this.ledgers.computeIfAbsent(name, mlName -> {
            CompletableFuture future = new CompletableFuture();
            ((CompletableFuture)this.bookkeeperFactory.get(new EnsemblePlacementPolicyConfig(config.getBookKeeperEnsemblePlacementPolicyClassName(), config.getBookKeeperEnsemblePlacementPolicyProperties())).thenAccept(arg_0 -> this.lambda$asyncOpen$8(name, config, (Supplier)mlOwnershipChecker, future, arg_0))).exceptionally(ex -> {
                future.completeExceptionally((Throwable)ex);
                return null;
            });
            return future;
        }).thenAccept(ml -> callback.openLedgerComplete((ManagedLedger)ml, ctx))).exceptionally(exception -> {
            callback.openLedgerFailed(ManagedLedgerException.getManagedLedgerException(FutureUtil.unwrapCompletionException((Throwable)exception)), ctx);
            return null;
        });
    }

    protected ManagedLedgerImpl createManagedLedger(BookKeeper bk, MetaStore store, String name, ManagedLedgerConfig config, Supplier<CompletableFuture<Boolean>> mlOwnershipChecker) {
        return config.getShadowSource() == null ? new ManagedLedgerImpl(this, bk, store, config, this.scheduledExecutor, name, mlOwnershipChecker) : new ShadowManagedLedgerImpl(this, bk, store, config, this.scheduledExecutor, name, mlOwnershipChecker);
    }

    @Override
    public void asyncOpenReadOnlyManagedLedger(String managedLedgerName, AsyncCallbacks.OpenReadOnlyManagedLedgerCallback callback, ManagedLedgerConfig config, Object ctx) {
        if (this.closed) {
            callback.openReadOnlyManagedLedgerFailed(new ManagedLedgerException.ManagedLedgerFactoryClosedException(), ctx);
        }
        ((CompletableFuture)((CompletableFuture)this.bookkeeperFactory.get(new EnsemblePlacementPolicyConfig(config.getBookKeeperEnsemblePlacementPolicyClassName(), config.getBookKeeperEnsemblePlacementPolicyProperties())).thenCompose(bk -> {
            ReadOnlyManagedLedgerImplWrapper roManagedLedger = new ReadOnlyManagedLedgerImplWrapper(this, (BookKeeper)bk, this.store, config, this.scheduledExecutor, managedLedgerName);
            return roManagedLedger.initialize().thenApply(v -> roManagedLedger);
        })).thenAccept(roManagedLedger -> {
            log.info("[{}] Successfully initialize Read-only managed ledger", (Object)managedLedgerName);
            callback.openReadOnlyManagedLedgerComplete((ReadOnlyManagedLedger)roManagedLedger, ctx);
        })).exceptionally(e -> {
            log.error("[{}] Failed to initialize Read-only managed ledger", (Object)managedLedgerName, e);
            callback.openReadOnlyManagedLedgerFailed(ManagedLedgerException.getManagedLedgerException(FutureUtil.unwrapCompletionException((Throwable)e)), ctx);
            return null;
        });
    }

    @Override
    public ReadOnlyCursor openReadOnlyCursor(String managedLedgerName, Position startPosition, ManagedLedgerConfig config) throws InterruptedException, ManagedLedgerException {
        class Result {
            ReadOnlyCursor c = null;
            ManagedLedgerException e = null;

            Result() {
            }
        }
        final Result r = new Result();
        final CountDownLatch latch = new CountDownLatch(1);
        this.asyncOpenReadOnlyCursor(managedLedgerName, startPosition, config, new AsyncCallbacks.OpenReadOnlyCursorCallback(){
            {
            }

            @Override
            public void openReadOnlyCursorComplete(ReadOnlyCursor cursor, Object ctx) {
                r.c = cursor;
                latch.countDown();
            }

            @Override
            public void openReadOnlyCursorFailed(ManagedLedgerException exception, Object ctx) {
                r.e = exception;
                latch.countDown();
            }
        }, null);
        latch.await();
        if (r.e != null) {
            throw r.e;
        }
        return r.c;
    }

    @Override
    public void asyncOpenReadOnlyCursor(String managedLedgerName, final Position startPosition, ManagedLedgerConfig config, final AsyncCallbacks.OpenReadOnlyCursorCallback callback, Object ctx) {
        if (this.closed) {
            callback.openReadOnlyCursorFailed(new ManagedLedgerException.ManagedLedgerFactoryClosedException(), ctx);
            return;
        }
        AsyncCallbacks.OpenReadOnlyManagedLedgerCallback openReadOnlyManagedLedgerCallback = new AsyncCallbacks.OpenReadOnlyManagedLedgerCallback(){

            @Override
            public void openReadOnlyManagedLedgerComplete(ReadOnlyManagedLedger readOnlyManagedLedger, Object ctx) {
                callback.openReadOnlyCursorComplete(readOnlyManagedLedger.createReadOnlyCursor(startPosition), ctx);
            }

            @Override
            public void openReadOnlyManagedLedgerFailed(ManagedLedgerException exception, Object ctx) {
                callback.openReadOnlyCursorFailed(exception, ctx);
            }
        };
        this.asyncOpenReadOnlyManagedLedger(managedLedgerName, openReadOnlyManagedLedgerCallback, config, null);
    }

    void close(ManagedLedger ledger) {
        CompletableFuture<ManagedLedgerImpl> ledgerFuture = this.ledgers.get(ledger.getName());
        if (ledgerFuture == null || !ledgerFuture.isDone() || ledgerFuture.isCompletedExceptionally()) {
            return;
        }
        if (ledgerFuture.join() != ledger) {
            return;
        }
        if (this.ledgers.remove(ledger.getName(), ledgerFuture)) {
            this.entryCacheManager.removeEntryCache(ledger.getName());
        }
    }

    @Override
    public CompletableFuture<Void> shutdownAsync() throws ManagedLedgerException {
        if (this.closed) {
            throw new ManagedLedgerException.ManagedLedgerFactoryClosedException();
        }
        this.closed = true;
        this.statsTask.cancel(true);
        this.flushCursorsTask.cancel(true);
        this.cacheEvictionExecutor.shutdownNow();
        ArrayList ledgerNames = new ArrayList(this.ledgers.keySet());
        ArrayList futures = new ArrayList(ledgerNames.size());
        int numLedgers = ledgerNames.size();
        log.info("Closing {} ledgers", (Object)numLedgers);
        for (String ledgerName : ledgerNames) {
            CompletableFuture<ManagedLedgerImpl> ledgerFuture = this.ledgers.remove(ledgerName);
            if (ledgerFuture == null) continue;
            final CompletableFuture future = new CompletableFuture();
            futures.add(future);
            ledgerFuture.whenCompleteAsync((managedLedger, throwable) -> {
                if (throwable != null || managedLedger == null) {
                    future.complete(null);
                    return;
                }
                managedLedger.asyncClose(new AsyncCallbacks.CloseCallback(){
                    final /* synthetic */ ManagedLedgerImpl val$managedLedger;
                    {
                        this.val$managedLedger = managedLedgerImpl;
                    }

                    @Override
                    public void closeComplete(Object ctx) {
                        future.complete(null);
                    }

                    @Override
                    public void closeFailed(ManagedLedgerException exception, Object ctx) {
                        log.warn("[{}] Got exception when closing managed ledger: {}", (Object)this.val$managedLedger.getName(), (Object)exception);
                        future.complete(null);
                    }
                }, null);
            }, (Executor)this.scheduledExecutor.chooseThread());
            PendingInitializeManagedLedger pendingLedger = this.pendingInitializeLedgers.get(ledgerName);
            if (pendingLedger == null || ledgerFuture.isDone()) continue;
            ledgerFuture.completeExceptionally(new ManagedLedgerException.ManagedLedgerFactoryClosedException());
        }
        CompletableFuture<Object> bookkeeperFuture = this.isBookkeeperManaged ? this.bookkeeperFactory.get() : CompletableFuture.completedFuture(null);
        return ((CompletableFuture)bookkeeperFuture.thenRun(() -> {
            log.info("Closing {} ledgers.", (Object)this.ledgers.size());
            this.ledgers.forEach((ledgerName, ledgerFuture) -> {
                if (!ledgerFuture.isDone()) {
                    ledgerFuture.completeExceptionally(new ManagedLedgerException.ManagedLedgerFactoryClosedException());
                } else {
                    ManagedLedgerImpl managedLedger = ledgerFuture.getNow(null);
                    if (managedLedger == null) {
                        return;
                    }
                    try {
                        managedLedger.close();
                    }
                    catch (Throwable throwable) {
                        log.warn("[{}] Got exception when closing managed ledger: {}", (Object)managedLedger.getName(), (Object)throwable);
                    }
                }
            });
        })).whenCompleteAsync((__, ___) -> {
            this.openTelemetryManagedCursorStats.close();
            this.openTelemetryManagedLedgerStats.close();
            this.openTelemetryCacheStats.close();
            this.scheduledExecutor.shutdownNow();
            this.entryCacheManager.clear();
            BookkeeperFactoryForCustomEnsemblePlacementPolicy patt0$temp = this.bookkeeperFactory;
            if (patt0$temp instanceof DefaultBkFactory) {
                DefaultBkFactory defaultBkFactory = (DefaultBkFactory)patt0$temp;
                try {
                    defaultBkFactory.close();
                }
                catch (Exception e) {
                    log.warn("Failed to close bookkeeper client", (Throwable)e);
                }
            }
        });
    }

    @Override
    public void shutdown() throws InterruptedException, ManagedLedgerException {
        try {
            this.shutdownAsync().get();
        }
        catch (ExecutionException e) {
            throw ManagedLedgerException.getManagedLedgerException(e.getCause());
        }
    }

    @Override
    public CompletableFuture<Boolean> asyncExists(String ledgerName) {
        return this.store.asyncExists(ledgerName);
    }

    @Override
    public ManagedLedgerInfo getManagedLedgerInfo(String name) throws InterruptedException, ManagedLedgerException {
        class Result {
            ManagedLedgerInfo info = null;
            ManagedLedgerException e = null;

            Result() {
            }
        }
        final Result r = new Result();
        final CountDownLatch latch = new CountDownLatch(1);
        this.asyncGetManagedLedgerInfo(name, new AsyncCallbacks.ManagedLedgerInfoCallback(){
            {
            }

            @Override
            public void getInfoComplete(ManagedLedgerInfo info, Object ctx) {
                r.info = info;
                latch.countDown();
            }

            @Override
            public void getInfoFailed(ManagedLedgerException exception, Object ctx) {
                r.e = exception;
                latch.countDown();
            }
        }, null);
        latch.await();
        if (r.e != null) {
            throw r.e;
        }
        return r.info;
    }

    @Override
    public void asyncGetManagedLedgerInfo(final String name, final AsyncCallbacks.ManagedLedgerInfoCallback callback, final Object ctx) {
        this.store.getManagedLedgerInfo(name, false, new MetaStore.MetaStoreCallback<MLDataFormats.ManagedLedgerInfo>(){

            @Override
            public void operationComplete(MLDataFormats.ManagedLedgerInfo pbInfo, Stat stat) {
                int i;
                final ManagedLedgerInfo info = new ManagedLedgerInfo();
                info.version = stat.getVersion();
                info.creationDate = DateFormatter.format((long)stat.getCreationTimestamp());
                info.modificationDate = DateFormatter.format((long)stat.getModificationTimestamp());
                info.ledgers = new ArrayList<ManagedLedgerInfo.LedgerInfo>(pbInfo.getLedgerInfoCount());
                if (pbInfo.hasTerminatedPosition()) {
                    info.terminatedPosition = new ManagedLedgerInfo.PositionInfo();
                    info.terminatedPosition.ledgerId = pbInfo.getTerminatedPosition().getLedgerId();
                    info.terminatedPosition.entryId = pbInfo.getTerminatedPosition().getEntryId();
                }
                if (pbInfo.getPropertiesCount() > 0) {
                    info.properties = new TreeMap<String, String>();
                    for (i = 0; i < pbInfo.getPropertiesCount(); ++i) {
                        MLDataFormats.KeyValue property = pbInfo.getProperties(i);
                        info.properties.put(property.getKey(), property.getValue());
                    }
                }
                for (i = 0; i < pbInfo.getLedgerInfoCount(); ++i) {
                    MLDataFormats.ManagedLedgerInfo.LedgerInfo pbLedgerInfo = pbInfo.getLedgerInfo(i);
                    ManagedLedgerInfo.LedgerInfo ledgerInfo = new ManagedLedgerInfo.LedgerInfo();
                    ledgerInfo.ledgerId = pbLedgerInfo.getLedgerId();
                    ledgerInfo.entries = pbLedgerInfo.hasEntries() ? Long.valueOf(pbLedgerInfo.getEntries()) : null;
                    ledgerInfo.size = pbLedgerInfo.hasSize() ? Long.valueOf(pbLedgerInfo.getSize()) : null;
                    ledgerInfo.timestamp = pbLedgerInfo.hasTimestamp() ? Long.valueOf(pbLedgerInfo.getTimestamp()) : null;
                    ledgerInfo.isOffloaded = pbLedgerInfo.hasOffloadContext();
                    if (pbLedgerInfo.hasOffloadContext()) {
                        MLDataFormats.OffloadContext offloadContext = pbLedgerInfo.getOffloadContext();
                        UUID uuid = new UUID(offloadContext.getUidMsb(), offloadContext.getUidLsb());
                        ledgerInfo.offloadedContextUuid = uuid.toString();
                    }
                    info.ledgers.add(ledgerInfo);
                }
                ManagedLedgerFactoryImpl.this.store.getCursors(name, new MetaStore.MetaStoreCallback<List<String>>(){

                    @Override
                    public void operationComplete(List<String> cursorsList, Stat stat) {
                        info.cursors = new ConcurrentSkipListMap<String, ManagedLedgerInfo.CursorInfo>();
                        ArrayList<CompletableFuture<Void>> cursorsFutures = new ArrayList<CompletableFuture<Void>>();
                        for (final String cursorName : cursorsList) {
                            final CompletableFuture cursorFuture = new CompletableFuture();
                            cursorsFutures.add(cursorFuture);
                            ManagedLedgerFactoryImpl.this.store.asyncGetCursorInfo(name, cursorName, new MetaStore.MetaStoreCallback<MLDataFormats.ManagedCursorInfo>(){

                                @Override
                                public void operationComplete(MLDataFormats.ManagedCursorInfo pbCursorInfo, Stat stat) {
                                    int i;
                                    ManagedLedgerInfo.CursorInfo cursorInfo = new ManagedLedgerInfo.CursorInfo();
                                    cursorInfo.version = stat.getVersion();
                                    cursorInfo.creationDate = DateFormatter.format((long)stat.getCreationTimestamp());
                                    cursorInfo.modificationDate = DateFormatter.format((long)stat.getModificationTimestamp());
                                    cursorInfo.cursorsLedgerId = pbCursorInfo.getCursorsLedgerId();
                                    if (pbCursorInfo.hasMarkDeleteLedgerId()) {
                                        cursorInfo.markDelete = new ManagedLedgerInfo.PositionInfo();
                                        cursorInfo.markDelete.ledgerId = pbCursorInfo.getMarkDeleteLedgerId();
                                        cursorInfo.markDelete.entryId = pbCursorInfo.getMarkDeleteEntryId();
                                    }
                                    if (pbCursorInfo.getPropertiesCount() > 0) {
                                        cursorInfo.properties = new TreeMap<String, Long>();
                                        for (i = 0; i < pbCursorInfo.getPropertiesCount(); ++i) {
                                            MLDataFormats.LongProperty property = pbCursorInfo.getProperties(i);
                                            cursorInfo.properties.put(property.getName(), property.getValue());
                                        }
                                    }
                                    if (pbCursorInfo.getIndividualDeletedMessagesCount() > 0) {
                                        cursorInfo.individualDeletedMessages = new ArrayList<ManagedLedgerInfo.MessageRangeInfo>();
                                        for (i = 0; i < pbCursorInfo.getIndividualDeletedMessagesCount(); ++i) {
                                            MLDataFormats.MessageRange range = pbCursorInfo.getIndividualDeletedMessages(i);
                                            ManagedLedgerInfo.MessageRangeInfo rangeInfo = new ManagedLedgerInfo.MessageRangeInfo();
                                            rangeInfo.from.ledgerId = range.getLowerEndpoint().getLedgerId();
                                            rangeInfo.from.entryId = range.getLowerEndpoint().getEntryId();
                                            rangeInfo.to.ledgerId = range.getUpperEndpoint().getLedgerId();
                                            rangeInfo.to.entryId = range.getUpperEndpoint().getEntryId();
                                            cursorInfo.individualDeletedMessages.add(rangeInfo);
                                        }
                                    }
                                    info.cursors.put(cursorName, cursorInfo);
                                    cursorFuture.complete(null);
                                }

                                @Override
                                public void operationFailed(ManagedLedgerException.MetaStoreException e) {
                                    cursorFuture.completeExceptionally(e);
                                }
                            });
                        }
                        ((CompletableFuture)Futures.waitForAll(cursorsFutures).thenRun(() -> callback.getInfoComplete(info, ctx))).exceptionally(ex -> {
                            callback.getInfoFailed(ManagedLedgerException.getManagedLedgerException(ex.getCause()), ctx);
                            return null;
                        });
                    }

                    @Override
                    public void operationFailed(ManagedLedgerException.MetaStoreException e) {
                        callback.getInfoFailed(e, ctx);
                    }
                });
            }

            @Override
            public void operationFailed(ManagedLedgerException.MetaStoreException e) {
                callback.getInfoFailed(e, ctx);
            }
        });
    }

    @Override
    public void delete(String name) throws InterruptedException, ManagedLedgerException {
        this.delete(name, CompletableFuture.completedFuture(null));
    }

    @Override
    public void delete(String name, CompletableFuture<ManagedLedgerConfig> mlConfigFuture) throws InterruptedException, ManagedLedgerException {
        class Result {
            ManagedLedgerException e = null;

            Result() {
            }
        }
        final Result r = new Result();
        final CountDownLatch latch = new CountDownLatch(1);
        this.asyncDelete(name, mlConfigFuture, new AsyncCallbacks.DeleteLedgerCallback(){
            {
            }

            @Override
            public void deleteLedgerComplete(Object ctx) {
                latch.countDown();
            }

            @Override
            public void deleteLedgerFailed(ManagedLedgerException exception, Object ctx) {
                r.e = exception;
                latch.countDown();
            }
        }, null);
        latch.await();
        if (r.e != null) {
            throw r.e;
        }
    }

    @Override
    public void asyncDelete(String name, AsyncCallbacks.DeleteLedgerCallback callback, Object ctx) {
        this.asyncDelete(name, CompletableFuture.completedFuture(null), callback, ctx);
    }

    @Override
    public void asyncDelete(String name, CompletableFuture<ManagedLedgerConfig> mlConfigFuture, AsyncCallbacks.DeleteLedgerCallback callback, Object ctx) {
        CompletableFuture<ManagedLedgerImpl> future = this.ledgers.get(name);
        if (future == null) {
            this.deleteManagedLedger(name, mlConfigFuture, callback, ctx);
        } else {
            ((CompletableFuture)future.thenAccept(ml -> ml.asyncDelete(callback, ctx))).exceptionally(ex -> {
                Throwable rc = FutureUtil.unwrapCompletionException((Throwable)ex);
                callback.deleteLedgerFailed(ManagedLedgerException.getManagedLedgerException(rc), ctx);
                return null;
            });
        }
    }

    void deleteManagedLedger(final String managedLedgerName, final CompletableFuture<ManagedLedgerConfig> mlConfigFuture, final AsyncCallbacks.DeleteLedgerCallback callback, Object ctx) {
        this.asyncGetManagedLedgerInfo(managedLedgerName, new AsyncCallbacks.ManagedLedgerInfoCallback(){

            @Override
            public void getInfoComplete(ManagedLedgerInfo info, Object ctx) {
                ((CompletableFuture)((CompletableFuture)ManagedLedgerFactoryImpl.this.getBookKeeper().thenCompose(bk -> {
                    List<CompletableFuture<Void>> futures = info.cursors.entrySet().stream().map(e -> ManagedLedgerFactoryImpl.this.deleteCursor((BookKeeper)bk, managedLedgerName, (String)e.getKey(), (ManagedLedgerInfo.CursorInfo)e.getValue())).collect(Collectors.toList());
                    return Futures.waitForAll(futures).thenApply(v -> bk);
                })).thenAccept(bk -> ManagedLedgerFactoryImpl.this.deleteManagedLedgerData((BookKeeper)bk, managedLedgerName, info, mlConfigFuture, callback, ctx))).exceptionally(ex -> {
                    callback.deleteLedgerFailed(new ManagedLedgerException((Throwable)ex), ctx);
                    return null;
                });
            }

            @Override
            public void getInfoFailed(ManagedLedgerException exception, Object ctx) {
                callback.deleteLedgerFailed(exception, ctx);
            }
        }, ctx);
    }

    private void deleteManagedLedgerData(BookKeeper bkc, final String managedLedgerName, ManagedLedgerInfo info, CompletableFuture<ManagedLedgerConfig> mlConfigFuture, final AsyncCallbacks.DeleteLedgerCallback callback, final Object ctx) {
        final CompletableFuture ledgerInfosFuture = new CompletableFuture();
        this.store.getManagedLedgerInfo(managedLedgerName, false, null, new MetaStore.MetaStoreCallback<MLDataFormats.ManagedLedgerInfo>(){

            @Override
            public void operationComplete(MLDataFormats.ManagedLedgerInfo mlInfo, Stat stat) {
                HashMap<Long, MLDataFormats.ManagedLedgerInfo.LedgerInfo> infos = new HashMap<Long, MLDataFormats.ManagedLedgerInfo.LedgerInfo>();
                for (MLDataFormats.ManagedLedgerInfo.LedgerInfo ls : mlInfo.getLedgerInfoList()) {
                    infos.put(ls.getLedgerId(), ls);
                }
                ledgerInfosFuture.complete(infos);
            }

            @Override
            public void operationFailed(ManagedLedgerException.MetaStoreException e) {
                log.error("Failed to get managed ledger info for {}", (Object)managedLedgerName, (Object)e);
                ledgerInfosFuture.completeExceptionally(e);
            }
        });
        ((CompletableFuture)Futures.waitForAll(info.ledgers.stream().map(li -> {
            CompletionStage<Object> res = li.isOffloaded ? ((CompletableFuture)mlConfigFuture.thenCombine((CompletionStage)ledgerInfosFuture, Pair::of)).thenCompose(pair -> {
                ManagedLedgerConfig mlConfig = (ManagedLedgerConfig)pair.getLeft();
                Map ledgerInfos = (Map)pair.getRight();
                if (mlConfig == null || ledgerInfos == null) {
                    return CompletableFuture.completedFuture(null);
                }
                MLDataFormats.ManagedLedgerInfo.LedgerInfo ls = (MLDataFormats.ManagedLedgerInfo.LedgerInfo)ledgerInfos.get(li.ledgerId);
                if (ls.getOffloadContext().hasUidMsb()) {
                    MLDataFormats.ManagedLedgerInfo.LedgerInfo.Builder newInfoBuilder = ls.toBuilder();
                    newInfoBuilder.getOffloadContextBuilder().setBookkeeperDeleted(true);
                    String driverName = OffloadUtils.getOffloadDriverName(ls, mlConfig.getLedgerOffloader().getOffloadDriverName());
                    Map<String, String> driverMetadata = OffloadUtils.getOffloadDriverMetadata(ls, mlConfig.getLedgerOffloader().getOffloadDriverMetadata());
                    OffloadUtils.setOffloadDriverMetadata(newInfoBuilder, driverName, driverMetadata);
                    UUID uuid = new UUID(ls.getOffloadContext().getUidMsb(), ls.getOffloadContext().getUidLsb());
                    return OffloadUtils.cleanupOffloaded(li.ledgerId, uuid, mlConfig, OffloadUtils.getOffloadDriverMetadata(ls, mlConfig.getLedgerOffloader().getOffloadDriverMetadata()), "Deletion", managedLedgerName, this.scheduledExecutor);
                }
                return CompletableFuture.completedFuture(null);
            }) : CompletableFuture.completedFuture(null);
            return res.thenCompose(__ -> bkc.newDeleteLedgerOp().withLedgerId(li.ledgerId).execute().handle((result, ex) -> {
                if (ex != null) {
                    int rc = BKException.getExceptionCode((Throwable)ex);
                    if (rc == -25 || rc == -7) {
                        log.info("Ledger {} does not exist, ignoring", (Object)li.ledgerId);
                        return null;
                    }
                    throw new CompletionException((Throwable)ex);
                }
                return result;
            }));
        }).collect(Collectors.toList())).thenRun(() -> this.store.removeManagedLedger(managedLedgerName, new MetaStore.MetaStoreCallback<Void>(){

            @Override
            public void operationComplete(Void result, Stat stat) {
                callback.deleteLedgerComplete(ctx);
            }

            @Override
            public void operationFailed(ManagedLedgerException.MetaStoreException e) {
                callback.deleteLedgerFailed(new ManagedLedgerException(e), ctx);
            }
        }))).exceptionally(ex -> {
            callback.deleteLedgerFailed(new ManagedLedgerException((Throwable)ex), ctx);
            return null;
        });
    }

    private CompletableFuture<Void> deleteCursor(BookKeeper bkc, String managedLedgerName, String cursorName, ManagedLedgerInfo.CursorInfo cursor) {
        final CompletableFuture<Void> future = new CompletableFuture<Void>();
        CompletionStage<Object> cursorLedgerDeleteFuture = cursor.cursorsLedgerId != -1L ? bkc.newDeleteLedgerOp().withLedgerId(cursor.cursorsLedgerId).execute().handle((result, ex) -> {
            if (ex != null) {
                int rc = BKException.getExceptionCode((Throwable)ex);
                if (rc == -25 || rc == -7) {
                    log.info("Ledger {} does not exist, ignoring", (Object)cursor.cursorsLedgerId);
                    return null;
                }
                throw new CompletionException((Throwable)ex);
            }
            return result;
        }) : CompletableFuture.completedFuture(null);
        cursorLedgerDeleteFuture.thenRun(() -> this.store.asyncRemoveCursor(managedLedgerName, cursorName, new MetaStore.MetaStoreCallback<Void>(){

            @Override
            public void operationComplete(Void result, Stat stat) {
                future.complete(null);
            }

            @Override
            public void operationFailed(ManagedLedgerException.MetaStoreException e) {
                future.completeExceptionally(e);
            }
        }));
        return future;
    }

    @Override
    public CompletableFuture<Map<String, String>> getManagedLedgerPropertiesAsync(String name) {
        return this.store.getManagedLedgerPropertiesAsync(name);
    }

    public MetaStore getMetaStore() {
        return this.store;
    }

    @Override
    public ManagedLedgerFactoryConfig getConfig() {
        return this.config;
    }

    @Override
    public EntryCacheManager getEntryCacheManager() {
        return this.entryCacheManager;
    }

    @Override
    public void updateCacheEvictionTimeThreshold(long cacheEvictionTimeThresholdNanos) {
        this.cacheEvictionTimeThresholdNanos = cacheEvictionTimeThresholdNanos;
    }

    @Override
    public long getCacheEvictionTimeThreshold() {
        return this.cacheEvictionTimeThresholdNanos;
    }

    @Override
    public void updateCacheEvictionExtendTTLOfEntriesWithRemainingExpectedReadsMaxTimes(int extendTTLOfEntriesWithRemainingExpectedReadsMaxTimes) {
        this.entryCacheManager.updateCacheEvictionExtendTTLOfEntriesWithRemainingExpectedReadsMaxTimes(extendTTLOfEntriesWithRemainingExpectedReadsMaxTimes);
    }

    @Override
    public void updateCacheEvictionExtendTTLOfRecentlyAccessed(boolean cacheEvictionExtendTTLOfRecentlyAccessed) {
        this.entryCacheManager.updateCacheEvictionExtendTTLOfRecentlyAccessed(cacheEvictionExtendTTLOfRecentlyAccessed);
    }

    @Override
    public ManagedLedgerFactoryMXBean getCacheStats() {
        return this.mbean;
    }

    public CompletableFuture<BookKeeper> getBookKeeper() {
        return this.bookkeeperFactory.get();
    }

    @Override
    public void estimateUnloadedTopicBacklog(PersistentOfflineTopicStats offlineTopicStats, TopicName topicName, boolean accurate, Object ctx) throws Exception {
        String managedLedgerName = topicName.getPersistenceNamingEncoding();
        long numberOfEntries = 0L;
        long totalSize = 0L;
        BookKeeper.DigestType digestType = (BookKeeper.DigestType)((List)ctx).get(0);
        byte[] password = (byte[])((List)ctx).get(1);
        NavigableMap<Long, MLDataFormats.ManagedLedgerInfo.LedgerInfo> ledgers = this.getManagedLedgersInfo(topicName, accurate, digestType, password);
        for (MLDataFormats.ManagedLedgerInfo.LedgerInfo ls : ledgers.values()) {
            numberOfEntries += ls.getEntries();
            totalSize += ls.getSize();
            if (!accurate) continue;
            offlineTopicStats.addLedgerDetails(ls.getEntries(), ls.getTimestamp(), ls.getSize(), ls.getLedgerId());
        }
        offlineTopicStats.totalMessages = numberOfEntries;
        offlineTopicStats.storageSize = totalSize;
        if (log.isDebugEnabled()) {
            log.debug("[{}] Total number of entries - {} and size - {}", new Object[]{managedLedgerName, numberOfEntries, totalSize});
        }
        this.calculateCursorBacklogs(topicName, ledgers, offlineTopicStats, accurate, digestType, password);
        offlineTopicStats.statGeneratedAt.setTime(System.currentTimeMillis());
    }

    private NavigableMap<Long, MLDataFormats.ManagedLedgerInfo.LedgerInfo> getManagedLedgersInfo(TopicName topicName, boolean accurate, final BookKeeper.DigestType digestType, final byte[] password) throws Exception {
        final ConcurrentSkipListMap<Long, MLDataFormats.ManagedLedgerInfo.LedgerInfo> ledgers = new ConcurrentSkipListMap<Long, MLDataFormats.ManagedLedgerInfo.LedgerInfo>();
        final String managedLedgerName = topicName.getPersistenceNamingEncoding();
        MetaStore store = this.getMetaStore();
        final CountDownLatch mlMetaCounter = new CountDownLatch(1);
        store.getManagedLedgerInfo(managedLedgerName, false, new MetaStore.MetaStoreCallback<MLDataFormats.ManagedLedgerInfo>(){

            @Override
            public void operationComplete(MLDataFormats.ManagedLedgerInfo mlInfo, Stat stat) {
                for (MLDataFormats.ManagedLedgerInfo.LedgerInfo ls : mlInfo.getLedgerInfoList()) {
                    ledgers.put(ls.getLedgerId(), ls);
                }
                if (!ledgers.isEmpty()) {
                    long id = (Long)ledgers.lastKey();
                    AsyncCallback.OpenCallback opencb = (rc, lh, ctx1) -> {
                        if (log.isDebugEnabled()) {
                            log.debug("[{}] Opened ledger {}: {}", new Object[]{managedLedgerName, id, BKException.getMessage((int)rc)});
                        }
                        if (rc == 0) {
                            MLDataFormats.ManagedLedgerInfo.LedgerInfo info = MLDataFormats.ManagedLedgerInfo.LedgerInfo.newBuilder().setLedgerId(id).setEntries(lh.getLastAddConfirmed() + 1L).setSize(lh.getLength()).setTimestamp(System.currentTimeMillis()).build();
                            ledgers.put(id, info);
                            mlMetaCounter.countDown();
                        } else if (Errors.isNoSuchLedgerExistsException(rc)) {
                            log.warn("[{}] Ledger not found: {}", (Object)managedLedgerName, ledgers.lastKey());
                            ledgers.remove(ledgers.lastKey());
                            mlMetaCounter.countDown();
                        } else {
                            log.error("[{}] Failed to open ledger {}: {}", new Object[]{managedLedgerName, id, BKException.getMessage((int)rc)});
                            mlMetaCounter.countDown();
                        }
                    };
                    if (log.isDebugEnabled()) {
                        log.debug("[{}] Opening ledger {}", (Object)managedLedgerName, (Object)id);
                    }
                    ((CompletableFuture)ManagedLedgerFactoryImpl.this.getBookKeeper().thenAccept(bk -> bk.asyncOpenLedgerNoRecovery(id, digestType, password, opencb, null))).exceptionally(ex -> {
                        log.warn("[{}] Failed to open ledger {}: {}", new Object[]{managedLedgerName, id, ex});
                        opencb.openComplete(-1, null, null);
                        mlMetaCounter.countDown();
                        return null;
                    });
                } else {
                    log.warn("[{}] Ledger list empty", (Object)managedLedgerName);
                    mlMetaCounter.countDown();
                }
            }

            @Override
            public void operationFailed(ManagedLedgerException.MetaStoreException e) {
                log.warn("[{}] Unable to obtain managed ledger metadata - {}", (Object)managedLedgerName, (Object)e);
                mlMetaCounter.countDown();
            }
        });
        if (accurate) {
            mlMetaCounter.await();
        } else {
            mlMetaCounter.await(60L, TimeUnit.SECONDS);
        }
        return ledgers;
    }

    public void calculateCursorBacklogs(TopicName topicName, final NavigableMap<Long, MLDataFormats.ManagedLedgerInfo.LedgerInfo> ledgers, final PersistentOfflineTopicStats offlineTopicStats, final boolean accurate, final BookKeeper.DigestType digestType, final byte[] password) throws Exception {
        if (ledgers.isEmpty()) {
            return;
        }
        final String managedLedgerName = topicName.getPersistenceNamingEncoding();
        final MetaStore store = this.getMetaStore();
        final BookKeeper bk = this.getBookKeeper().get();
        final CountDownLatch allCursorsCounter = new CountDownLatch(1);
        long errorInReadingCursor = -1L;
        final ConcurrentHashMap<String, Long> ledgerRetryMap = new ConcurrentHashMap<String, Long>();
        MLDataFormats.ManagedLedgerInfo.LedgerInfo ledgerInfo = ledgers.lastEntry().getValue();
        final Position lastLedgerPosition = PositionFactory.create(ledgerInfo.getLedgerId(), ledgerInfo.getEntries() - 1L);
        if (log.isDebugEnabled()) {
            log.debug("[{}] Last ledger position {}", (Object)managedLedgerName, (Object)lastLedgerPosition);
        }
        store.getCursors(managedLedgerName, new MetaStore.MetaStoreCallback<List<String>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void operationComplete(List<String> cursors, Stat v) {
                if (log.isDebugEnabled()) {
                    log.debug("[{}] Found {} cursors", (Object)managedLedgerName, (Object)cursors.size());
                }
                if (cursors.isEmpty()) {
                    allCursorsCounter.countDown();
                    return;
                }
                final CountDownLatch cursorCounter = new CountDownLatch(cursors.size());
                for (final String cursorName : cursors) {
                    if (log.isDebugEnabled()) {
                        log.debug("[{}] Loading cursor {}", (Object)managedLedgerName, (Object)cursorName);
                    }
                    final AsyncCallback.OpenCallback cursorLedgerOpenCb = (rc, lh, ctx1) -> {
                        final long ledgerId = lh.getId();
                        if (log.isDebugEnabled()) {
                            log.debug("[{}] Opened cursor ledger {} for cursor {}. rc={}", new Object[]{managedLedgerName, ledgerId, cursorName, rc});
                        }
                        if (rc != 0) {
                            log.warn("[{}] Error opening metadata ledger {} for cursor {}: {}", new Object[]{managedLedgerName, ledgerId, cursorName, BKException.getMessage((int)rc)});
                            cursorCounter.countDown();
                            return;
                        }
                        long lac = lh.getLastAddConfirmed();
                        if (log.isDebugEnabled()) {
                            log.debug("[{}] Cursor {} LAC {} read from ledger {}", new Object[]{managedLedgerName, cursorName, lac, ledgerId});
                        }
                        if (lac == -1L) {
                            ledgerRetryMap.put(cursorName, ledgerId);
                            log.info("[{}] Cursor {} LAC {} read from ledger {}", new Object[]{managedLedgerName, cursorName, lac, ledgerId});
                            cursorCounter.countDown();
                            return;
                        }
                        final long entryId = lac;
                        lh.asyncReadEntries(entryId, entryId, new AsyncCallback.ReadCallback(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            public void readComplete(int rc, LedgerHandle lh, Enumeration<LedgerEntry> seq, Object ctx) {
                                block10: {
                                    try {
                                        MLDataFormats.PositionInfo positionInfo;
                                        if (log.isDebugEnabled()) {
                                            log.debug("readComplete rc={} entryId={}", (Object)rc, (Object)entryId);
                                        }
                                        if (rc != 0) {
                                            log.warn("[{}] Error reading from metadata ledger {} for cursor {}: {}", new Object[]{managedLedgerName, ledgerId, cursorName, BKException.getMessage((int)rc)});
                                            offlineTopicStats.addCursorDetails(cursorName, -1L, lh.getId());
                                            break block10;
                                        }
                                        LedgerEntry entry = seq.nextElement();
                                        try {
                                            positionInfo = MLDataFormats.PositionInfo.parseFrom(entry.getEntry());
                                        }
                                        catch (InvalidProtocolBufferException e) {
                                            log.warn("[{}] Error reading position from metadata ledger {} for cursor {}: {}", new Object[]{managedLedgerName, ledgerId, cursorName, e});
                                            offlineTopicStats.addCursorDetails(cursorName, -1L, lh.getId());
                                            cursorCounter.countDown();
                                            return;
                                        }
                                        Position lastAckedMessagePosition = PositionFactory.create(positionInfo.getLedgerId(), positionInfo.getEntryId());
                                        if (log.isDebugEnabled()) {
                                            log.debug("[{}] Cursor {} MD {} read last ledger position {}", new Object[]{managedLedgerName, cursorName, lastAckedMessagePosition, lastLedgerPosition});
                                        }
                                        Range range = Range.openClosed((Comparable)lastAckedMessagePosition, (Comparable)lastLedgerPosition);
                                        if (log.isDebugEnabled()) {
                                            log.debug("[{}] Calculating backlog for cursor {} using range {}", new Object[]{managedLedgerName, cursorName, range});
                                        }
                                        long cursorBacklog = ManagedLedgerFactoryImpl.this.getNumberOfEntries((Range<Position>)range, ledgers);
                                        offlineTopicStats.messageBacklog += cursorBacklog;
                                        offlineTopicStats.addCursorDetails(cursorName, cursorBacklog, lh.getId());
                                    }
                                    finally {
                                        cursorCounter.countDown();
                                    }
                                }
                            }
                        }, null);
                    };
                    store.asyncGetCursorInfo(managedLedgerName, cursorName, new MetaStore.MetaStoreCallback<MLDataFormats.ManagedCursorInfo>(){

                        @Override
                        public void operationComplete(MLDataFormats.ManagedCursorInfo info, Stat stat) {
                            long cursorLedgerId = info.getCursorsLedgerId();
                            if (log.isDebugEnabled()) {
                                log.debug("[{}] Cursor {} meta-data read ledger id {}", new Object[]{managedLedgerName, cursorName, cursorLedgerId});
                            }
                            if (cursorLedgerId != -1L) {
                                bk.asyncOpenLedgerNoRecovery(cursorLedgerId, digestType, password, cursorLedgerOpenCb, null);
                            } else {
                                Position lastAckedMessagePosition = PositionFactory.create(info.getMarkDeleteLedgerId(), info.getMarkDeleteEntryId());
                                Range range = Range.openClosed((Comparable)lastAckedMessagePosition, (Comparable)lastLedgerPosition);
                                if (log.isDebugEnabled()) {
                                    log.debug("[{}] Calculating backlog for cursor {} using range {}", new Object[]{managedLedgerName, cursorName, range});
                                }
                                long cursorBacklog = ManagedLedgerFactoryImpl.this.getNumberOfEntries((Range<Position>)range, ledgers);
                                offlineTopicStats.messageBacklog += cursorBacklog;
                                offlineTopicStats.addCursorDetails(cursorName, cursorBacklog, cursorLedgerId);
                                cursorCounter.countDown();
                            }
                        }

                        @Override
                        public void operationFailed(ManagedLedgerException.MetaStoreException e) {
                            log.warn("[{}] Unable to obtain cursor ledger for cursor {}: {}", new Object[]{managedLedgerName, cursorName, e});
                            cursorCounter.countDown();
                        }
                    });
                }
                try {
                    if (accurate) {
                        cursorCounter.await();
                    } else {
                        cursorCounter.await(60L, TimeUnit.SECONDS);
                    }
                }
                catch (Exception e) {
                    log.warn("[{}] Error reading subscription positions{}", (Object)managedLedgerName, (Object)e);
                }
                finally {
                    allCursorsCounter.countDown();
                }
            }

            @Override
            public void operationFailed(ManagedLedgerException.MetaStoreException e) {
                log.warn("[{}] Failed to get the cursors list", (Object)managedLedgerName, (Object)e);
                allCursorsCounter.countDown();
            }
        });
        if (accurate) {
            allCursorsCounter.await();
        } else {
            allCursorsCounter.await(60L, TimeUnit.SECONDS);
        }
        if (accurate && ledgerRetryMap.size() > 0) {
            ledgerRetryMap.forEach((cursorName, ledgerId) -> {
                Position lastAckedMessagePosition;
                if (log.isDebugEnabled()) {
                    log.debug("Cursor {} Ledger {} Trying to obtain MD from BkAdmin", cursorName, ledgerId);
                }
                if ((lastAckedMessagePosition = this.tryGetMDPosition(bk, (long)ledgerId, (String)cursorName)) == null) {
                    log.warn("[{}] Cursor {} read from ledger {}. Unable to determine cursor position", new Object[]{managedLedgerName, cursorName, ledgerId});
                } else {
                    if (log.isDebugEnabled()) {
                        log.debug("[{}] Cursor {} read from ledger using bk admin {}. position {}", new Object[]{managedLedgerName, cursorName, ledgerId, lastAckedMessagePosition});
                    }
                    Range range = Range.openClosed((Comparable)lastAckedMessagePosition, (Comparable)lastLedgerPosition);
                    if (log.isDebugEnabled()) {
                        log.debug("[{}] Calculating backlog for cursor {} using range {}", new Object[]{managedLedgerName, cursorName, range});
                    }
                    long cursorBacklog = this.getNumberOfEntries((Range<Position>)range, ledgers);
                    offlineTopicStats.messageBacklog += cursorBacklog;
                    offlineTopicStats.addCursorDetails(cursorName, cursorBacklog, ledgerId.longValue());
                }
            });
        }
    }

    private long getNumberOfEntries(Range<Position> range, NavigableMap<Long, MLDataFormats.ManagedLedgerInfo.LedgerInfo> ledgers) {
        boolean toIncluded;
        Position fromPosition = (Position)range.lowerEndpoint();
        boolean fromIncluded = range.lowerBoundType() == BoundType.CLOSED;
        Position toPosition = (Position)range.upperEndpoint();
        boolean bl = toIncluded = range.upperBoundType() == BoundType.CLOSED;
        if (fromPosition.getLedgerId() == toPosition.getLedgerId()) {
            long count = toPosition.getEntryId() - fromPosition.getEntryId() - 1L;
            count += fromIncluded ? 1L : 0L;
            return count += toIncluded ? 1L : 0L;
        }
        long count = 0L;
        count += toPosition.getEntryId();
        count += toIncluded ? 1L : 0L;
        MLDataFormats.ManagedLedgerInfo.LedgerInfo li = (MLDataFormats.ManagedLedgerInfo.LedgerInfo)ledgers.get(fromPosition.getLedgerId());
        if (li != null) {
            count += li.getEntries() - (fromPosition.getEntryId() + 1L);
            count += fromIncluded ? 1L : 0L;
        }
        for (MLDataFormats.ManagedLedgerInfo.LedgerInfo ls : ledgers.subMap(fromPosition.getLedgerId(), false, toPosition.getLedgerId(), false).values()) {
            count += ls.getEntries();
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Position tryGetMDPosition(BookKeeper bookKeeper, long ledgerId, String cursorName) {
        BookKeeperAdmin bookKeeperAdmin = null;
        long lastEntry = -1L;
        Position lastAckedMessagePosition = null;
        bookKeeperAdmin = new BookKeeperAdmin(bookKeeper);
        for (LedgerEntry ledgerEntry : bookKeeperAdmin.readEntries(ledgerId, 0L, lastEntry)) {
            lastEntry = ledgerEntry.getEntryId();
            if (log.isDebugEnabled()) {
                log.debug(" Read entry {} from ledger {} for cursor {}", new Object[]{lastEntry, ledgerId, cursorName});
            }
            MLDataFormats.PositionInfo positionInfo = MLDataFormats.PositionInfo.parseFrom(ledgerEntry.getEntry());
            lastAckedMessagePosition = PositionFactory.create(positionInfo.getLedgerId(), positionInfo.getEntryId());
            if (!log.isDebugEnabled()) continue;
            log.debug("Cursor {} read position {}", (Object)cursorName, (Object)lastAckedMessagePosition);
        }
        if (bookKeeperAdmin == null) return lastAckedMessagePosition;
        try {
            bookKeeperAdmin.close();
            return lastAckedMessagePosition;
        }
        catch (Exception e) {
            log.warn("Unable to close bk admin for ledgerId {} for cursor {}", new Object[]{ledgerId, cursorName, e});
        }
        return lastAckedMessagePosition;
        catch (Exception e) {
            try {
                log.warn("Unable to determine LAC for ledgerId {} for cursor {}: {}", new Object[]{ledgerId, cursorName, e});
                if (bookKeeperAdmin == null) return lastAckedMessagePosition;
            }
            catch (Throwable throwable) {
                if (bookKeeperAdmin == null) throw throwable;
                try {
                    bookKeeperAdmin.close();
                    throw throwable;
                }
                catch (Exception e2) {
                    log.warn("Unable to close bk admin for ledgerId {} for cursor {}", new Object[]{ledgerId, cursorName, e2});
                }
                throw throwable;
            }
            try {
                bookKeeperAdmin.close();
                return lastAckedMessagePosition;
            }
            catch (Exception e3) {
                log.warn("Unable to close bk admin for ledgerId {} for cursor {}", new Object[]{ledgerId, cursorName, e3});
            }
            return lastAckedMessagePosition;
        }
    }

    @Generated
    public OrderedScheduler getScheduledExecutor() {
        return this.scheduledExecutor;
    }

    @Generated
    public ScheduledExecutorService getCacheEvictionExecutor() {
        return this.cacheEvictionExecutor;
    }

    @Generated
    public ManagedLedgerFactoryMBeanImpl getMbean() {
        return this.mbean;
    }

    @Generated
    public OpenTelemetryManagedLedgerStats getOpenTelemetryManagedLedgerStats() {
        return this.openTelemetryManagedLedgerStats;
    }

    @Generated
    public boolean isMetadataServiceAvailable() {
        return this.metadataServiceAvailable;
    }

    private /* synthetic */ void lambda$asyncOpen$8(final String name, final ManagedLedgerConfig config, Supplier mlOwnershipChecker, final CompletableFuture future, BookKeeper bk) {
        final ManagedLedgerImpl newledger = this.createManagedLedger(bk, this.store, name, config, mlOwnershipChecker);
        final PendingInitializeManagedLedger pendingLedger = new PendingInitializeManagedLedger(newledger);
        this.pendingInitializeLedgers.put(name, pendingLedger);
        newledger.initialize(new ManagedLedgerImpl.ManagedLedgerInitializeLedgerCallback(){

            @Override
            public void initializeComplete() {
                log.info("[{}] Successfully initialize managed ledger", (Object)name);
                ManagedLedgerFactoryImpl.this.pendingInitializeLedgers.remove(name, pendingLedger);
                newledger.maybeUpdateCursorBeforeTrimmingConsumedLedger().whenComplete((__, ex) -> {
                    future.complete(newledger);
                    if (config.isTriggerOffloadOnTopicLoad()) {
                        newledger.maybeOffloadInBackground(ManagedLedgerImpl.NULL_OFFLOAD_PROMISE);
                    }
                });
            }

            @Override
            public void initializeFailed(ManagedLedgerException e) {
                if (config.isCreateIfMissing()) {
                    log.error("[{}] Failed to initialize managed ledger: {}", (Object)name, (Object)e.getMessage());
                }
                ManagedLedgerFactoryImpl.this.ledgers.remove(name, future);
                ManagedLedgerFactoryImpl.this.entryCacheManager.removeEntryCache(name);
                if (ManagedLedgerFactoryImpl.this.pendingInitializeLedgers.remove(name, pendingLedger)) {
                    pendingLedger.ledger.asyncClose(new AsyncCallbacks.CloseCallback(){

                        @Override
                        public void closeComplete(Object ctx) {
                        }

                        @Override
                        public void closeFailed(ManagedLedgerException exception, Object ctx) {
                            log.warn("[{}] Failed to a pending initialization managed ledger", (Object)name, (Object)exception);
                        }
                    }, null);
                }
                future.completeExceptionally(e);
            }
        }, null);
    }

    static class DefaultBkFactory
    implements BookkeeperFactoryForCustomEnsemblePlacementPolicy,
    AutoCloseable {
        private final BookKeeper bkClient;

        public DefaultBkFactory(ClientConfiguration bkClientConfiguration) throws InterruptedException, BKException, IOException {
            this.bkClient = new BookKeeper(bkClientConfiguration);
        }

        @Override
        public CompletableFuture<BookKeeper> get(EnsemblePlacementPolicyConfig policy) {
            return CompletableFuture.completedFuture(this.bkClient);
        }

        @Override
        public void close() throws Exception {
            this.bkClient.close();
        }
    }

    public static interface BookkeeperFactoryForCustomEnsemblePlacementPolicy {
        default public CompletableFuture<BookKeeper> get() {
            return this.get(null);
        }

        public CompletableFuture<BookKeeper> get(EnsemblePlacementPolicyConfig var1);
    }

    private static class PendingInitializeManagedLedger {
        private final ManagedLedgerImpl ledger;
        private final long createTimeMs;

        PendingInitializeManagedLedger(ManagedLedgerImpl ledger) {
            this.ledger = ledger;
            this.createTimeMs = System.currentTimeMillis();
        }
    }
}

