/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.resources;

import com.google.auto.service.AutoService;
import io.opentelemetry.instrumentation.resources.internal.JarServiceNameResourceExtractor;
import io.opentelemetry.sdk.autoconfigure.spi.ConfigProperties;
import io.opentelemetry.sdk.autoconfigure.spi.ResourceProvider;
import io.opentelemetry.sdk.autoconfigure.spi.internal.ConditionalResourceProvider;
import io.opentelemetry.sdk.resources.Resource;
import io.opentelemetry.semconv.ServiceAttributes;
import java.util.Map;

@AutoService(value={ResourceProvider.class})
public final class JarServiceNameDetector
implements ConditionalResourceProvider {
    public Resource createResource(ConfigProperties config) {
        return new JarServiceNameResourceExtractor().extract();
    }

    public boolean shouldApply(ConfigProperties config, Resource existing) {
        String serviceName = config.getString("otel.service.name");
        Map resourceAttributes = config.getMap("otel.resource.attributes");
        return serviceName == null && !resourceAttributes.containsKey(ServiceAttributes.SERVICE_NAME.getKey()) && "unknown_service:java".equals(existing.getAttribute(ServiceAttributes.SERVICE_NAME));
    }

    public int order() {
        return 1000;
    }
}

