/*
 * Decompiled with CFR 0.152.
 */
package org.apache.distributedlog.common.config;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.commons.configuration2.FileBasedConfiguration;
import org.apache.commons.configuration2.PropertiesConfiguration;
import org.apache.commons.configuration2.builder.BuilderParameters;
import org.apache.commons.configuration2.builder.ConfigurationBuilderEvent;
import org.apache.commons.configuration2.builder.ReloadingFileBasedConfigurationBuilder;
import org.apache.commons.configuration2.builder.fluent.FileBasedBuilderParameters;
import org.apache.commons.configuration2.builder.fluent.Parameters;
import org.apache.commons.configuration2.convert.DefaultListDelimiterHandler;
import org.apache.commons.configuration2.convert.ListDelimiterHandler;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.commons.configuration2.reloading.PeriodicReloadingTrigger;
import org.apache.commons.configuration2.reloading.ReloadingController;
import org.apache.distributedlog.common.config.ConcurrentBaseConfiguration;
import org.apache.distributedlog.common.config.ConfigurationListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurationSubscription
implements AutoCloseable {
    static final Logger LOG = LoggerFactory.getLogger(ConfigurationSubscription.class);
    private final ConcurrentBaseConfiguration viewConfig;
    private final ScheduledExecutorService executorService;
    private final int reloadPeriod;
    private final TimeUnit reloadUnit;
    private final Map<File, FileBasedConfiguration> fileConfigs;
    private final CopyOnWriteArraySet<ConfigurationListener> confListeners;
    private final Map<File, PeriodicReloadingTrigger> reloadingTriggers;

    public ConfigurationSubscription(ConcurrentBaseConfiguration viewConfig, List<File> configFiles, ScheduledExecutorService executorService, int reloadPeriod, TimeUnit reloadUnit) throws ConfigurationException {
        Preconditions.checkNotNull(configFiles);
        Preconditions.checkArgument((!configFiles.isEmpty() ? 1 : 0) != 0);
        Preconditions.checkNotNull((Object)executorService);
        Preconditions.checkNotNull((Object)((Object)viewConfig));
        this.viewConfig = viewConfig;
        this.executorService = executorService;
        this.reloadPeriod = reloadPeriod;
        this.reloadUnit = reloadUnit;
        this.reloadingTriggers = new HashMap<File, PeriodicReloadingTrigger>();
        this.fileConfigs = new LinkedHashMap<File, FileBasedConfiguration>();
        this.confListeners = new CopyOnWriteArraySet();
        this.initConfig(configFiles);
        this.refreshConfiguration();
    }

    public void registerListener(ConfigurationListener listener) {
        this.confListeners.add(listener);
    }

    public void unregisterListener(ConfigurationListener listener) {
        this.confListeners.remove(listener);
    }

    private void initConfig(List<File> configFiles) {
        block3: {
            try {
                for (File configFile : configFiles) {
                    FileBasedBuilderParameters parameters = (FileBasedBuilderParameters)((FileBasedBuilderParameters)((FileBasedBuilderParameters)new Parameters().fileBased().setFile(configFile)).setReloadingRefreshDelay(Long.valueOf(0L))).setListDelimiterHandler((ListDelimiterHandler)new DefaultListDelimiterHandler(','));
                    ReloadingFileBasedConfigurationBuilder configBuilder = new ReloadingFileBasedConfigurationBuilder(PropertiesConfiguration.class).configure(new BuilderParameters[]{parameters});
                    ReloadingController reloadingController = configBuilder.getReloadingController();
                    PeriodicReloadingTrigger trigger = new PeriodicReloadingTrigger(reloadingController, (Object)configFile, (long)this.reloadPeriod, this.reloadUnit, this.executorService);
                    trigger.start();
                    this.reloadingTriggers.put(configFile, trigger);
                    configBuilder.addEventListener(ConfigurationBuilderEvent.RESET, event -> {
                        try {
                            this.configChanged(configFile, (ConfigurationBuilderEvent)event);
                        }
                        catch (ConfigurationException e) {
                            LOG.error("Config reload failed for file {}", (Object)configFile, (Object)e);
                        }
                    });
                    FileBasedConfiguration fileConfig = (FileBasedConfiguration)configBuilder.getConfiguration();
                    this.fileConfigs.put(configFile, fileConfig);
                }
            }
            catch (ConfigurationException ex) {
                if (this.fileNotFound((Exception)((Object)ex))) break block3;
                LOG.error("Config init failed", (Throwable)ex);
            }
        }
    }

    void configChanged(File configFile, ConfigurationBuilderEvent event) throws ConfigurationException {
        ReloadingFileBasedConfigurationBuilder configBuilder = (ReloadingFileBasedConfigurationBuilder)event.getSource();
        FileBasedConfiguration configuration = (FileBasedConfiguration)configBuilder.getConfiguration();
        this.fileConfigs.put(configFile, configuration);
        this.refreshConfiguration();
    }

    synchronized void refreshConfiguration() {
        HashSet confKeys = Sets.newHashSet();
        for (Map.Entry<File, FileBasedConfiguration> entry : this.fileConfigs.entrySet()) {
            File configFile = entry.getKey();
            FileBasedConfiguration fileConfig = entry.getValue();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Check and reload config, file={}, lastModified={}", (Object)configFile, (Object)configFile.lastModified());
            }
            Iterator keyIter = fileConfig.getKeys();
            while (keyIter.hasNext()) {
                String key = (String)keyIter.next();
                confKeys.add(key);
            }
        }
        Iterator viewIter = this.viewConfig.getKeys();
        while (viewIter.hasNext()) {
            String key = (String)viewIter.next();
            if (confKeys.contains(key)) continue;
            this.clearViewProperty(key);
        }
        LOG.info("Reload features : {}", (Object)confKeys);
        for (Map.Entry<File, FileBasedConfiguration> entry : this.fileConfigs.entrySet()) {
            File configFile = entry.getKey();
            FileBasedConfiguration fileConfig = entry.getValue();
            try {
                this.loadView(fileConfig);
            }
            catch (Exception ex) {
                if (this.fileNotFound(ex)) continue;
                LOG.error("Config reload failed for file {}", (Object)configFile, (Object)ex);
            }
        }
        for (ConfigurationListener listener : this.confListeners) {
            listener.onReload(this.viewConfig);
        }
    }

    private boolean fileNotFound(Exception ex) {
        return ex instanceof FileNotFoundException || ex.getCause() != null && ex.getCause() instanceof FileNotFoundException;
    }

    private void loadView(FileBasedConfiguration fileConfig) {
        Iterator fileIter = fileConfig.getKeys();
        while (fileIter.hasNext()) {
            String key = (String)fileIter.next();
            this.setViewProperty(fileConfig, key, fileConfig.getProperty(key));
        }
    }

    private void clearViewProperty(String key) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Removing property, key={}", (Object)key);
        }
        this.viewConfig.clearProperty(key);
    }

    private void setViewProperty(FileBasedConfiguration fileConfig, String key, Object value) {
        if (!this.viewConfig.containsKey(key) || !this.viewConfig.getProperty(key).equals(value)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Setting property, key={} value={}", (Object)key, fileConfig.getProperty(key));
            }
            this.viewConfig.setProperty(key, fileConfig.getProperty(key));
        }
    }

    @Override
    public void close() throws Exception {
        this.reloadingTriggers.values().forEach(PeriodicReloadingTrigger::stop);
    }
}

