/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.storage;

import io.netty.channel.EventLoopGroup;
import io.opentelemetry.api.OpenTelemetry;
import java.io.IOException;
import java.util.Collection;
import java.util.Optional;
import org.apache.pulsar.broker.BookKeeperClientFactory;
import org.apache.pulsar.broker.ServiceConfiguration;
import org.apache.pulsar.broker.storage.ManagedLedgerStorageClass;
import org.apache.pulsar.common.classification.InterfaceAudience;
import org.apache.pulsar.common.classification.InterfaceStability;
import org.apache.pulsar.common.util.Reflections;
import org.apache.pulsar.metadata.api.extended.MetadataStoreExtended;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public interface ManagedLedgerStorage
extends AutoCloseable {
    public void initialize(ServiceConfiguration var1, MetadataStoreExtended var2, BookKeeperClientFactory var3, EventLoopGroup var4, OpenTelemetry var5) throws Exception;

    public Collection<ManagedLedgerStorageClass> getStorageClasses();

    default public ManagedLedgerStorageClass getDefaultStorageClass() {
        return this.getStorageClasses().stream().findFirst().get();
    }

    public Optional<ManagedLedgerStorageClass> getManagedLedgerStorageClass(String var1);

    @Override
    public void close() throws IOException;

    public static ManagedLedgerStorage create(ServiceConfiguration conf, MetadataStoreExtended metadataStore, BookKeeperClientFactory bkProvider, EventLoopGroup eventLoopGroup, OpenTelemetry openTelemetry) throws Exception {
        ManagedLedgerStorage storage = (ManagedLedgerStorage)Reflections.createInstance((String)conf.getManagedLedgerStorageClassName(), ManagedLedgerStorage.class, (ClassLoader)Thread.currentThread().getContextClassLoader());
        storage.initialize(conf, metadataStore, bkProvider, eventLoopGroup, openTelemetry);
        return storage;
    }
}

