/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.runtimemetrics.java8;

import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.metrics.Meter;
import io.opentelemetry.api.metrics.ObservableLongMeasurement;
import io.opentelemetry.instrumentation.api.internal.SemconvStability;
import io.opentelemetry.instrumentation.runtimemetrics.java8.internal.JmxRuntimeMetricsUtil;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryType;
import java.lang.management.MemoryUsage;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;

public final class MemoryPools {
    private static final AttributeKey<String> TYPE_KEY = AttributeKey.stringKey((String)"type");
    private static final AttributeKey<String> POOL_KEY = AttributeKey.stringKey((String)"pool");
    private static final AttributeKey<String> JVM_MEMORY_POOL_NAME = AttributeKey.stringKey((String)"jvm.memory.pool.name");
    private static final AttributeKey<String> JVM_MEMORY_TYPE = AttributeKey.stringKey((String)"jvm.memory.type");
    private static final String HEAP = "heap";
    private static final String NON_HEAP = "non_heap";

    public static List<AutoCloseable> registerObservers(OpenTelemetry openTelemetry) {
        return MemoryPools.registerObservers(openTelemetry, ManagementFactory.getMemoryPoolMXBeans());
    }

    static List<AutoCloseable> registerObservers(OpenTelemetry openTelemetry, List<MemoryPoolMXBean> poolBeans) {
        Meter meter = JmxRuntimeMetricsUtil.getMeter(openTelemetry);
        ArrayList<AutoCloseable> observables = new ArrayList<AutoCloseable>();
        if (SemconvStability.emitOldJvmSemconv()) {
            observables.add((AutoCloseable)meter.upDownCounterBuilder("process.runtime.jvm.memory.usage").setDescription("Measure of memory used").setUnit("By").buildWithCallback(MemoryPools.callback(POOL_KEY, TYPE_KEY, poolBeans, MemoryPoolMXBean::getUsage, MemoryUsage::getUsed)));
            observables.add((AutoCloseable)meter.upDownCounterBuilder("process.runtime.jvm.memory.init").setDescription("Measure of initial memory requested").setUnit("By").buildWithCallback(MemoryPools.callback(POOL_KEY, TYPE_KEY, poolBeans, MemoryPoolMXBean::getUsage, MemoryUsage::getInit)));
            observables.add((AutoCloseable)meter.upDownCounterBuilder("process.runtime.jvm.memory.committed").setDescription("Measure of memory committed").setUnit("By").buildWithCallback(MemoryPools.callback(POOL_KEY, TYPE_KEY, poolBeans, MemoryPoolMXBean::getUsage, MemoryUsage::getCommitted)));
            observables.add((AutoCloseable)meter.upDownCounterBuilder("process.runtime.jvm.memory.limit").setDescription("Measure of max obtainable memory").setUnit("By").buildWithCallback(MemoryPools.callback(POOL_KEY, TYPE_KEY, poolBeans, MemoryPoolMXBean::getUsage, MemoryUsage::getMax)));
            observables.add((AutoCloseable)meter.upDownCounterBuilder("process.runtime.jvm.memory.usage_after_last_gc").setDescription("Measure of memory used after the most recent garbage collection event on this pool").setUnit("By").buildWithCallback(MemoryPools.callback(POOL_KEY, TYPE_KEY, poolBeans, MemoryPoolMXBean::getCollectionUsage, MemoryUsage::getUsed)));
        }
        if (SemconvStability.emitStableJvmSemconv()) {
            observables.add((AutoCloseable)meter.upDownCounterBuilder("jvm.memory.used").setDescription("Measure of memory used.").setUnit("By").buildWithCallback(MemoryPools.callback(JVM_MEMORY_POOL_NAME, JVM_MEMORY_TYPE, poolBeans, MemoryPoolMXBean::getUsage, MemoryUsage::getUsed)));
            observables.add((AutoCloseable)meter.upDownCounterBuilder("jvm.memory.committed").setDescription("Measure of memory committed.").setUnit("By").buildWithCallback(MemoryPools.callback(JVM_MEMORY_POOL_NAME, JVM_MEMORY_TYPE, poolBeans, MemoryPoolMXBean::getUsage, MemoryUsage::getCommitted)));
            observables.add((AutoCloseable)meter.upDownCounterBuilder("jvm.memory.limit").setDescription("Measure of max obtainable memory.").setUnit("By").buildWithCallback(MemoryPools.callback(JVM_MEMORY_POOL_NAME, JVM_MEMORY_TYPE, poolBeans, MemoryPoolMXBean::getUsage, MemoryUsage::getMax)));
            observables.add((AutoCloseable)meter.upDownCounterBuilder("jvm.memory.used_after_last_gc").setDescription("Measure of memory used, as measured after the most recent garbage collection event on this pool.").setUnit("By").buildWithCallback(MemoryPools.callback(JVM_MEMORY_POOL_NAME, JVM_MEMORY_TYPE, poolBeans, MemoryPoolMXBean::getCollectionUsage, MemoryUsage::getUsed)));
        }
        return observables;
    }

    static Consumer<ObservableLongMeasurement> callback(AttributeKey<String> poolNameKey, AttributeKey<String> memoryTypeKey, List<MemoryPoolMXBean> poolBeans, Function<MemoryPoolMXBean, MemoryUsage> memoryUsageExtractor, Function<MemoryUsage, Long> valueExtractor) {
        ArrayList<Attributes> attributeSets = new ArrayList<Attributes>(poolBeans.size());
        for (MemoryPoolMXBean pool : poolBeans) {
            attributeSets.add(Attributes.builder().put(poolNameKey, (Object)pool.getName()).put(memoryTypeKey, (Object)MemoryPools.memoryType(pool.getType())).build());
        }
        return measurement -> {
            for (int i = 0; i < poolBeans.size(); ++i) {
                long value;
                Attributes attributes = (Attributes)attributeSets.get(i);
                MemoryUsage memoryUsage = (MemoryUsage)memoryUsageExtractor.apply((MemoryPoolMXBean)poolBeans.get(i));
                if (memoryUsage == null || (value = ((Long)valueExtractor.apply(memoryUsage)).longValue()) == -1L) continue;
                measurement.record(value, attributes);
            }
        };
    }

    private static String memoryType(MemoryType memoryType) {
        switch (memoryType) {
            case HEAP: {
                return HEAP;
            }
            case NON_HEAP: {
                return NON_HEAP;
            }
        }
        return "unknown";
    }

    private MemoryPools() {
    }
}

