/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.instance.state;

import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.pulsar.functions.instance.state.DefaultStateStore;
import org.apache.pulsar.functions.instance.state.PulsarMetadataStateStoreImpl;
import org.apache.pulsar.functions.instance.state.StateStoreProvider;
import org.apache.pulsar.metadata.api.MetadataStore;
import org.apache.pulsar.metadata.api.MetadataStoreConfig;
import org.apache.pulsar.metadata.api.MetadataStoreFactory;

public class PulsarMetadataStateStoreProviderImpl
implements StateStoreProvider {
    private static final String METADATA_URL = "METADATA_URL";
    private static final String METADATA_STORE_INSTANCE = "METADATA_STORE_INSTANCE";
    private static final String METADATA_PREFIX = "METADATA_PREFIX";
    private static final String METADATA_DEFAULT_PREFIX = "/state-store";
    private MetadataStore store;
    private String prefix;
    private boolean shouldCloseStore;

    @Override
    public void init(Map<String, Object> config) throws Exception {
        this.prefix = (String)config.getOrDefault(METADATA_PREFIX, METADATA_DEFAULT_PREFIX);
        if (config.containsKey(METADATA_STORE_INSTANCE)) {
            this.store = (MetadataStore)config.get(METADATA_STORE_INSTANCE);
            this.shouldCloseStore = false;
        } else {
            String metadataUrl = (String)config.get(METADATA_URL);
            if (StringUtils.isEmpty((CharSequence)metadataUrl)) {
                metadataUrl = (String)config.get("stateStorageServiceUrl");
            }
            this.store = MetadataStoreFactory.create((String)metadataUrl, (MetadataStoreConfig)MetadataStoreConfig.builder().metadataStoreName("state-metadata-store").build());
            this.shouldCloseStore = true;
        }
    }

    public DefaultStateStore getStateStore(String tenant, String namespace, String name) throws Exception {
        return new PulsarMetadataStateStoreImpl(this.store, this.prefix, tenant, namespace, name);
    }

    @Override
    public void cleanUp(String tenant, String namespace, String name) throws Exception {
        String fqsn = tenant + "/" + namespace + "/" + name;
        String prefixPath = this.prefix + "/" + fqsn + "/";
        this.store.deleteRecursive(prefixPath);
    }

    @Override
    public void close() {
        if (this.shouldCloseStore) {
            this.store.close();
        }
    }
}

