/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.admin.cli;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.List;
import java.util.function.Supplier;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.CtField;
import javassist.CtNewConstructor;
import javassist.bytecode.AnnotationsAttribute;
import javassist.bytecode.AttributeInfo;
import javassist.bytecode.ClassFile;
import javassist.bytecode.ConstPool;
import javassist.bytecode.annotation.Annotation;
import javassist.bytecode.annotation.ArrayMemberValue;
import javassist.bytecode.annotation.BooleanMemberValue;
import javassist.bytecode.annotation.MemberValue;
import javassist.bytecode.annotation.StringMemberValue;
import lombok.Generated;
import org.apache.pulsar.admin.cli.CliCommand;
import org.apache.pulsar.admin.cli.CmdBase;
import org.apache.pulsar.admin.cli.extensions.CommandExecutionContext;
import org.apache.pulsar.admin.cli.extensions.CustomCommand;
import org.apache.pulsar.admin.cli.extensions.CustomCommandGroup;
import org.apache.pulsar.admin.cli.extensions.ParameterDescriptor;
import org.apache.pulsar.admin.cli.extensions.ParameterType;
import org.apache.pulsar.client.admin.PulsarAdmin;
import picocli.CommandLine;

public final class CustomCommandsUtils {
    private CustomCommandsUtils() {
    }

    public static Object generateCliCommand(CustomCommandGroup group, CommandExecutionContext context, Supplier<PulsarAdmin> pulsarAdmin) {
        List commands = group.commands(context);
        String description = group.description();
        try {
            ClassPool pool = ClassPool.getDefault();
            CtClass ctClass = pool.makeClass("CustomCommandGroup" + group + "_" + System.nanoTime());
            ctClass.setSuperclass(pool.get(CmdBaseAdapter.class.getName()));
            ClassFile classFile = ctClass.getClassFile();
            ConstPool constpool = classFile.getConstPool();
            AnnotationsAttribute annotationsAttribute = new AnnotationsAttribute(constpool, "RuntimeVisibleAnnotations");
            Annotation annotation = new Annotation(CommandLine.Command.class.getName(), constpool);
            ArrayMemberValue descArrayMemberValue = new ArrayMemberValue(classFile.getConstPool());
            descArrayMemberValue.setValue(new MemberValue[]{new StringMemberValue(description, classFile.getConstPool())});
            annotation.addMemberValue("description", (MemberValue)descArrayMemberValue);
            annotation.addMemberValue("name", (MemberValue)new StringMemberValue(group.name(), classFile.getConstPool()));
            annotationsAttribute.setAnnotation(annotation);
            ctClass.getClassFile().addAttribute((AttributeInfo)annotationsAttribute);
            CtClass[] params = new CtClass[]{pool.get(String.class.getName()), pool.get(Supplier.class.getName()), pool.get(List.class.getName()), pool.get(CommandExecutionContext.class.getName())};
            CtConstructor ctor = CtNewConstructor.make((CtClass[])params, null, (int)2, null, null, (CtClass)ctClass);
            ctClass.addConstructor(ctor);
            return ctClass.toClass().getConstructor(String.class, Supplier.class, List.class, CommandExecutionContext.class).newInstance(group.name(), pulsarAdmin, commands, context);
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    private static DecoratedCommand generateCustomCommand(String group, String name, CustomCommand command) {
        try {
            String description = command.description();
            ClassPool pool = ClassPool.getDefault();
            CtClass ctClass = pool.makeClass("CustomCommand" + group + "_" + name + "_" + System.nanoTime());
            ctClass.setSuperclass(pool.get(DecoratedCommand.class.getName()));
            ClassFile classFile = ctClass.getClassFile();
            ConstPool constpool = classFile.getConstPool();
            AnnotationsAttribute annotationsAttribute = new AnnotationsAttribute(constpool, "RuntimeVisibleAnnotations");
            Annotation annotation = new Annotation(CommandLine.Command.class.getName(), constpool);
            ArrayMemberValue descArrayMemberValue = new ArrayMemberValue(classFile.getConstPool());
            descArrayMemberValue.setValue(new MemberValue[]{new StringMemberValue(description, classFile.getConstPool())});
            annotation.addMemberValue("description", (MemberValue)descArrayMemberValue);
            annotation.addMemberValue("name", (MemberValue)new StringMemberValue(name, classFile.getConstPool()));
            annotationsAttribute.setAnnotation(annotation);
            ctClass.getClassFile().addAttribute((AttributeInfo)annotationsAttribute);
            List parameters = command.parameters();
            for (ParameterDescriptor parameterDescriptor : parameters) {
                Annotation fieldAnnotation;
                List parameterNames;
                CtClass fieldType = switch (parameterDescriptor.getType()) {
                    case ParameterType.BOOLEAN_FLAG -> CtClass.booleanType;
                    case ParameterType.BOOLEAN -> pool.get(Boolean.class.getName());
                    case ParameterType.INTEGER -> CtClass.intType;
                    case ParameterType.STRING -> pool.get(String.class.getName());
                    default -> throw new IllegalStateException();
                };
                if ((parameterNames = parameterDescriptor.getNames()) == null || parameterNames.isEmpty()) continue;
                String fieldName = (String)parameterNames.get(0);
                CtField field = new CtField(fieldType, fieldName, ctClass);
                AnnotationsAttribute fieldAnnotationsAttribute = new AnnotationsAttribute(constpool, "RuntimeVisibleAnnotations");
                if (!parameterDescriptor.isMainParameter()) {
                    fieldAnnotation = new Annotation(CommandLine.Option.class.getName(), constpool);
                    MemberValue[] memberValues = new MemberValue[parameterNames.size()];
                    int i = 0;
                    for (String parameterName : parameterNames) {
                        memberValues[i++] = new StringMemberValue(parameterName, classFile.getConstPool());
                    }
                    ArrayMemberValue arrayMemberValue = new ArrayMemberValue(classFile.getConstPool());
                    arrayMemberValue.setValue(memberValues);
                    fieldAnnotation.addMemberValue("names", (MemberValue)arrayMemberValue);
                    fieldAnnotation.addMemberValue("required", (MemberValue)new BooleanMemberValue(parameterDescriptor.isRequired(), classFile.getConstPool()));
                    if (parameterDescriptor.getType() == ParameterType.BOOLEAN) {
                        fieldAnnotation.addMemberValue("arity", (MemberValue)new StringMemberValue("1", classFile.getConstPool()));
                    }
                } else {
                    fieldAnnotation = new Annotation(CommandLine.Parameters.class.getName(), constpool);
                    String arityValue = parameterDescriptor.isRequired() ? "1" : "0..1";
                    fieldAnnotation.addMemberValue("arity", (MemberValue)new StringMemberValue(arityValue, classFile.getConstPool()));
                }
                ArrayMemberValue optionDescArrayMemberValue = new ArrayMemberValue(classFile.getConstPool());
                optionDescArrayMemberValue.setValue(new MemberValue[]{new StringMemberValue(parameterDescriptor.getDescription(), classFile.getConstPool())});
                fieldAnnotation.addMemberValue("description", (MemberValue)optionDescArrayMemberValue);
                fieldAnnotationsAttribute.setAnnotation(fieldAnnotation);
                field.getFieldInfo().addAttribute((AttributeInfo)fieldAnnotationsAttribute);
                field.setModifiers(1);
                ctClass.addField(field);
            }
            return (DecoratedCommand)ctClass.toClass().getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Throwable t) {
            t.printStackTrace(System.out);
            throw new RuntimeException(t);
        }
    }

    public static class CmdBaseAdapter
    extends CmdBase {
        public CmdBaseAdapter(String cmdName, Supplier<PulsarAdmin> adminSupplier, List<CustomCommand> customCommands, CommandExecutionContext context) {
            super(cmdName, adminSupplier);
            for (CustomCommand command : customCommands) {
                String name = command.name();
                DecoratedCommand commandImpl = CustomCommandsUtils.generateCustomCommand(cmdName, name, command);
                commandImpl.setCommand(command);
                commandImpl.setContext(context);
                this.addCommand(name, commandImpl);
            }
        }
    }

    public static class DecoratedCommand
    extends CliCommand {
        private CustomCommand command;
        private CommandExecutionContext context;

        @Override
        public void run() throws Exception {
            HashMap<String, Object> parameters = new HashMap<String, Object>();
            for (Field f : this.getClass().getFields()) {
                parameters.put(f.getName(), f.get(this));
            }
            this.command.execute(parameters, this.context);
        }

        @Generated
        public void setCommand(CustomCommand command) {
            this.command = command;
        }

        @Generated
        public void setContext(CommandExecutionContext context) {
            this.context = context;
        }
    }
}

