# PIP-275: Rename numWorkerThreadsForNonPersistentTopic to topicOrderedExecutorThreadNum

# Background knowledge
As we can see from the [doc](https://github.com/apache/pulsar/blob/ac46e2e4fc48dff74233623afa3635ef5285e34d/pulsar-broker-common/src/main/java/org/apache/pulsar/broker/ServiceConfiguration.java#LL1194C16-L1194C72) that `numWorkerThreadsForNonPersistentTopic` is a configuration to specify the number of worker threads to serve non-persistent topic.
Actually, `numWorkerThreadsForNonPersistentTopic` will specify the thread number of `BrokerService#topicOrderedExecutor`. Initially it was meant only for non-persistent topics,
but now it is used for anything that needs to be done under strict order for a topic, like processing Subscriptions even for a persistent topic:
* There is only one place invoke `topicOrderedExecutor` for non-persistent topics.[[1]](https://github.com/apache/pulsar/blob/50b9a93e42e412d9f17b1637287d1a4c7c7ab148/pulsar-broker/src/main/java/org/apache/pulsar/broker/service/ServerCnx.java#L1706)
* Other places will invoke `topicOrderedExecutor` for persistent-topic or persistent-dispatcher. [[2]](https://github.com/apache/pulsar/blob/50b9a93e42e412d9f17b1637287d1a4c7c7ab148/pulsar-broker/src/main/java/org/apache/pulsar/broker/service/persistent/PersistentDispatcherMultipleConsumers.java#L141) [[3]](https://github.com/apache/pulsar/blob/50b9a93e42e412d9f17b1637287d1a4c7c7ab148/pulsar-broker/src/main/java/org/apache/pulsar/broker/service/persistent/PersistentTopic.java#L279) [[4]](https://github.com/apache/pulsar/blob/50b9a93e42e412d9f17b1637287d1a4c7c7ab148/pulsar-broker/src/main/java/org/apache/pulsar/broker/service/persistent/PersistentDispatcherSingleActiveConsumer.java#L82) [[5]](https://github.com/apache/pulsar/blob/50b9a93e42e412d9f17b1637287d1a4c7c7ab148/pulsar-broker/src/main/java/org/apache/pulsar/broker/service/persistent/PersistentStickyKeyDispatcherMultipleConsumers.java#L395)

# Motivation

Making this config has a better name and increase the ability of users to understand what they are configuring.

# High Level Design

Introduce `topicOrderedExecutorThreadNum` to deprecate `numWorkerThreadsForNonPersistentTopic`.

# Detailed Design

## Design & Implementation Details

### Configuration

* Introduce `topicOrderedExecutorThreadNum` with default value `Runtime.getRuntime().availableProcessors()`:
```
private int topicOrderedExecutorThreadNum = Runtime.getRuntime().availableProcessors();
```
* deprecate `numWorkerThreadsForNonPersistentTopic` and change it's default value from `Runtime.getRuntime().availableProcessors()` to `-1`:
```
private int numWorkerThreadsForNonPersistentTopic = -1;
```
* Overwrite method `ServiceConfiguration#getTopicOrderedExecutorThreadNum()` from lombok.
```
public int getTopicOrderedExecutorThreadNum() {
        return numWorkerThreadsForNonPersistentTopic > 0
                ? numWorkerThreadsForNonPersistentTopic : topicOrderedExecutorThreadNum;
    }
```

*  And all places calling `ServiceConfiguration#getNumWorkerThreadsForNonPersistentTopic()` will call `ServiceConfiguration#getTopicOrderedExecutorThreadNum()` instead.

# Backward & Forward Compatibility
Because we have overwritten method `getTopicOrderedExecutorThreadNum()` from lombok, so:
* if user doesn't set the `numWorkerThreadsForNonPersistentTopic`, the value of worker threads will keep `Runtime.getRuntime().availableProcessors()`
* If user has set the `numWorkerThreadsForNonPersistentTopic`, the value will keep what user set before.


# Links
* Mailing List discussion thread: https://lists.apache.org/thread/hx8v824v5wdoz3kn44s4t9pzgfnqkt1o
* Mailing List voting thread: https://lists.apache.org/thread/ywk6z440qt0vs32210799m508gbxfshm