/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.mledger.impl;

import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.metrics.BatchCallback;
import io.opentelemetry.api.metrics.Meter;
import io.opentelemetry.api.metrics.ObservableLongMeasurement;
import io.opentelemetry.api.metrics.ObservableMeasurement;
import org.apache.bookkeeper.mledger.ManagedLedger;
import org.apache.bookkeeper.mledger.ManagedLedgerAttributes;
import org.apache.bookkeeper.mledger.ManagedLedgerMXBean;
import org.apache.bookkeeper.mledger.impl.ManagedLedgerFactoryImpl;

public class OpenTelemetryManagedLedgerStats
implements AutoCloseable {
    public static final String ADD_ENTRY_COUNTER = "pulsar.broker.managed_ledger.message.outgoing.count";
    private final ObservableLongMeasurement addEntryCounter;
    public static final String BYTES_OUT_COUNTER = "pulsar.broker.managed_ledger.message.outgoing.logical.size";
    private final ObservableLongMeasurement bytesOutCounter;
    public static final String BYTES_OUT_WITH_REPLICAS_COUNTER = "pulsar.broker.managed_ledger.message.outgoing.replicated.size";
    private final ObservableLongMeasurement bytesOutWithReplicasCounter;
    public static final String BACKLOG_COUNTER = "pulsar.broker.managed_ledger.backlog.count";
    private final ObservableLongMeasurement backlogCounter;
    public static final String READ_ENTRY_COUNTER = "pulsar.broker.managed_ledger.message.incoming.count";
    private final ObservableLongMeasurement readEntryCounter;
    public static final String BYTES_IN_COUNTER = "pulsar.broker.managed_ledger.message.incoming.size";
    private final ObservableLongMeasurement bytesInCounter;
    public static final String READ_ENTRY_CACHE_MISS_COUNTER = "pulsar.broker.managed_ledger.message.incoming.cache.miss.count";
    private final ObservableLongMeasurement readEntryCacheMissCounter;
    public static final String MARK_DELETE_COUNTER = "pulsar.broker.managed_ledger.mark_delete.count";
    private final ObservableLongMeasurement markDeleteCounter;
    private final BatchCallback batchCallback;

    public OpenTelemetryManagedLedgerStats(OpenTelemetry openTelemetry, ManagedLedgerFactoryImpl factory) {
        Meter meter = openTelemetry.getMeter("org.apache.pulsar.broker");
        this.addEntryCounter = meter.upDownCounterBuilder(ADD_ENTRY_COUNTER).setUnit("{operation}").setDescription("The number of write operations to this ledger.").buildObserver();
        this.bytesOutCounter = meter.counterBuilder(BYTES_OUT_COUNTER).setUnit("By").setDescription("The total number of messages bytes written to this ledger, excluding replicas.").buildObserver();
        this.bytesOutWithReplicasCounter = meter.counterBuilder(BYTES_OUT_WITH_REPLICAS_COUNTER).setUnit("By").setDescription("The total number of messages bytes written to this ledger, including replicas.").buildObserver();
        this.backlogCounter = meter.upDownCounterBuilder(BACKLOG_COUNTER).setUnit("{message}").setDescription("The number of messages in backlog for all consumers from this ledger.").buildObserver();
        this.readEntryCounter = meter.upDownCounterBuilder(READ_ENTRY_COUNTER).setUnit("{operation}").setDescription("The number of read operations from this ledger.").buildObserver();
        this.bytesInCounter = meter.counterBuilder(BYTES_IN_COUNTER).setUnit("By").setDescription("The total number of messages bytes read from this ledger.").buildObserver();
        this.readEntryCacheMissCounter = meter.upDownCounterBuilder(READ_ENTRY_CACHE_MISS_COUNTER).setUnit("{operation}").setDescription("The number of cache misses during read operations from this ledger.").buildObserver();
        this.markDeleteCounter = meter.counterBuilder(MARK_DELETE_COUNTER).setUnit("{operation}").setDescription("The total number of mark delete operations for this ledger.").buildObserver();
        this.batchCallback = meter.batchCallback(() -> factory.getManagedLedgers().values().forEach(this::recordMetrics), (ObservableMeasurement)this.addEntryCounter, new ObservableMeasurement[]{this.bytesOutCounter, this.bytesOutWithReplicasCounter, this.backlogCounter, this.readEntryCounter, this.bytesInCounter, this.readEntryCacheMissCounter, this.markDeleteCounter});
    }

    @Override
    public void close() {
        this.batchCallback.close();
    }

    private void recordMetrics(ManagedLedger ml) {
        ManagedLedgerMXBean stats = ml.getStats();
        ManagedLedgerAttributes ledgerAttributeSet = ml.getManagedLedgerAttributes();
        Attributes attributes = ledgerAttributeSet.getAttributes();
        Attributes attributesSucceed = ledgerAttributeSet.getAttributesOperationSucceed();
        Attributes attributesFailure = ledgerAttributeSet.getAttributesOperationFailure();
        this.addEntryCounter.record(stats.getAddEntrySucceedTotal(), attributesSucceed);
        this.addEntryCounter.record(stats.getAddEntryErrorsTotal(), attributesFailure);
        this.bytesOutCounter.record(stats.getAddEntryBytesTotal(), attributes);
        this.bytesOutWithReplicasCounter.record(stats.getAddEntryWithReplicasBytesTotal(), attributes);
        this.readEntryCounter.record(stats.getReadEntriesSucceededTotal(), attributesSucceed);
        this.readEntryCounter.record(stats.getReadEntriesErrorsTotal(), attributesFailure);
        this.bytesInCounter.record(stats.getReadEntriesBytesTotal(), attributes);
        this.backlogCounter.record(stats.getNumberOfMessagesInBacklog(), attributes);
        this.markDeleteCounter.record(stats.getMarkDeleteTotal(), attributes);
        this.readEntryCacheMissCounter.record(stats.getReadEntriesOpsCacheMissesTotal(), attributes);
    }
}

