/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl.auth;

import com.google.common.annotations.VisibleForTesting;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.pulsar.client.api.Authentication;
import org.apache.pulsar.client.api.AuthenticationDataProvider;
import org.apache.pulsar.client.api.EncodedAuthenticationParameterSupport;
import org.apache.pulsar.client.api.PulsarClientException;
import org.apache.pulsar.client.impl.AuthenticationUtil;
import org.apache.pulsar.client.impl.auth.AuthenticationDataTls;

public class AuthenticationTls
implements Authentication,
EncodedAuthenticationParameterSupport {
    static final String AUTH_METHOD_NAME = "tls";
    private static final long serialVersionUID = 1L;
    private String certFilePath;
    private String keyFilePath;
    @SuppressFBWarnings(value={"SE_BAD_FIELD"}, justification="Using custom serializer which Findbugs can't detect")
    private Supplier<ByteArrayInputStream> certStreamProvider;
    @SuppressFBWarnings(value={"SE_BAD_FIELD"}, justification="Using custom serializer which Findbugs can't detect")
    private Supplier<ByteArrayInputStream> keyStreamProvider;
    @SuppressFBWarnings(value={"SE_BAD_FIELD"}, justification="Using custom serializer which Findbugs can't detect")
    private Supplier<ByteArrayInputStream> trustStoreStreamProvider;

    public AuthenticationTls() {
    }

    public AuthenticationTls(String certFilePath, String keyFilePath) {
        this.certFilePath = certFilePath;
        this.keyFilePath = keyFilePath;
    }

    public AuthenticationTls(Supplier<ByteArrayInputStream> certStreamProvider, Supplier<ByteArrayInputStream> keyStreamProvider) {
        this(certStreamProvider, keyStreamProvider, null);
    }

    public AuthenticationTls(Supplier<ByteArrayInputStream> certStreamProvider, Supplier<ByteArrayInputStream> keyStreamProvider, Supplier<ByteArrayInputStream> trustStoreStreamProvider) {
        this.certStreamProvider = certStreamProvider;
        this.keyStreamProvider = keyStreamProvider;
        this.trustStoreStreamProvider = trustStoreStreamProvider;
    }

    public void close() throws IOException {
    }

    public String getAuthMethodName() {
        return AUTH_METHOD_NAME;
    }

    public AuthenticationDataProvider getAuthData() throws PulsarClientException {
        try {
            if (this.certFilePath != null && this.keyFilePath != null) {
                return new AuthenticationDataTls(this.certFilePath, this.keyFilePath);
            }
            if (this.certStreamProvider != null && this.keyStreamProvider != null) {
                return new AuthenticationDataTls(this.certStreamProvider, this.keyStreamProvider, this.trustStoreStreamProvider);
            }
        }
        catch (Exception e) {
            throw new PulsarClientException((Throwable)e);
        }
        throw new IllegalArgumentException("cert/key file path or cert/key stream must be present");
    }

    public void configure(String encodedAuthParamString) {
        Map<String, String> authParamsMap = null;
        try {
            authParamsMap = AuthenticationUtil.configureFromJsonString(encodedAuthParamString);
        }
        catch (Exception exception) {
            // empty catch block
        }
        authParamsMap = authParamsMap == null || authParamsMap.isEmpty() ? AuthenticationUtil.configureFromPulsar1AuthParamString(encodedAuthParamString) : authParamsMap;
        this.setAuthParams(authParamsMap);
    }

    @Deprecated
    public void configure(Map<String, String> authParams) {
        this.setAuthParams(authParams);
    }

    public void start() throws PulsarClientException {
    }

    private void setAuthParams(Map<String, String> authParams) {
        this.certFilePath = authParams.get("tlsCertFile");
        this.keyFilePath = authParams.get("tlsKeyFile");
    }

    @VisibleForTesting
    public String getCertFilePath() {
        return this.certFilePath;
    }

    @VisibleForTesting
    public String getKeyFilePath() {
        return this.keyFilePath;
    }

    @VisibleForTesting
    Supplier<ByteArrayInputStream> getCertStreamProvider() {
        return this.certStreamProvider;
    }

    @VisibleForTesting
    Supplier<ByteArrayInputStream> getKeyStreamProvider() {
        return this.keyStreamProvider;
    }

    @VisibleForTesting
    Supplier<ByteArrayInputStream> getTrustStoreStreamProvider() {
        return this.trustStoreStreamProvider;
    }
}

