/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.authentication.metrics;

import com.google.common.annotations.VisibleForTesting;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.metrics.DoubleHistogram;
import io.opentelemetry.api.metrics.LongCounter;
import io.opentelemetry.api.metrics.Meter;
import io.prometheus.client.Counter;
import io.prometheus.client.Histogram;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.pulsar.broker.authentication.metrics.AuthenticationMetrics;
import org.apache.pulsar.common.stats.MetricsUtil;

public class AuthenticationMetricsToken
extends AuthenticationMetrics {
    @Deprecated
    private static final Counter expiredTokenMetrics = (Counter)((Counter.Builder)((Counter.Builder)Counter.build().name("pulsar_expired_token_total")).help("Pulsar expired token")).register();
    public static final String EXPIRED_TOKEN_COUNTER_METRIC_NAME = "pulsar.authentication.token.expired.count";
    private LongCounter expiredTokensCounter;
    private static final List<Long> TOKEN_DURATION_BUCKET_BOUNDARIES_SECONDS = List.of(TimeUnit.MINUTES.toSeconds(5L), TimeUnit.MINUTES.toSeconds(10L), TimeUnit.HOURS.toSeconds(1L), TimeUnit.HOURS.toSeconds(4L), TimeUnit.DAYS.toSeconds(1L), TimeUnit.DAYS.toSeconds(7L), TimeUnit.DAYS.toSeconds(14L), TimeUnit.DAYS.toSeconds(30L), TimeUnit.DAYS.toSeconds(90L), TimeUnit.DAYS.toSeconds(180L), TimeUnit.DAYS.toSeconds(270L), TimeUnit.DAYS.toSeconds(365L));
    @Deprecated
    private static final Histogram expiringTokenMinutesMetrics = (Histogram)((Histogram.Builder)((Histogram.Builder)Histogram.build().name("pulsar_expiring_token_minutes")).help("The remaining time of expiring token in minutes")).buckets(TOKEN_DURATION_BUCKET_BOUNDARIES_SECONDS.stream().map(TimeUnit.SECONDS::toMinutes).mapToDouble(Double::valueOf).toArray()).register();
    public static final String EXPIRING_TOKEN_HISTOGRAM_METRIC_NAME = "pulsar.authentication.token.expiry.duration";
    private DoubleHistogram expiringTokenSeconds;

    public AuthenticationMetricsToken(OpenTelemetry openTelemetry, String providerName, String authMethod) {
        super(openTelemetry, providerName, authMethod);
        Meter meter = openTelemetry.getMeter("org.apache.pulsar.authentication");
        this.expiredTokensCounter = meter.counterBuilder(EXPIRED_TOKEN_COUNTER_METRIC_NAME).setDescription("The total number of expired tokens").setUnit("{token}").build();
        this.expiringTokenSeconds = meter.histogramBuilder(EXPIRING_TOKEN_HISTOGRAM_METRIC_NAME).setExplicitBucketBoundariesAdvice(TOKEN_DURATION_BUCKET_BOUNDARIES_SECONDS.stream().map(Double::valueOf).toList()).setDescription("The remaining time of expiring token in seconds").setUnit("s").build();
    }

    public void recordTokenDuration(Long durationMs) {
        if (durationMs == null) {
            this.expiringTokenSeconds.record(Double.POSITIVE_INFINITY);
        } else if (durationMs > 0L) {
            expiringTokenMinutesMetrics.observe((double)durationMs.longValue() / 60000.0);
            this.expiringTokenSeconds.record(MetricsUtil.convertToSeconds((long)durationMs, (TimeUnit)TimeUnit.MILLISECONDS));
        } else {
            this.recordTokenExpired();
        }
    }

    public void recordTokenExpired() {
        expiredTokenMetrics.inc();
        this.expiredTokensCounter.add(1L);
    }

    @Deprecated
    @VisibleForTesting
    public static void reset() {
        expiredTokenMetrics.clear();
        expiringTokenMinutesMetrics.clear();
    }
}

