/*
 * Decompiled with CFR 0.152.
 */
package io.netty.incubator.channel.uring;

import io.netty.incubator.channel.uring.IOUringCompletionQueueCallback;
import io.netty.incubator.channel.uring.Native;
import io.netty.incubator.channel.uring.UserData;
import io.netty.util.internal.PlatformDependent;

final class IOUringCompletionQueue {
    private static final int CQE_USER_DATA_FIELD = 0;
    private static final int CQE_RES_FIELD = 8;
    private static final int CQE_FLAGS_FIELD = 12;
    private static final int CQE_SIZE = 16;
    private final long kHeadAddress;
    private final long kTailAddress;
    private final long completionQueueArrayAddress;
    final int ringSize;
    final long ringAddress;
    final int ringFd;
    private final int ringMask;
    private int ringHead;

    IOUringCompletionQueue(long kHeadAddress, long kTailAddress, long kRingMaskAddress, long kRingEntriesAddress, long kOverflowAddress, long completionQueueArrayAddress, int ringSize, long ringAddress, int ringFd) {
        this.kHeadAddress = kHeadAddress;
        this.kTailAddress = kTailAddress;
        this.completionQueueArrayAddress = completionQueueArrayAddress;
        this.ringSize = ringSize;
        this.ringAddress = ringAddress;
        this.ringFd = ringFd;
        this.ringMask = PlatformDependent.getIntVolatile((long)kRingMaskAddress);
        this.ringHead = PlatformDependent.getIntVolatile((long)kHeadAddress);
    }

    boolean hasCompletions() {
        return this.ringHead != PlatformDependent.getIntVolatile((long)this.kTailAddress);
    }

    int process(IOUringCompletionQueueCallback callback) {
        int tail = PlatformDependent.getIntVolatile((long)this.kTailAddress);
        int i = 0;
        while (this.ringHead != tail) {
            long cqeAddress = this.completionQueueArrayAddress + (long)((this.ringHead & this.ringMask) * 16);
            long udata = PlatformDependent.getLong((long)(cqeAddress + 0L));
            int res = PlatformDependent.getInt((long)(cqeAddress + 8L));
            int flags = PlatformDependent.getInt((long)(cqeAddress + 12L));
            ++this.ringHead;
            PlatformDependent.putIntOrdered((long)this.kHeadAddress, (int)this.ringHead);
            ++i;
            UserData.decode(res, flags, udata, callback);
        }
        return i;
    }

    void ioUringWaitCqe() {
        int ret = Native.ioUringEnter(this.ringFd, 0, 1, Native.IORING_ENTER_GETEVENTS);
        if (ret < 0) {
            throw new RuntimeException("ioUringEnter syscall returned " + ret);
        }
    }
}

