/*
 * Decompiled with CFR 0.152.
 */
package io.netty.incubator.channel.uring;

import io.netty.incubator.channel.uring.Native;
import io.netty.incubator.channel.uring.UserData;
import io.netty.util.internal.PlatformDependent;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;

final class IOUringSubmissionQueue {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(IOUringSubmissionQueue.class);
    private static final long SQE_SIZE = 64L;
    private static final int INT_SIZE = 4;
    private static final int KERNEL_TIMESPEC_SIZE = 16;
    private static final int SQE_OP_CODE_FIELD = 0;
    private static final int SQE_FLAGS_FIELD = 1;
    private static final int SQE_IOPRIO_FIELD = 2;
    private static final int SQE_FD_FIELD = 4;
    private static final int SQE_OFFSET_FIELD = 8;
    private static final int SQE_ADDRESS_FIELD = 16;
    private static final int SQE_LEN_FIELD = 24;
    private static final int SQE_RW_FLAGS_FIELD = 28;
    private static final int SQE_USER_DATA_FIELD = 32;
    private static final int SQE_PAD_FIELD = 40;
    private static final int KERNEL_TIMESPEC_TV_SEC_FIELD = 0;
    private static final int KERNEL_TIMESPEC_TV_NSEC_FIELD = 8;
    private final long kHeadAddress;
    private final long kTailAddress;
    private final long kFlagsAddress;
    private final long kDroppedAddress;
    private final long kArrayAddress;
    final long submissionQueueArrayAddress;
    final int ringEntries;
    private final int ringMask;
    final int ringSize;
    final long ringAddress;
    final int ringFd;
    private final long timeoutMemoryAddress;
    private final int iosqeAsyncThreshold;
    private int numHandledFds;
    private int head;
    private int tail;

    IOUringSubmissionQueue(long kHeadAddress, long kTailAddress, long kRingMaskAddress, long kRingEntriesAddress, long kFlagsAddress, long kDroppedAddress, long kArrayAddress, long submissionQueueArrayAddress, int ringSize, long ringAddress, int ringFd, int iosqeAsyncThreshold) {
        this.kHeadAddress = kHeadAddress;
        this.kTailAddress = kTailAddress;
        this.kFlagsAddress = kFlagsAddress;
        this.kDroppedAddress = kDroppedAddress;
        this.kArrayAddress = kArrayAddress;
        this.submissionQueueArrayAddress = submissionQueueArrayAddress;
        this.ringSize = ringSize;
        this.ringAddress = ringAddress;
        this.ringFd = ringFd;
        this.ringEntries = PlatformDependent.getIntVolatile((long)kRingEntriesAddress);
        this.ringMask = PlatformDependent.getIntVolatile((long)kRingMaskAddress);
        this.head = PlatformDependent.getIntVolatile((long)kHeadAddress);
        this.tail = PlatformDependent.getIntVolatile((long)kTailAddress);
        this.timeoutMemoryAddress = PlatformDependent.allocateMemory((long)16L);
        this.iosqeAsyncThreshold = iosqeAsyncThreshold;
        PlatformDependent.setMemory((long)submissionQueueArrayAddress, (long)((long)this.ringEntries * 64L), (byte)0);
        long address = kArrayAddress;
        int i = 0;
        while (i < this.ringEntries) {
            PlatformDependent.putInt((long)address, (int)i);
            ++i;
            address += 4L;
        }
    }

    void incrementHandledFds() {
        ++this.numHandledFds;
    }

    void decrementHandledFds() {
        --this.numHandledFds;
        assert (this.numHandledFds >= 0);
    }

    private int flags() {
        return this.numHandledFds < this.iosqeAsyncThreshold ? 0 : Native.IOSQE_ASYNC;
    }

    boolean enqueueSqe(byte op, int flags, int rwFlags, int fd, long bufferAddress, int length, long offset, short data) {
        int submitted;
        boolean submit;
        int pending = this.tail - this.head;
        boolean bl = submit = pending == this.ringEntries;
        if (submit && (submitted = this.submit()) == 0) {
            throw new RuntimeException("SQ ring full and no submissions accepted");
        }
        long sqe = this.submissionQueueArrayAddress + (long)(this.tail++ & this.ringMask) * 64L;
        this.setData(sqe, op, flags, rwFlags, fd, bufferAddress, length, offset, data);
        return submit;
    }

    private void setData(long sqe, byte op, int flags, int rwFlags, int fd, long bufferAddress, int length, long offset, short data) {
        PlatformDependent.putByte((long)(sqe + 0L), (byte)op);
        PlatformDependent.putByte((long)(sqe + 1L), (byte)((byte)flags));
        PlatformDependent.putInt((long)(sqe + 4L), (int)fd);
        PlatformDependent.putLong((long)(sqe + 8L), (long)offset);
        PlatformDependent.putLong((long)(sqe + 16L), (long)bufferAddress);
        PlatformDependent.putInt((long)(sqe + 24L), (int)length);
        PlatformDependent.putInt((long)(sqe + 28L), (int)rwFlags);
        long userData = UserData.encode(fd, op, data);
        PlatformDependent.putLong((long)(sqe + 32L), (long)userData);
        if (logger.isTraceEnabled()) {
            logger.trace("UserDataField: {}", (Object)userData);
            logger.trace("BufferAddress: {}", (Object)bufferAddress);
            logger.trace("Length: {}", (Object)length);
            logger.trace("Offset: {}", (Object)offset);
        }
    }

    boolean addTimeout(long nanoSeconds, short extraData) {
        this.setTimeout(nanoSeconds);
        return this.enqueueSqe(Native.IORING_OP_TIMEOUT, 0, 0, -1, this.timeoutMemoryAddress, 1, 0L, extraData);
    }

    boolean removeTimeout(short extraData) {
        return this.enqueueSqe(Native.IORING_OP_TIMEOUT_REMOVE, 0, 0, -1, UserData.encode(-1, Native.IORING_OP_TIMEOUT, extraData), 0, 0L, extraData);
    }

    boolean addPollIn(int fd) {
        return this.addPoll(fd, Native.POLLIN);
    }

    boolean addPollRdHup(int fd) {
        return this.addPoll(fd, Native.POLLRDHUP);
    }

    boolean addPollOut(int fd) {
        return this.addPoll(fd, Native.POLLOUT);
    }

    private boolean addPoll(int fd, int pollMask) {
        return this.enqueueSqe(Native.IORING_OP_POLL_ADD, 0, pollMask, fd, 0L, 0, 0L, (short)pollMask);
    }

    boolean addRecvmsg(int fd, long msgHdr, short extraData) {
        return this.enqueueSqe(Native.IORING_OP_RECVMSG, this.flags(), Native.MSG_DONTWAIT, fd, msgHdr, 1, 0L, extraData);
    }

    boolean addSendmsg(int fd, long msgHdr, short extraData) {
        return this.addSendmsg(fd, msgHdr, 0, extraData);
    }

    boolean addSendmsg(int fd, long msgHdr, int flags, short extraData) {
        return this.enqueueSqe(Native.IORING_OP_SENDMSG, this.flags(), Native.MSG_DONTWAIT | flags, fd, msgHdr, 1, 0L, extraData);
    }

    boolean addRead(int fd, long bufferAddress, int pos, int limit, short extraData) {
        return this.enqueueSqe(Native.IORING_OP_READ, this.flags(), 0, fd, bufferAddress + (long)pos, limit - pos, 0L, extraData);
    }

    boolean addEventFdRead(int fd, long bufferAddress, int pos, int limit, short extraData) {
        return this.enqueueSqe(Native.IORING_OP_READ, 0, 0, fd, bufferAddress + (long)pos, limit - pos, 0L, extraData);
    }

    boolean addWrite(int fd, long bufferAddress, int pos, int limit, short extraData) {
        return this.enqueueSqe(Native.IORING_OP_WRITE, this.flags(), 0, fd, bufferAddress + (long)pos, limit - pos, 0L, extraData);
    }

    boolean addRecv(int fd, long bufferAddress, int pos, int limit, short extraData) {
        return this.enqueueSqe(Native.IORING_OP_RECV, this.flags(), 0, fd, bufferAddress + (long)pos, limit - pos, 0L, extraData);
    }

    boolean addSend(int fd, long bufferAddress, int pos, int limit, short extraData) {
        return this.enqueueSqe(Native.IORING_OP_SEND, this.flags(), 0, fd, bufferAddress + (long)pos, limit - pos, 0L, extraData);
    }

    boolean addAccept(int fd, long address, long addressLength, short extraData) {
        return this.enqueueSqe(Native.IORING_OP_ACCEPT, this.flags(), Native.SOCK_NONBLOCK | Native.SOCK_CLOEXEC, fd, address, 0, addressLength, extraData);
    }

    boolean addPollRemove(int fd, int pollMask) {
        assert (pollMask <= Short.MAX_VALUE && pollMask >= Short.MIN_VALUE);
        return this.enqueueSqe(Native.IORING_OP_POLL_REMOVE, 0, 0, fd, UserData.encode(fd, Native.IORING_OP_POLL_ADD, (short)pollMask), 0, 0L, (short)pollMask);
    }

    boolean addConnect(int fd, long socketAddress, long socketAddressLength, short extraData) {
        return this.enqueueSqe(Native.IORING_OP_CONNECT, this.flags(), 0, fd, socketAddress, 0, socketAddressLength, extraData);
    }

    boolean addWritev(int fd, long iovecArrayAddress, int length, short extraData) {
        return this.enqueueSqe(Native.IORING_OP_WRITEV, this.flags(), 0, fd, iovecArrayAddress, length, 0L, extraData);
    }

    boolean addClose(int fd, short extraData) {
        return this.enqueueSqe(Native.IORING_OP_CLOSE, this.flags(), 0, fd, 0L, 0, 0L, extraData);
    }

    int submit() {
        int submit = this.tail - this.head;
        return submit > 0 ? this.submit(submit, 0, 0) : 0;
    }

    int submitAndWait() {
        int submit = this.tail - this.head;
        if (submit > 0) {
            return this.submit(submit, 1, Native.IORING_ENTER_GETEVENTS);
        }
        assert (submit == 0);
        int ret = Native.ioUringEnter(this.ringFd, 0, 1, Native.IORING_ENTER_GETEVENTS);
        if (ret < 0) {
            throw new RuntimeException("ioUringEnter syscall returned " + ret);
        }
        return ret;
    }

    private int submit(int toSubmit, int minComplete, int flags) {
        PlatformDependent.putIntOrdered((long)this.kTailAddress, (int)this.tail);
        int ret = Native.ioUringEnter(this.ringFd, toSubmit, minComplete, flags);
        this.head = PlatformDependent.getIntVolatile((long)this.kHeadAddress);
        if (ret != toSubmit) {
            if (ret < 0) {
                throw new RuntimeException("ioUringEnter syscall returned " + ret);
            }
            logger.warn("Not all submissions succeeded");
        }
        return ret;
    }

    private void setTimeout(long timeoutNanoSeconds) {
        long nanoSeconds;
        long seconds;
        if (timeoutNanoSeconds == 0L) {
            seconds = 0L;
            nanoSeconds = 0L;
        } else {
            seconds = (int)Math.min(timeoutNanoSeconds / 1000000000L, Integer.MAX_VALUE);
            nanoSeconds = (int)Math.max(timeoutNanoSeconds - seconds * 1000000000L, 0L);
        }
        PlatformDependent.putLong((long)(this.timeoutMemoryAddress + 0L), (long)seconds);
        PlatformDependent.putLong((long)(this.timeoutMemoryAddress + 8L), (long)nanoSeconds);
    }

    public long count() {
        return this.tail - this.head;
    }

    public void release() {
        PlatformDependent.freeMemory((long)this.timeoutMemoryAddress);
    }
}

