/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.metadata.impl.stats;

import io.prometheus.client.Counter;
import io.prometheus.client.Histogram;
import java.util.concurrent.atomic.AtomicBoolean;

public final class MetadataStoreStats
implements AutoCloseable {
    private static final double[] BUCKETS = new double[]{1.0, 3.0, 5.0, 10.0, 20.0, 50.0, 100.0, 200.0, 500.0, 1000.0, 2000.0, 5000.0};
    private static final String OPS_TYPE_LABEL_NAME = "type";
    private static final String METADATA_STORE_LABEL_NAME = "name";
    private static final String STATUS = "status";
    private static final String OPS_TYPE_GET = "get";
    private static final String OPS_TYPE_DEL = "del";
    private static final String OPS_TYPE_PUT = "put";
    private static final String STATUS_SUCCESS = "success";
    private static final String STATUS_FAIL = "fail";
    protected static final String PREFIX = "pulsar_metadata_store_";
    private static final Histogram OPS_LATENCY = (Histogram)((Histogram.Builder)((Histogram.Builder)Histogram.build((String)"pulsar_metadata_store_ops_latency", (String)"-").unit("ms")).buckets(BUCKETS).labelNames(new String[]{"name", "type", "status"})).register();
    private static final Counter PUT_BYTES = (Counter)((Counter.Builder)((Counter.Builder)Counter.build((String)"pulsar_metadata_store_put", (String)"-").unit("bytes")).labelNames(new String[]{"name"})).register();
    private final Histogram.Child getOpsSucceedChild;
    private final Histogram.Child delOpsSucceedChild;
    private final Histogram.Child putOpsSucceedChild;
    private final Histogram.Child getOpsFailedChild;
    private final Histogram.Child delOpsFailedChild;
    private final Histogram.Child putOpsFailedChild;
    private final Counter.Child putBytesChild;
    private final String metadataStoreName;
    private final AtomicBoolean closed = new AtomicBoolean(false);

    public MetadataStoreStats(String metadataStoreName) {
        this.metadataStoreName = metadataStoreName;
        this.getOpsSucceedChild = (Histogram.Child)OPS_LATENCY.labels(new String[]{metadataStoreName, OPS_TYPE_GET, STATUS_SUCCESS});
        this.delOpsSucceedChild = (Histogram.Child)OPS_LATENCY.labels(new String[]{metadataStoreName, OPS_TYPE_DEL, STATUS_SUCCESS});
        this.putOpsSucceedChild = (Histogram.Child)OPS_LATENCY.labels(new String[]{metadataStoreName, OPS_TYPE_PUT, STATUS_SUCCESS});
        this.getOpsFailedChild = (Histogram.Child)OPS_LATENCY.labels(new String[]{metadataStoreName, OPS_TYPE_GET, STATUS_FAIL});
        this.delOpsFailedChild = (Histogram.Child)OPS_LATENCY.labels(new String[]{metadataStoreName, OPS_TYPE_DEL, STATUS_FAIL});
        this.putOpsFailedChild = (Histogram.Child)OPS_LATENCY.labels(new String[]{metadataStoreName, OPS_TYPE_PUT, STATUS_FAIL});
        this.putBytesChild = (Counter.Child)PUT_BYTES.labels(new String[]{metadataStoreName});
    }

    public void recordGetOpsSucceeded(long millis) {
        this.getOpsSucceedChild.observe((double)millis);
    }

    public void recordDelOpsSucceeded(long millis) {
        this.delOpsSucceedChild.observe((double)millis);
    }

    public void recordPutOpsSucceeded(long millis, int bytes) {
        this.putOpsSucceedChild.observe((double)millis);
        this.putBytesChild.inc((double)bytes);
    }

    public void recordGetOpsFailed(long millis) {
        this.getOpsFailedChild.observe((double)millis);
    }

    public void recordDelOpsFailed(long millis) {
        this.delOpsFailedChild.observe((double)millis);
    }

    public void recordPutOpsFailed(long millis) {
        this.putOpsFailedChild.observe((double)millis);
    }

    @Override
    public void close() throws Exception {
        if (this.closed.compareAndSet(false, true)) {
            OPS_LATENCY.remove(new String[]{this.metadataStoreName, OPS_TYPE_GET, STATUS_SUCCESS});
            OPS_LATENCY.remove(new String[]{this.metadataStoreName, OPS_TYPE_DEL, STATUS_SUCCESS});
            OPS_LATENCY.remove(new String[]{this.metadataStoreName, OPS_TYPE_PUT, STATUS_SUCCESS});
            OPS_LATENCY.remove(new String[]{this.metadataStoreName, OPS_TYPE_GET, STATUS_FAIL});
            OPS_LATENCY.remove(new String[]{this.metadataStoreName, OPS_TYPE_DEL, STATUS_FAIL});
            OPS_LATENCY.remove(new String[]{this.metadataStoreName, OPS_TYPE_PUT, STATUS_FAIL});
            PUT_BYTES.remove(new String[]{this.metadataStoreName});
        }
    }
}

